# This is the LDAP driver for squid-auth

my %__External_cache = ();

sub External_authenticate_user
{
    my $config = $_[0];
    my $mod_home = $_[1];
    my $uid = $_[2];
    my $realm = $_[3];
    my $passwd = $_[4];

    # First, make sure we have the config parameters we need
    my $program = $config->{'program'};
    defined( $program ) or return error( "No external program specified in $realm\'s configuration" );

    my $args = $config->{'arguments'};
    defined( $args ) or return error( "No argument format given in $realm\'s configuration" );

    # Now, perform the substitution on the arguments string
    while ( $args =~ /%{.*}/ )
    {
        $args =~ s/%{realm}/${realm}/g;
    }

    # Check the cache for an already-open handle to
    # the program, or create a new one, and do the
    # IPC to get the result
    return 1;
}

1;
