#!/usr/bin/perl
#
# Written by: Diego Rivera (diego@nomadic-solutions.com)
# 
# This program is free for modification and use according
# to the terms of the LGPL.
#
# The only requirement is that you notify me of any
# changes or additions you (or anyone on your behalf) make.
#
# Enjoy!

# This is where I think it should reside - for testing
# we put everything in the same directory so it's easy
# to edit files.

$config_dir = "/etc/squid/squid-auth";
require( "$config_dir/utils.ph" );

my $realm = $ARGV[0];

unless ( defined( $realm ) )
{
    error( "No realm given for tests!" );
    exit( 1 );
}

unless ( defined( $realms{$realm} ) )
{
    error( "Realm '$realm' is not defined" );
    exit( 1 );
}

$| = 2;
$| = 1;
while ( <STDIN> )
{
    chomp();
    my $username = $_;

    unless ( $username ne "" )
    {
        error( "Empty username" );
        next;
    }

    unless ( $username =~ /([^@]+)@([^@]+)+/ )
    {
        error( "Username not in e-mail form (abc\@domain.com)" );
        next;
    }

    my $user_realm = $2;

    my $status = "OK";
    $status = "ERR" unless ( $realm eq $user_realm );
    print( STDOUT "$status\n" );
}
