#!/usr/bin/perl
#
# Written by: Diego Rivera (diego@nomadic-solutions.com)
# 
# This program is free for modification and use according
# to the terms of the LGPL.
#
# The only requirement is that you notify me of any
# changes or additions you (or anyone on your behalf) make.
#
# Enjoy!

# This is where I think it should reside - for testing
# we put everything in the same directory so it's easy
# to edit files.

$config_dir = "/etc/squid/squid-auth";
require( "$config_dir/utils.ph" );

sub authenticate_user
{
    my $fulluid = $_[0];
    my $passwd = $_[1];

    my $realm = "";
    my $userid = "";

    ( $fulluid ne "" ) or return error( "Empty username" );

    # Extract the realm info
    ( $fulluid =~ /([^@]+)@([^@]+)+/ ) or return error( "Username not in e-mail form (abc\@domain.com)" );

    $userid = $1;
    $realm = $2;

    # No empty realm names allowed
    ( $realm ne "" ) or return error( "Empty realm in username" );

    # No %{} data allowed, to prevent undesired manipulation
    ( $userid =~ /%{.*}/ ) and return error( "Invalid user id: '$userid'" );
    ( $realm =~ /%{.*}/ ) and return error( "Invalid realm: '$realm'" );

    my $cfg = $realms{$realm};
    defined( $cfg ) or return error( "No configuration found for realm '$realm'" );

    my $driver = $cfg->{'driver'};
    defined( $driver ) or return error( "No driver defined in $realm\'s configuration" );
    ( $driver ne "" ) or return error( "Driver name is empty in $realm\'s configuration" );

    debug( 1, "User = '$userid', Realm = '$realm' (using driver '$driver')" );

    my $driver_file = "$driver_base/$driver.ph";
    ( -f $driver_file ) or return error( "No driver file '$driver_file' in '$driver_base'" );
    require( $driver_file );

    my $sub = "${driver}_authenticate_user";
    defined( &{$sub} ) or return error( "Driver does not define the required '$sub' subroutine" );
    return &{$sub}( $cfg, "$driver_base/$driver", $userid, $realm, $passwd );
}

$| = 2;
$| = 1;
while ( <STDIN> )
{
    chomp();
    unless (/\ /)
    {
        print( "ERR\n" );
        next;
    }
    my $username = $`;
    my $password = $';

    my $status = "OK";
    $status = "ERR" unless ( authenticate_user( $username, $password ) );
    print( STDOUT "$status\n" );
}
