#!/usr/bin/perl -T -w

#use strict;

delete @ENV{'PATH','IFS', 'CDPATH', 'ENV', 'BASH_ENV'};

use CGI qw/:standard/;
 
$template_path = '/home/lang/src/signup';
#$template_path = '/home/sqwebmail/signup';
$vadduser_bin = '/bin/echo';
#$vadduser_bin = '/var/vpopmail/bin/vadduser';
$my_domain = 'cross-cc.com';


sub die_tainted {
    my ($problem,@tainted);
    $problem = $_[0];
    open (TAINTED, "$template_path/tainted.html") || die_broken;
    @tainted = <TAINTED>;
    close(TAINTED);
    foreach (@tainted) {
	$_ =~ s/#PROBLEM#/$problem/g;
    } 
    print header(), @tainted;
    exit 1;
}

sub die_incomplete {
    my ($problem,@front);
    $problem = $_[0];
    open (INDEX, "$template_path/index.html") || die_broken;
    @front = <INDEX>;
    close (INDEX);
    foreach (@front) {
	if ($_ =~ /.*<input\ type=\"text\".*/ && $_ !~ /.*$problem.*/) {
	    if ($problem eq "username") {
		$_ =~ s/value=\"\"/value=\"$real\"/g;
	    } else { $_ =~ s/value=\"\"/value=\"$user\"/g; }
	}
        $_ =~ s/^<!--\ #INCOMPLETE\ -->$/<h1>Required\ fields\ missing<\/h1>/;
	}
    print header(), @front;
    exit 2;
}

sub die_password {
    my ($line,@front);
    open (INDEX, "$template_path/index.html") || die_broken;
    @front = <INDEX>;
    close (INDEX);
    foreach (@front) {
	if ($_ =~ /.*<input\ type=\"text\"\ name=\"([\w]+)\".*/) {
	    if ("$1" eq "username") { $_ =~ s/value=\"\"/value=\"$user\"/g; }
            else { $_ =~ s/value=\"\"/value=\"$real\"/g; }
	} 
        $_ =~ s/<!--\ #INCOMPLETE\ -->/<h1>Password\ fields\ do\ not\ match\.<\/h1>/;
        }
    print header(), @front;
    exit 2;
}

 
sub die_userexists {
    my (@exist);
    open (EXIST, "$template_path/exists.html") || die_broken;
    @exist = <EXIST>;
    close (EXIST);
    print header(), @exist;
    exit 4;
}

sub die_nodomain {
    my (@nodom);
    open (NODOM, "$template_path/nodomain.html") || die_broken;
    @nodom = <NODOM>;
    close (NODOM);
    print @nodom;
    exit 5;
}

sub die_broken {
    my (@broken);
    open (BROKEN, "$template_path/broken.html") || die "This thing is really broken... sorry!\n";
    @broken = <BROKEN>;
    close (BROKEN);
    print @broken;
    exit 99;
}

sub die_done {
    my (@done);
    open (DONE, "$template_path/done.html") || die_broken;
    @done = <DONE>;
    close (DONE);
    print header(), @done;
    exit 0;
}


#
# main ()
#
 
if (param()) {
    $username = param('username');
    $password = param('password');
    $passwordv = param('passwordv');
    $realname = param('realname');

#
# regular expression laundering of fields
#

if ($username) {
    if ($username =~ /^([\w\.\-]+)$/) {
        $user = $1;
    } else { die_tainted ('User Name'); }
}
else { $prob = "username"; }

if ($realname) {
    if ($realname =~ /^([\w\ ]+)$/) {
        $real = $1;
    } else { die_tainted ('Real Name'); }
}
else { $prob = "realname"; }

    if ($prob) { die_incomplete("$prob"); }

# got username and realname

if ($password) {
    if ($password =~ /^([\w\.\-\@\!]+)$/) {
        $pass = $1;
    } else { die_tainted ('Password'); }
}
else { die_password; }

if ($passwordv) {
    if ($passwordv =~ /^([\w\.\-\@\!]+)$/) {
        $passv = $1;
    } else { die_tainted ('Password'); }
}
else { die_password; }

    if ($pass ne $passv) { die_password; }

# got password

#
# run vadduser
#


    # don't add the domain till now so the user doesn't see it 
    if ($user !~ /.*\@.*/) { $user = $user . '@' . "$my_domain"; }

    $ret_value = system ("$vadduser_bin $user $pass -c $real");
    if ($ret_value == '65024') {
	die_userexists;
    }
    elsif ($ret_value == '64000') {
	die_nodomain;
    }
    elsif ($ret_value != '0') {
	die_broken;
    }
    die_done;
}

else {
    open (INDEX, "$template_path/index.html") || die_broken;
    @index = <INDEX>;
    close (INDEX);
    print header(), @index;
}
