<?php

/***
* This class is designed to create somewhat random passwords
* to set up initial user accounts where
* you email out the initial login information. 
* 
* Created By: Kevin Gilbertson (kevin AT gilbertsonconsulting DOT com)
* Last Updated: 4/22/02
* Updated By: Flinn Mueller (flinn AT activeintra DOT net)
* Bug Fix Unusable Character: Rolf Holtsmark <rolf AT holtsmark DOT no>
* Last Updated: 01/07/03
***/

class PWGen
{
 var $passwdchars;
 var $passwd = NULL;
 var $length;

 function PWGen($min=6, $max=8, $special=NULL, $chararray=NULL) {
    if ($chararray == NULL) {
       $this->passwdstr = "abcdefghijklmnopqrstuvwxyz";
       $this->passwdstr .= strtoupper($this->passwdstr);
       $this->passwdstr .= "1234567890";

       // add special chars to start
       if ($special) {
          $this->passwdstr .= "!@#$%";
       }
    } else {
        $this->passwdstr = $chararray;
    }

    for($i=0; $i<strlen($this->passwdstr); $i++) {
        $this->passwdchars[$i]=$this->passwdstr[$i];
    }
             
    // randomize the chars
    srand ((float)microtime()*1000000);
    shuffle($this->passwdchars);

    $this->length = rand($min, $max);

    for($i=0; $i<$this->length; $i++) {
       $charnum = rand(1, count($this->passwdchars));
       $this->passwd .= $this->passwdchars[$charnum-1];
    }    
 }

 function getPasswd() {
    return $this->passwd;
 }
 
 function getPasswdImg() {
    // create the image
    $png = ImageCreate(37,17);
    $bg = ImageColorAllocate($png,192,192,192);
    $tx = ImageColorAllocate($png,128,128,128);
    ImageFilledRectangle($png,0,0,200,80,$bg);
    srand ((float)microtime()*10000);
    ImageString($png,5,rand(1,1),rand(1,1),$this->passwd,$tx);
    //
//Slightly modified for use with the image-check patch for vqsignup
    $black = ImageColorAllocate($png, 0,0,0);
    ImageArc($png, 18, 8, 37, 17, 0, 360, $black);
    // send the image
    header("content-type: image/png");
    ImagePng($png);
    Imagedestroy($png);
 }

 function getPasswdHtml() {
 return htmlentities($this->passwd);
 }
 
}

?>
