/*
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Struts", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 */
package org.apache.struts.taglib.nested;

import javax.servlet.jsp.*;
import javax.servlet.jsp.tagext.*;
import org.apache.struts.taglib.nested.logic.*;
import org.apache.struts.taglib.html.FormTag;

/** A simple helper class that does everything that needs to be done to get this
 * tag extension to work. Knowing what tags that can define the lineage of other
 * tags, a tag asks of it to look up to the next nested tag and get it's property.
 *
 * With all tags keeping track of themselves, we only have to seek to the next
 * level were a tag will append a dot and it's own property.
 *
 * @author Arron Bates <arron@keyboardmonkey.com>
 */ 
public class NestedPropertyHelper {
  
  /**
   * The working horse method.
   * Seeks to the next parent nested tag to retrieve it's true nested property.
   * It identifies nesed tags by their implementing interfaces and via this
   * mechanism might not have to travers the entire way up the tree to get
   * to the form tag. The tag that passes itself to it also implements some of
   * these interfaces, and from that we can set the property and name attribues.
   *
   * @param tag The tag to start with
   * @param property property to append to the hierarchy
   * @return STring value of the fully qualified nested property.
   */
  public static void setNestedProperties(NestedPropertySupport tag, String property) {

    Tag namedTag = (Tag)tag;
    Tag parentTag = null;
    
    /* loop all parent tags until we get one that can be nested against  */
    do {
      namedTag = namedTag.getParent();
      
      if (parentTag == null) {
        if (namedTag instanceof NestedParentSupport ||
            namedTag instanceof NestedNameSupport   ||
            namedTag instanceof FormTag) {
          parentTag = namedTag;
        }
      }
    } while ( namedTag != null &&
              !(namedTag instanceof FormTag) &&
              !(namedTag instanceof NestedNameSupport) );

    /* Append our property after a dot. Special instance is the iterator
       where we need that index reference also */
    if (parentTag != null && parentTag instanceof NestedParentSupport) {
      property = ((NestedParentSupport)parentTag).getNestedProperty() +"."+ property;
      tag.setProperty(property);
    }
    
    /* if the tag uses the NestedNameSupport, set the name for the tag also */
    if (tag instanceof NestedNameSupport) {
      if (namedTag instanceof FormTag) {
        ((NestedNameSupport)tag).setName(((FormTag)namedTag).getName());
      } else {
        ((NestedNameSupport)tag).setName(((NestedNameSupport)namedTag).getName());
      }
    }
  }
}
