
import java.lang.*;
import java.util.*;
import javax.servlet.*;
import javax.servlet.http.*;
import org.apache.struts.action.*;
import org.apache.struts.util.*;

public class MultipageAction extends Action {


    public ActionForward perform
    (
        ActionMapping mapping,
        ActionForm form,
        HttpServletRequest request,
        HttpServletResponse response
    )
    throws ServletException
    {

        // Check if we are at the end or not.
        if (request.getParameter("next") != null && request.getParameter("page").equals("1")) {

            return mapping.findForward("page2");

        } else if (request.getParameter("previous") != null && request.getParameter("page").equals("2")) {

            return mapping.findForward("page1");
        }

        // Extract attributes we will need.
        Locale locale = getLocale(request);
        MessageResources messages = getResources();

        // Make local copies of the properties we need.
        String firstName = ((MultipageForm) form).getFirstName();
        String lastName = ((MultipageForm) form).getLastName();
        String address1 = ((MultipageForm) form).getAddress1();
        String address2 = ((MultipageForm) form).getAddress2();

        // By now, this should be correct, but we should
        // make a call to a session EJB for business rule checking!

        // ActionErrors errors = new ActionErrors();

        // set the session up with a User bean now
        User user = new User();
        user.setFullName(firstName + " " + lastName);
        user.setAddress1(address1);
        user.setAddress2(address2);

        // Save them away.
        HttpSession session = request.getSession();
        session.setAttribute("user", user);

        // Remove the obsolete form bean.
        if (mapping.getAttribute() != null) {
            if ("request".equals(mapping.getScope()))
                request.removeAttribute(mapping.getAttribute());
            else
                session.removeAttribute(mapping.getAttribute());
        }

        // Forward control to the specified success URI
        return mapping.findForward("success");

    }
}
