#
# Python sample calculator for Sugar (olpc)
#
# By Henrik Olsson <henols_at_gmail.com>
#

import gtk
import sys
import logging

from math import sqrt
from sugar.activity.Activity import Activity

_NaN = float('NaN')
    
class CalculatorActivity(Activity):
    
    def __init__(self):
        Activity.__init__(self)
        
        self.set_title("Calc")
        
        fixed = gtk.Fixed()
        self.add(fixed)
        fixed.show()
        
        frame = gtk.Frame("Calc")
        
        vBox = gtk.VBox(False, 0)
        frame.add(vBox)
        
        # Row 1
        self.display = gtk.Entry();
        self.display.set_width_chars(10)
        self.display.set_alignment(1.0)
        self.display.set_editable(False)
        
        vBox.pack_start(self.display, False, True, 5)
        self.display.show();
        
        # Row 2
        buttonRow = self.make_button_row(['7', '8', '9', 'c', '/'])
        vBox.pack_start(buttonRow, False, True, 0)

        # Row 3
        buttonRow = self.make_button_row(['4', '5', '6', '%', '*'])
        vBox.pack_start(buttonRow, False, True, 0)

        # Row 4
        buttonRow = self.make_button_row(['1', '2', '3', 'sqrt', '-'])
        vBox.pack_start(buttonRow, False, True, 0)

        # Row 5
        buttonRow = self.make_button_row(['neg', '0', '.', '=', '+'])
        vBox.pack_start(buttonRow, False, True, 0)

        vBox.show()
        vBox.set_size_request(200, -1)
        self.connect('key_press_event', self.on_key_press_event)

        fixed.put(frame, 300, 200)
        frame.show()

        self.clear()

  
    def make_button_row(self, list):
        hBox = gtk.HBox(True, 0)
        
        for bName in list:
            if bName != '':
                # add a button 
                button = gtk.Button(bName)
                button.connect("clicked", self.on_button_clicked_event, bName)
                button.show()
                hBox.pack_start(button, True, True, 0)
            else:
                # add a blank
                inv = gtk.Label()
                inv.show()
                hBox.pack_start(inv, True, True, 0)
                
        hBox.show()
        return hBox
 
        
    def digit(self, data):
        txt = self.display.get_text()
        data = str(data)
        # don't add zero to another zero
        if txt == '0' and data == '0':
            return
        if self._newValue:
            txt = ''
            self._newValue = False
        else:
            # remove the zero if we just added a dot
            if self._lastKey == '.':
                txt = txt[:len(txt)-1]
        
        self.display.set_text(txt + data)
        self._lastKey = data


    def clear(self):
        self.display.set_text('0')
        self._newValue = True
        self._lastKey = ''
        self._lastValue = _NaN
        

    def operator(self, data):
        logging.debug("operator(%s)" % (data))
        self.calculate('=')
        self._operator = data
        self._newValue = True
        self._lastValue = float(self.display.get_text())
        self._lastKey = data


    def dot(self):
        logging.debug("dot()")
        txt = self.display.get_text()
        if self._newValue:
            txt = '0'
        
        # if there are already a dot don't add one
        if '.' not in txt:
            txt = txt + '.0'
            self._lastKey = '.'
            self.display.set_text(txt)
            self._newValue = False


    def calculate(self, op):
        logging.debug("calculate(%s)" % (op))
        # if we don't have a new value or a saved we won't do any thing
        if self._newValue:
            logging.debug("equals : no new value")
            return
        
        if self._lastValue is _NaN:
            logging.debug("equals : no lastValue")
            return

        result = _NaN
        value = float(self.display.get_text())
        if op is '%':
            value = value / 100
        
        if self._operator is '+':
            result = self._lastValue + value
        elif self._operator is '-':
            result = self._lastValue - value
        elif self._operator is '*':
            result = self._lastValue * value
        elif self._operator is '/':
            result = self._lastValue / value

        logging.debug("%f %s %f = %f" % (self._lastValue, self._operator, value, result)) 
        
        self.set_display(result)
    
        self._lastValue = _NaN
        self._newValue = True
    

    def set_display(self, result):
        # remov trailing zeros and dot if they dont mean anything
        strRes = str(result)    
        i = strRes.find('.')
        if i >= 0:
            while(len(strRes) > i and (strRes[-1] is '0' or strRes[-1] is '.')):
                strRes = strRes[:(len(strRes)-1)]

        # show result in display
        self.display.set_text(strRes)


    def calcualte_sqrt(self):
        value = float(self.display.get_text())
        result = sqrt(value)

        logging.debug("sqrt(%f) = %f" % (value, result)) 
        
        self.set_display(result)

        
    def negation(self):
        displayValue = self.display.get_text()
        value = float(displayValue)
            
        if displayValue[0] is '-':
            displayValue = displayValue[1:]
        else:
            if value == 0.0:
                return
            displayValue = '-' + displayValue
            
        logging.debug("negation(%f) = %s" % (value, displayValue)) 
        self.set_display(float(displayValue))


    def backspace(self):
        logging.debug("backspace()") 
        text = self.display.get_text()
        if len(text) is 1 or (len(text) is 2 and text[0] is '-'):
            text = '0'
            self._newValue = True
        else:
            text = text[:(len(text)-1)]
        self.display.set_text(text)
        
    def on_key_press_event(self, widget, event):
        # logging.debug("on_key_press_event %s" % (event.keyval)) 
        if event.keyval == 65288: # Backspace
            self.backspace()
            return
            
        if event.keyval < 256:
            self.event_validation(chr(event.keyval))
    
    def on_button_clicked_event(self, event, data):
        # logging.debug("on_button_clicked %s" % (data)) 
        self.event_validation(data)

        
    def event_validation(self, data):    
        if data >= '0' and data <= '9':
            self.digit(data)
            return
        
        if data is '+' or data is '-' or data is '*' or data is '/':
            self.operator(data)
            return

        if data is 'c':
            self.clear()
            return

        if data is '.':
            self.dot()
            return

        if data is '=' or data is '%':
            self.calculate(data)
            return

        if data is 'sqrt' or data is 's':
            self.calcualte_sqrt()
            return
            
        if data is 'neg' or data is 'n':
            self.negation()
            return
            
            

