#ifndef CAMHEAD_H
#define CMAHEAD_H

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/mman.h>

#include <fcntl.h>
#include <errno.h>
#include <math.h>

#include <netinet/ether.h>
#include <net/ethernet.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <net/if.h>
#include <netinet/in.h>
#include <arpa/inet.h>

#include <pthread.h>
#include <signal.h>


#include "include/c313a.h"
#include "include/exifa.h"
#include "include/autoexp.h"
#include "include/driver_numbers.h"
#include "include/exifa.h"
#include "include/fpgaclocks.h"
#include "include/fpgaconfa.h"

//////////////////////////
#define TRUE 	1
#define FALSE 	0

#define BUFSIZE 2048 

#define ELPHEL_GLOBALPARS(x) (((unsigned long *) globalPars)[x-FRAMEPAR_GLOBALS])

//#define DEBUG
#ifdef DEBUG
//#define PDEBUG(x) fprintf(stderr, "%s:%d:%s\n", __FILE__, __LINE__, __FUNCTION__); x
#define PDEBUG(x)  x
#else
#define PDEBUG(x)
#endif

char ImgFileName[100];		// Save File Name
int FrameNumber;
int imgCnt; 

//////////////////////////
// exif
int fd_exif;
int fd_exifdir;
int fd_exifmeta;

int exif_size;
struct exif_dir_table_t exif_dir[ExifKmlNumber];

//access to /dev/circbuf (mmap, lseek)
int             fd_circ;
unsigned long * ccam_dma_buf;
unsigned long   ccam_dma_buf_len;       // in bytes

//access to /dev/frameparsall (write, lseek, mmap)
int             fd_fparmsall;
struct          framepars_all_t         *frameParsAll;
struct          framepars_t             *framePars;
struct          framepars_past_t        *pastPars;
unsigned long   *funcs2call;
unsigned long   *globalPars;

// access to gammas
int fd_gamma_cache;
struct gamma_stuct_t    *gamma_cache; // array of gamma structures

int fd_histogram_cache;
struct histogram_stuct_t *histogram_cache;      // array of histogram

#define CAM_GLOBALPARS(x) (((unsigned long *)globalPars)[x-FRAMEPAR_GLOBALS])

///////////////////////////////////////////////////////////////////////////

// DevInitialize.c :  353 Device Driver Open 
int Dev_Frameparsall_Open(void);
int Dev_GammaCache_Open(void);
int Dev_HistogramCache_Open(void);
int Dev_Cricbuf_Open(void);
int Dev_ExifExif_Open(void);
int Dev_ExifMetadir_Open(void);
int Dev_ExifMeta_Open(void);
int DeviceOpenInit(void);


// ControlValue.c 
long cam_get_P_value(long laddr);
long cam_set_P_value_common(long addr, long data, long frame, long flags);
long cam_set_P_value(long laddr, long ldata);
void cam_senor_reset(void);

//ControlFrame.c
int cam_get_frame(void);
long cam_wait_frame_abs(long target_frame);
long cam_skip_frames(void);

// SaveImage.c
int ImageSave(void);
int ImageSaveBuffer(int fd_circ);
int WriteImageToFile(void *buffer, int len);

#endif // CAMHEAD_H
