#include "CamHead.h"

/*
	Read value from the sensor/compressor parameters
	("read" parameters, verified by the driver)
	see c313a.h

	
*/

long cam_get_P_value(long laddr){

	long addr;
	long frame = -1;
	long frame_index = -1;
	//int frame_stored;
	long frame_stored;
	//unsigned  long frame_stored;
	
	// ????	
	if(frame < 0){
		frame = CAM_GLOBALPARS(G_THIS_FRAME);	 //Current frame number (may lag from the hardwaere
	}
	addr = laddr & 0xffff;

	if(addr >= FRAMEPAR_GLOBALS){// FRAMEPAR_GLOBALS : 0x01000  /// start of global
		if(addr >= (FRAMEPAR_GLOBALS + P_MAX_GPAR)){
			return -1;
		}

		if(laddr & FRAMEPAIR_MASK_BYTES ){
			//PDEBUG(fprintf(stderr,"=> FRAMEPAIR_FRAME_FIELD(laddr,CAM_GLOBALPARS(addr))"));
			return FRAMEPAIR_FRAME_FIELD(laddr,CAM_GLOBALPARS(addr));
		}else{
			//PDEBUG(fprintf(stderr,"=> CAM_GLOBALPARS(addr);"));
			return CAM_GLOBALPARS(addr);
		}
	}

	if((addr<0) || (addr >= (sizeof (struct framepars_t) >> 2))){
			//PDEBUG(fprintf(stderr,"=> (addr<0) || (addr >= (sizeof (struct framepars_t) >> 2)))\n"));
		return -1;
	}

	if(frame < 0){
		frame = CAM_GLOBALPARS(G_THIS_FRAME);
	}
			

	// try framePars
	frame_index = frame & PARS_FRAMES_MASK;
	//frame_stored = ((struct framepars_t*)framePars[frame_index].pars[P_FRAME]);
	frame_stored = (framePars[frame_index].pars[P_FRAME]);

	if(frame_stored == frame){
		if(laddr & FRAMEPAIR_MASK_BYTES){
			//PDEBUG(fprintf(stderr, "=> FRAMEPAIR_FRAME_FIELD(laddr,((struct framepars_t *)framePars)[frame_index].pars[addr]); \n"));
			return FRAMEPAIR_FRAME_FIELD(laddr,((struct framepars_t *)framePars)[frame_index].pars[addr]);	
		}else{
			//PDEBUG(fprintf(stderr, "=> ((struct framepars_t *)framePars)[frame_index].pars[addr];  \n"));
			return ((struct framepars_t *)framePars)[frame_index].pars[addr];
		}
	}
	

	// too late for framePars - let's try pastPars
	frame_index = frame & PASTPARS_SAVE_ENTRIES_MASK;
	//frame_stored = (struct framepars_past_t*)pastPars[frame_index].past_pars[P_FRAME - PARS_SAVE_FROM];
	frame_stored = pastPars[frame_index].past_pars[P_FRAME - PARS_SAVE_FROM];

	if( frame_stored == frame){
		addr -= PARS_SAVE_FROM;
		if((addr < 0) || (addr >= (sizeof (struct framepars_past_t) >> 2 ))){
			//PDEBUG(fprintf(stderr, "=> %d  \n", __LINE__));
			return -1;
		}
		if(laddr & FRAMEPAIR_MASK_BYTES){
			//PDEBUG(fprintf(stderr, "=> FRAMEPAIR_FRAME_FIELD(laddr,((struct framepars_past_t *)pastPars)[frame_index].past_pars[addr])  \n"));
			return FRAMEPAIR_FRAME_FIELD(laddr,((struct framepars_past_t *)pastPars)[frame_index].past_pars[addr]); 
		}else{
			//PDEBUG(fprintf(stderr, "=> ((struct framepars_past_t *)pastPars)[frame_index].past_pars[addr]  \n"));
			return ((struct framepars_past_t *)pastPars)[frame_index].past_pars[addr];
		
		}

	}

	return 0; 
}


long cam_set_P_value_common(long addr, long data, long frame, long flags){

	unsigned long write_data[4];
	long maddr;

#ifdef DEBUG
	printf("[DEBUG] %s \n", __func__);
	printf("[DEBUG] addr: %ld, data: %ld, frame: %ld, flags: %ld \n", addr, data, frame, flags);
#endif
	
	maddr = addr & 0xffff;
	if(( (addr & 0xff00) != 0xff00 ) && (maddr >= FRAMEPAR_GLOBALS)){
		if( maddr >=  (FRAMEPAR_GLOBALS+P_MAX_GPAR)) {
			return -1;
		}
		CAM_GLOBALPARS(maddr) = data;
		return 0;
	}
	if( frame < 0){
		frame = CAM_GLOBALPARS( G_THIS_FRAME) + FRAME_DEAFAULT_AHEAD;
	}
	flags |= (flags << 16);
	flags &= 0xffff0000;
	if((addr < 0) || ((maddr >= (sizeof(struct framepars_t) >> 2)) && ( (addr & 0xff00) != 0xff00 ) )){
		return -1;
	}

	write_data[0] = FRAMEPARS_SETFRAME;
	write_data[1] = frame;
	write_data[2] = addr | flags;
	write_data[3] = data;

	// /dev/fparmsall write 
	long rslt = write(fd_fparmsall, write_data, sizeof(write_data));
	
	if(rslt < 0) return -errno;
	if(rslt  ==  sizeof(write_data)) return frame;

	return -1;
}


long cam_set_P_value(long laddr, long ldata){


	long addr;
	long data;
	long frame = -1;
	unsigned long flags = 0;


	if(((frame = cam_set_P_value_common (laddr, ldata, frame, flags))) < 0){
		return -1;
	}

	return frame;

}

void cam_senor_reset(void){
 	lseek(fd_fparmsall, LSEEK_FRAMEPARS_INIT, SEEK_END ); /// reset all framepars and globalPars
        cam_set_P_value_common (P_SENSOR, 0, 0, -1); 
}



