#include "CamHead.h"



int Dev_Frameparsall_Open(void){
	// open /dev/frameparsall
	frameParsAll 	= NULL;
	framePars	= NULL;
	pastPars 	= NULL;
	funcs2call	= NULL;

	fd_fparmsall = open("/dev/frameparsall", O_RDWR);
	if(fd_fparmsall < 0){
		PDEBUG(fprintf(stderr, "Can not Open %s\n", "/dev/frameparsall")); 
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "Open  Sucess %s\n", "/dev/frameparsall" ));
	}

	frameParsAll = (struct framepars_all_t *)mmap(0,  sizeof (struct framepars_all_t) , PROT_READ | PROT_WRITE, MAP_SHARED, fd_fparmsall, 0);
	if( (int)frameParsAll == -1){
		frameParsAll = NULL;
		PDEBUG(fprintf(stderr, "Error in mmap %s\n", "/dev/frameparsall"));
		close(fd_fparmsall);
		fd_fparmsall = -1;
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "mmap  Sucess %s\n", "/dev/frameparsall" ));
	}


	framePars 	= frameParsAll->framePars;
	pastPars 	= frameParsAll->pastPars;
	funcs2call	= frameParsAll->func2call.pars;
	globalPars 	= frameParsAll->globalPars;
	
	return 1;

}

int Dev_GammaCache_Open(void){

	///////////////////////////////////////
	// open /dev/gamma_cache
	gamma_cache 	= NULL;
	fd_gamma_cache = open("/dev/gamma_cache", O_RDWR);
	if(fd_fparmsall < 0){
		PDEBUG(fprintf(stderr, "Can not Open %s\n", "/dev/gamma_cache")); 
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "Open  Sucess %s\n", "/dev/gamma_cache" ));
	}


	gamma_cache = (struct gamma_stuct_t *) mmap(0, sizeof (struct gamma_stuct_t) * GAMMA_CACHE_NUMBER , PROT_READ, MAP_SHARED, fd_gamma_cache, 0);
	if( (int)gamma_cache == -1) {
		gamma_cache=NULL;
		PDEBUG(fprintf(stderr, "Error in mmap %s\n", "/dev/gamma_cache"));
		close(fd_gamma_cache);
		fd_gamma_cache = -1;
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "mmap  Sucess %s\n", "/dev/gamma_cache" ));
	}


	return 1;
}

int Dev_HistogramCache_Open(void){

	///////////////////////////////////////
	// open /dev/histogram_cache
	histogram_cache	= NULL;
	fd_histogram_cache = open("/dev/histogram_cache", O_RDWR);
	if(fd_histogram_cache < 0){
		PDEBUG(fprintf(stderr, "Can not Open %s\n", "/dev/histogram_cache")); 
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "Open Sucess %s\n","/dev/histogram_cache" ));
	}



	histogram_cache = (struct histogram_stuct_t *) mmap(0, sizeof (struct histogram_stuct_t) * HISTOGRAM_CACHE_NUMBER , PROT_READ, MAP_SHARED, fd_histogram_cache, 0);
	if((int)histogram_cache == -1) {	
		histogram_cache=NULL;
		PDEBUG(fprintf(stderr, "Error in mmap %s\n", "/dev/histogram_cache"));
		close(fd_histogram_cache);
		fd_histogram_cache = -1;
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "mmap  Sucess %s\n", "/dev/histogram_cache"));
	}

	return 1;
}


int Dev_Cricbuf_Open(void){

	// open /cricbuf
	ccam_dma_buf 	= NULL;
	fd_circ = open("/dev/circbuf", O_RDWR);
	if(fd_circ < 0){
		PDEBUG(fprintf(stderr, "Can not Open %s\n", "/dev/circbuf")); 
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "Open Sucess %s\n", "/dev/circbuf" ));
	}

	ccam_dma_buf_len	= lseek(fd_circ, 0, SEEK_END);
	ccam_dma_buf		= (unsigned long*)mmap(0, ccam_dma_buf_len, PROT_READ | PROT_WRITE, MAP_SHARED, fd_circ, 0);

	// now try to mmap
	if( (int)ccam_dma_buf == -1 ){
		ccam_dma_buf == NULL;
		PDEBUG(fprintf(stderr, "Error in mmap %s\n", "/dev/circbuf"));
		close(fd_circ);
		fd_circ = -1;
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "mmap  Sucess %s\n", "/dev/circbuf" ));
	}


	//lseek(fd_circ, LSEEK_CIRC_NEXT, SEEK_END);
	//lseek(fd_circ, LSEEK_CIRC_READY, SEEK_END);
	

	return 1;
}

int Dev_ExifExif_Open(void){

	// open EXIF_DEV_NAME "/dev/exif_exif"
	fd_exif = open(EXIF_DEV_NAME, O_RDONLY);
	if(fd_exif < 0){
		PDEBUG(fprintf(stderr, "Can not Open %s\n", EXIF_DEV_NAME)) ;
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "Open Sucess %s\n", EXIF_DEV_NAME ));
	}

	return 1;
}	

int Dev_ExifMetadir_Open(void){
	///////////////////////////////////////
	// open EXIFDIR_DEV_NAME "/dev/exif_metadir"
	fd_exifdir = open(EXIFDIR_DEV_NAME, O_RDONLY);
	if(fd_exifdir < 0){
		PDEBUG(fprintf(stderr, "Can not Open %s\n", EXIFDIR_DEV_NAME)); 
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "Open Sucess %s\n", EXIFDIR_DEV_NAME));
	}
	return 1;
}

int Dev_ExifMeta_Open(void){

	// open EXIFMETA_DEV_NAME "/dev/exif_meta"
	fd_exifmeta = open(EXIFMETA_DEV_NAME, O_RDWR);
	if(fd_exifmeta < 0){
		PDEBUG(fprintf(stderr, "Can not Open %s\n", EXIFMETA_DEV_NAME));
		return -1;
	}else{
		PDEBUG(fprintf(stderr, "Open Sucess %s\n", EXIFMETA_DEV_NAME ));
	}

	return 1;
}

int DeviceOpenInit(void){

	if(Dev_Frameparsall_Open() < 0)return -1;
	if(Dev_GammaCache_Open() < 0) return -1;
	if(Dev_HistogramCache_Open() < 0 )return -1;
	if(Dev_Cricbuf_Open() < 0 ) return -1;
	if(Dev_ExifExif_Open() < 0) return -1;
	if(Dev_ExifMetadir_Open() < 0) return -1;
	if(Dev_ExifMeta_Open() < 0) return -1;


	PDEBUG(fprintf(stderr, "== all Device Open Sucess %s ==\n", "Elphel 353L"));

	return 1;
}

void DeviceClose(void){

	close(fd_fparmsall);
	close(fd_gamma_cache);
	close(fd_histogram_cache);
	close(fd_exifdir);
	close(fd_exifmeta);
}






