

#include "CamHead.h"

#include <time.h>

#define JPEG_HEADER_MAXSIZE	0x300
#define TRAILER_SIZE		0x02
#define TRAILER_NUM		(sizeof(trailer)/sizeof(trailer[0]))	

//char trailer[TRAILER_SIZE] = {0xff, 0xd9};
char trailer[] = {0xff, 0xd9};

// Driver File Name
const char circbufFileName[] = "/dev/circbuf";
const char jpegheadFileName[] = "/dev/jpeghead";
const char ExifFileName[] = "/dev/exif_exif";

int ImageSave(void){

	int this_p ; 

	int ret1;
	ret1 = lseek(fd_circ, LSEEK_CIRC_LAST, SEEK_END);    

	fflush(stdout);
	int ret2;
	if( ret2 = lseek(fd_circ, LSEEK_CIRC_READY, SEEK_END) < 0){ 
		fprintf(stderr, " Error LSEeK\n"); 
		//close(fd_circ);
		return 0;
	}   

	// Save Image Jpeg
	int rslt = ImageSaveBuffer(fd_circ);

	this_p = lseek(fd_circ, LSEEK_CIRC_NEXT, SEEK_END);

	fflush(stdout); // add 12 09

	PDEBUG(fprintf(stderr, "[DEBUG] Image Save Buffer Return \n" ));
	
	return 1;

}

int ImageSaveBuffer(int fd_circ){

        int exifDataSize = 0;
        int frameParamPointer = 0;
        struct interframe_params_t frame_params;

        int buff_size;
        int jpeg_len;
        //int jpeg_start;
        off_t jpeg_start; // by 1207
        int fd_head;
        int fd_exif;
        int head_size;
        int jpeg_full_size, jpeg_this_size;
        char *jpeg_copy;
        int l, i;

        jpeg_start = lseek(fd_circ, 0, SEEK_CUR);

        // Open Jpegheader driver file
        fd_head = open(jpegheadFileName, O_RDWR);
        if(fd_head < 0){
                fprintf(stderr, "Error opening %s\n", jpegheadFileName);
                return -1;
        }

        lseek(fd_head, jpeg_start+1, SEEK_END);

        head_size = lseek(fd_head, 0, SEEK_END);

        if(head_size > JPEG_HEADER_MAXSIZE){
                fprintf(stderr,"%s:%d: Too big JPEG header (%d > %d)",__FILE__,__LINE__,head_size, JPEG_HEADER_MAXSIZE);
                close(fd_head);
                return -2;
        }

        buff_size = lseek(fd_circ, 0, SEEK_END);

        lseek(fd_circ, jpeg_start, SEEK_SET);

        frameParamPointer = jpeg_start - 32;

        if(frameParamPointer < 0) frameParamPointer += buff_size;

        // jpeg header Copy
        memcpy(&frame_params, (unsigned long *)&ccam_dma_buf[frameParamPointer >>2], 32);

        // jpeg length
        jpeg_len = frame_params.frame_length;

        if(frame_params.signffff != 0xffff){
                close(fd_head);
                return -4;
        }

       // use exif 
        fd_exif = open(ExifFileName, O_RDONLY);
        if(fd_exif < 0){
                fprintf (stderr,"Error opening %s\n", ExifFileName);
                close(fd_head);
                return -5;
        }
        exifDataSize = lseek(fd_exif, 1, SEEK_END);
        if(exifDataSize < 0) exifDataSize=0;
        if(!exifDataSize) close(fd_exif);

        jpeg_full_size = jpeg_len + head_size + 2 + exifDataSize;

        // header + frame 
        jpeg_this_size = jpeg_full_size;
	
        jpeg_copy = calloc(jpeg_this_size, sizeof(char));

        if(!jpeg_copy){ // whe malloc fail
                for (i=0;i<10;i++) {
                        usleep(((jpeg_this_size & 0x3ff) + 5) * 100); // up to 0.1 sec
        		jpeg_copy = calloc(jpeg_this_size, sizeof(char));
                        if (jpeg_copy) break;
                }
                if (!jpeg_copy) {
                        exit (1);
                }
        }

        // jpeg header read 
        lseek(fd_head, 0, 0);
        read(fd_head, &jpeg_copy[exifDataSize], head_size);
        close(fd_head); // jpeg header file close 

        if (exifDataSize>0) {//! insert Exif
                //printf("jpeg copy exif data \n"); 
                memcpy (jpeg_copy, &jpeg_copy[exifDataSize], 2); //! copy first 2 bytes of the JFIF header before Exif
                lseek(fd_exif, frame_params.meta_index, SEEK_END); //! select meta page to use (matching frame)
                read (fd_exif, &jpeg_copy[2], exifDataSize);  //! Insert Exif itself
                close(fd_exif); // close device file
        }

        // 
        l = head_size+exifDataSize;

        if ((jpeg_start+jpeg_len) > buff_size) {        // two segments
		//printf("Two Segments \n"); 
                memcpy (&jpeg_copy[l], (unsigned long * ) &ccam_dma_buf[jpeg_start>>2], buff_size-jpeg_start);
                l+=buff_size-jpeg_start;
                memcpy (&jpeg_copy[l],(unsigned long * ) &ccam_dma_buf[0], jpeg_len-(buff_size-jpeg_start));
        } else {                                        /*! single segment */
		//printf("One Segments \n"); 
                memcpy (&jpeg_copy[l],(unsigned long * ) &ccam_dma_buf[jpeg_start>>2], jpeg_len);
        }


        memcpy (&jpeg_copy[jpeg_len + head_size + exifDataSize] , trailer, 2);

        int refilelen = WriteImageToFile(jpeg_copy, jpeg_full_size);

        // memory free.
        free(jpeg_copy);
}

int WriteImageToFile(void *buffer, int len){

        FILE *fd_Savefile;

        int bytesWritten;
        int bytesLeft = len;
        int offset = 0;
        char *cbuffer = (char *)buffer;

 	sprintf(ImgFileName,"img-%d.jpeg", FrameNumber);
        fd_Savefile = fopen(ImgFileName, "wb");

        while(bytesLeft > 0){ 
                bytesWritten = fwrite(&cbuffer[offset], 1, bytesLeft, fd_Savefile);   
                bytesLeft -= bytesWritten;
                offset += bytesWritten;
		//usleep(10000);
        }   

	fprintf(stderr, "Image File Name : %s \n", ImgFileName);
	//fflush(fd_Savefile);	
        fclose(fd_Savefile);

	return 1;
}




