/*
 * 05.03.2002 changing for revA
 * 03.19.2002 Started support for different sensors
 */

#ifndef _ASM_CMOSCAM_H
#define _ASM_CMOSCAM_H

//#define ELPHEL_DEBUG 0 //global debug on/off in multiple files
//#define ELPHEL_DEBUG_STARTUP 000a4c00 ; 
#define ELPHEL_DEBUG_STARTUP 0 ; 
#define ELPHEL_DEBUG 1 //global debug on/off in multiple files
#define ELPHEL_DEBUG_DELAY 100000 //delay after some printk-s
#define ELP_KERR(x) printk("%s:%d:%s: ERROR ",__FILE__,__LINE__,__FUNCTION__);x
#define ELP_FERR(x) fprintf(stderr,"%s:%d:%s: ERROR ",__FILE__,__LINE__,__FUNCTION__);x

#define USELONGLONG 1
#define ETRAXFS_MMAP_CACHE_BUG y

// _IOC_TYPE, bits 8 to 15 in ioctl cmd

#define CMOSCAM_IOCTYPE  124

/* new i2c devices */
// minors (add more later - maybe different minors for different speed - set speed when opening)
#define X3X3_I2C_CTRL       0  // control/reset i2c
#define X3X3_I2C_8_AINC     1  // 8bit  registers, autoincement while read/write
#define X3X3_I2C_16_AINC    2  // 16bit registers, autoincement while read/write
#define X3X3_I2C1_8_AINC    3  // 8bit  registers, autoincement while read/write (bus 1)
#define X3X3_I2C1_16_AINC   4  // 16bit registers, autoincement while read/write (bus 1)
#define X3X3_I2C_RAW        5  // 8bit  registers, no address byte (just slave, then read/write byte(s)
#define X3X3_I2C1_RAW       6  // 8bit  registers, no address byte (just slave, then read/write byte(s)
#define X3X3_I2C_ENABLE     7  // enable(/protect) different I2C devices for different types of I2C accesses
#define X3X3_I2C_ENABLE_RD   0 // bit 0 - enable i2c read
#define X3X3_I2C_ENABLE_WR   1 // bit 1 - enable i2c write
#define X3X3_I2C_ENABLE_RAW  2 // bit 2 - enable i2c raw (no address byte)
#define X3X3_I2C_ENABLE_8    3 // bit 3 - enable i2c 8-bit registers access
#define X3X3_I2C_ENABLE_16   4 // bit 4 - enable i2c 16-bit registers access
#define X3X3_I2C_MAXMINOR  7  //
#define X3X3_I2C_CHANNELS  2  // number of i2c channels
//xi2craw            c 134   5
//xi2craw_aux        c 134   6
//xi2cenable         c 134   7



/* camera sequencer states */



///Obsolete
#define CAMSEQ_OFF       0 // off, not programmed (Video mode off on Zoran sensors)
#define CAMSEQ_READY     1 // sensor programmed may acquire at will (programSensor sets number of frames to skip (if any)
#define CAMSEQ_SKIP      2 // skipping specified number of frames, interrupt service routine counts and will start acquisition
#define CAMSEQ_WAIT_F 	 3 // set by "start exposure" or interrupt service routine. WAIT_F/WAIT_T/acquire/done differs by hardware register
#define CAMSEQ_WAIT_T 	 4 // set by "start exposure" or interrupt service routine. Wait/acquire/done differs by hardware register
#define CAMSEQ_ACQUIRE   5 // acquisition in progress (camSeqState is still CAMSEQ_WAIT)
#define CAMSEQ_DONE      6 // acquisition over  (camSeqState is still CAMSEQ_WAIT)
#define CAMSEQ_JPEG      7 // waiting for JPEG done interrupt, acquiring/compressing some frames

#define CAMSEQ_RUN       8 // compressor is constantly running (but if camSeqCount>0 - just skipping "bad" frames)
#define CAMSEQ_STOP      9 // compressor is constantly running but will stop after next "compressor ready"
#define CAMSEQ_SINGLE   10 // compressor is constantly running to fill one full buffer
// For KAI11000 sensor board
#define	sensorcom_W_size	1024
#define	sensorcom_R_size	256

/* MCP definitions */

#define	MCP_W_size	1024
#define	MCP_R_size	256

#define	MCPOtherBits	0xffa7a7ff
#define MCPOffReset	0x00101800
#define MCPReset	0x00001800
#define MCPNoReset	0x00105800
#define MCPToggleA	0x00080000
#define MCPToggleB	0x00001000
#define MCPctlseq	0x00
#define MCPsofttg	0x02
#define MCPeackn	0x03
#define MCPctlgate	0x04
#define MCPwstdly	0x06
#define MCPwrsmsk	0x07
#define MCPwrsup	0x08
#define MCPwrmons	0x09
#define MCPwnom		0x0a
#define MCPwdenom	0x0b
#define MCPwoutw	0x0c
#define MCPwinvctl	0x0d
#define MCPctlsync	0x0e
#define MCPwrdlys	0x10
#define MCPwinv		0x40
#define MCPwshared	0x80
#define MCPwrsynctb	0x100
#define MCPwrseq	0x200


/* supported ioctl _IOC_NR's */
#ifndef I2C_WRITEARG
#define I2C_WRITEARG(bus, slave, reg, value) (((bus) << 24) | ((slave) << 16) | ((reg) << 8) | (value))
#define I2C_READARG(bus, slave, reg) (((bus) << 24) | ((slave) << 16) | ((reg) << 8))

#define I2C_ARGBUS(arg) (((arg) >> 24)  & 0x1)
#define I2C_ARGSLAVE(arg) (((arg) >> 16)  & 0xff)
#define I2C_ARGREG(arg) (((arg) >> 8) & 0xff)
#define I2C_ARGVALUE(arg) ((arg) & 0xff)

#define I2C_DELAYS   0x0   // read/write bit deleys for I2C
// return  delays, if data==0 - don't change, just read
// lower (0) byte - SCL high,
// byte 1 - SCL low
// byte 2 - slave -> master (from slave driving SDA line to master driving SDA)
// byte 3 - master -> slave (from master driving SDA line to slave driving SDA)

#define I2C_WRITEREG 0x1   // write to an i2c register
#define I2C_READREG  0x2   // read from an i2c register
#endif

// new for Micron sensors  - 16bit data, always bus 0
#ifndef I2C_16_WRITEARG
#define I2C_16_WRITEREG 0x3   // write 2 bytes to an i2c register
#define I2C_16_READREG  0x4   // read 2 bytes from an i2c register

#define I2C_16_WRITEARG(slave, reg, value) (((slave) << 24) | ((reg) << 16) | (value))
#define I2C_16_READARG(slave, reg) (((slave) << 24) | ((reg) << 16))

#define I2C_16_ARGSLAVE(arg)   (((arg) >> 24) & 0xff)
#define I2C_16_ARGREG(arg)     (((arg) >> 16) & 0xff)
#define I2C_16_ARGVALUE(arg)   ( (arg)      & 0xffff)
#define I2C_16_ARGVALUE_H(arg) (((arg) >>  8) & 0xff)
#define I2C_16_ARGVALUE_L(arg) ( (arg)        & 0xff)
#endif



// otherParamsRO[16]

#define _CCCMD(x,y)  (_IO(CMOSCAM_IOCTYPE, (x << 6) | (y & 0x3f)))



#define CCAM_CTRL(x)  ((_IOC_NR(x) >> 6) & 0x03)
#define CCAM_ADDR(x)  (_IOC_NR(x) & 0x3f)

//#define CCAM_RWSENSOR   1 /* direct read/write first 32 sensor registers */  // will not use at all
#define CCAM_RPARS      2 /* read  parameters      0..0x3f */
#define CCAM_WPARS      3 /* write parameters      0..0x3f */

/* New parameters and update logic
 * Separate read and write set of 64 registers
 * User may specify:
 *   0 - do not update
 *   1 - update at once
 *   2 - update when appropriate
 * and read update status:
 *   0 - will not be updated
 *   1 - in sync
 *   2 - waiting to be updated
 *   3 - update in progress (TODO: - support async)
 * 	When updating (validating) parameters and copying them to the read "registers" the I2C registers will be written
 *  only if they are different from the shadows
 */
/// parameter indexes will be updated to grouprelated ones into the same groups of 32
/// NOTE: P_* and G_* should not end with numbers - numbers will be used in PHP constants to add to the constant value (ELPHEL_AAA3 will be treated as ELPHEL_AAA+3)
#define P_NUMBER         1024   //number of registers (was 64) - NOTE: obsolete?
#define P_SENSOR         1     /* if set to 0 - will (re)detect sensor. If set to None - won't bother
				  4  - ZR32112MLC - now there is no way to see color/mono
				  5  - ZR32112PLC
				  8  - ZR32212MLC
				  9  - ZR32112PLC
				  32 - KAC1310-mono
				  33 - KAC1310-RGB
				  34 - KAC1310-CMY
				  36 - KAC5000
				  48 - MI1300
				  49 - MT9M001 (1280x1024,same as MI1300)
				  50 - MT9M001 (1600x1200)
				  51 - MT9T001 (2048*1536)
				  52 - MT9P001 (2592*1944)
				  64 - IBIS5-1300*/

// leave it here - may be used in user applications
#define SENSOR_MASK      0xfc
#define SENSOR_ZR32112   0x04
#define SENSOR_ZR32212   0x08
#define SENSOR_KAC1310   0x20
#define SENSOR_KAC5000   0x24
#define SENSOR_MI1300    0x30
#define SENSOR_MT9X001   0x30 // MT9M001 - 31, MT9D001 - 32, MT9T001 - 33, MT9P001 - 34
#define SENSOR_MT9Y001   0x34 // MT9P001 - 34
#define SENSOR_IBIS51300 0x40
#define SENSOR_KAI11000  0x80
#define SENSOR_NONE      0xfc

// sensor sizes:
//#define SENSORWIDTH_ZR32112  1288
//#define SENSORHEIGHT_ZR32112 1032
#define SENSORWIDTH_ZR32112  1280
#define SENSORHEIGHT_ZR32112 1024
//#define SENSORWIDTH_ZR32212  1288
#define SENSORWIDTH_ZR32212  1280
#define SENSORHEIGHT_ZR32212 968
#define SENSORWIDTH_KAC1310  1280
#define SENSORHEIGHT_KAC1310 1024
//#define SENSORWIDTH_KAC1310  1296
//#define SENSORHEIGHT_KAC1310 1046
#define SENSORWIDTH_MI1300  1280
#define SENSORHEIGHT_MI1300 1024

#define SENSORWIDTH_MT9M001  1280
#define SENSORHEIGHT_MT9M001 1024
#define SENSORWIDTH_MT9D001  1600
#define SENSORHEIGHT_MT9D001 1200
#define SENSORWIDTH_MT9T001  2048
#define SENSORHEIGHT_MT9T001 1536
#define SENSORWIDTH_MT9P001  2592
#define SENSORHEIGHT_MT9P001 1944

#define SENSORWIDTH_KAC5000  2592
#define SENSORHEIGHT_KAC5000 1944


#define SENSORWIDTH_IBIS51300  1280
#define SENSORHEIGHT_IBIS51300 1024

//! Parameters below are accessed through mmap, because of cache coherency problem it make sense to keep them compact (maybe group by 8 - cache line of 32 bytes)
#define P_SENSOR_RUN     4 // 0 - stop, 1 - single, 2 - run
#define SENSOR_RUN_STOP   0
#define SENSOR_RUN_SINGLE 1
#define SENSOR_RUN_CONT   2
#define P_COMPRESSOR_RUN 5 // 0 - stop, 1 - single, 2 - run
#define COMPRESSOR_RUN_STOP   0
#define COMPRESSOR_RUN_SINGLE 1
#define COMPRESSOR_RUN_CONT   2

#define P_BAYER          6 // filter number at (0,0) 0-R, 1-G(R), 2-G(B), 3 - B. Write enabled at first, move to WindowSize later
#define P_TRIGGERED	 7 // when trigger occured - 4 LSBs - pixel in DMA word, higher bits - number of DMA word OBSOLETE
#define P_PERIOD         8 // Frame period in pixel clocks (read only)
#define P_FP1000SLIM     9 // FPS limit, frames per 1000 sec
#define P_FPSFLAGS      10 // FPS limit mode - bit 0 - limit fps (not higher than), bit 1 - maintain fps (not lower than)

#define P_JPEG_WP       11 // Last reported JPEG write pointer in the circular buffer. ** OBSOLETE
//! In new code use G_CIRCBUFWP instead!
#define P_CLK_FPGA      12 // FPGA clock in MHz
#define P_CLK_SENSOR    13 // Sensor clock in MHz
#define P_FPGA_XTRA     14 // Extra cycles needed to compressor (probably constant...)
#define P_TRIG          15 /// External trigger mode
/// bit 0  - "old" external mode (0- internal, 1 - external )
/// bit 1 - enable(1) or disable(0) external trigger to stop clip
/// bit 2 - async (snapshot, ext trigger) mode, 0 - continuous NOTE: Only this bit is used now !
/// bit 3 - no overlap,  single frames: program - acquire/compress same frame
#define P_BGFRAME       16 // Background measurement mode - will use 16-bit mode and no FPN correction 

#define P_IMGSZMEM      17 // image size in video memory (calculated when channel 0 is programmed)


// image page numbers depend on image size/pixel depth, so changing any of them will invalidate all pages
#define P_PAGE_ACQ      18  // Number of image page buffer to acquire to (0.1?)
#define P_PAGE_READ     19  // Number of image page buffer to read from to (0.1?)

#define P_OVERLAP       20 // number of EXRA lines to be acquired - probably dead,

#define P_VIRT_KEEP     21 // 0 - recalculate P_VIRT_WIDTH, P_VIRT_HEIGHT when window is changed, 1 - keep those parameters
#define P_VIRT_WIDTH    22 // Virtual window width
#define P_VIRT_HEIGHT   23 // Virtual window height
#define P_WOI_LEFT      24 // WOI left corner (before applying decimation)
#define P_WOI_TOP       25 // WOI top corner
#define P_WOI_WIDTH     26 // WOI width
#define P_WOI_HEIGHT    27 // WOI height

#define P_FLIPH         28 // bit 0 horizontal flip
#define P_FLIPV         29 // bit 0 vertical flip

#define P_DCM_HOR       30 /* Horizontal decimation (1/2/4/8) */
#define P_DCM_VERT      31 /* Vertical   decimation (1/2/4/8) copied from horizontal for Zoran chips */
#define P_BIN_HOR       32 /* binning 1/2 - KAC1310 only - now for mt9t001 */
#define P_BIN_VERT      33 /* not used yet binning 1/2 - KAC1310 only  - now for mt9t001*/
#define P_FPGATEST      34 // FPGA test modes (now - just one)

#define P_FRAMESYNC_DLY 35 /* maybe - temporary - delay of frame sync (vacts) by number of scan lines - for photofinish mode*/

#define P_PF_HEIGHT     36 /*height of each strip in photofinish mode - normally 2 lines */
/*also now includes timestamping mode +0x10000 - for normal frames, 0x20000 - for photo-finish */

#define P_BITS          37 /* pixel depth - bits 10/8/4 */

#define P_SHIFTL        38 /* "digital gain" - shift left by 0/1/2 bits  (3 ->-1)*/
#define P_FPNS          39 // FPN correction mode (subtract) 0..3
// 0-none, 1 - fine(25%), 2 - 50%, 3 - coarse(100%)
#define P_FPNM          40 // FPN correction mode (multiply) 0..3
// 0-none, 1 - fine(+/-12.5%), 2 - medium (+/-25%), +3 - coarse(+/-50%)
#define P_TESTSENSOR    41 // sensor test mode(s) 0x10000 - enable, lower bits - test mode
#define P_VIRTTRIG      42 // Sum of pixels in a line greater than this value - trigger acquisition

#define P_PERIOD_MIN    43 // (readonly)  minimal frame period (in pixel clocks) limited by user or compressor
#define P_PERIOD_MAX    44 // (readonly) frame period (in pixel clocks) limited by user
#define P_SENSOR_PIXH   45 // (readonly) pixels to be read from the sensor, horizontal (incliding margins, excluding embedded timestamps)
#define P_SENSOR_PIXV   46 // (readonly) pixels to be read from the sensor, vertical (incliding margins)
#define P_FATZERO       47 // subtract while adding data from to consequitive frames (async trigger)

#define P_COMPMOD_TILSH 48
#define P_COMPMOD_DCSUB 49
#define P_COMPMOD_QTAB  50 // to be written not directly, but by  pgm_quality ? 

#define P_FP1000S       51 // Frames per 1000 sec (fps * 1000)
#define P_SENSOR_WIDTH  52
#define P_SENSOR_HEIGHT 53
#define P_COLOR_SATURATION_BLUE 54 // 100*realtive saturation blue - preserve?
#define P_COLOR_SATURATION_RED  55 // 100*realtive saturation red

/// Vignetting control, AX*X^2+BX*X+AY*Y^2+BY*Y+C
#define P_VIGNET_AX     56
#define P_VIGNET_AY     57
#define P_VIGNET_BX     58
#define P_VIGNET_BY     59
#define P_VIGNET_C      60 /// nominal 0x8000
#define P_VIGNET_SHL    61 /// shift left color_coeff*vign_correction. 0..7, default=1 (up to 4x color correction* vignetting correction)
#define P_SCALE_ZERO_IN  62 /// signed 16 bit - subtract from pixel 16-bit data before multiplication
#define P_SCALE_ZERO_OUT 63 /// signed 16 bit - add after correction
/// "digital gains" for color correction, 17-bit unsigned data (default 0x8000).
#define P_DGAINR        64
#define P_DGAING        65
#define P_DGAINGB       66
#define P_DGAINB        67

#define P_RSCALE_ALL    68 /// bits 0..29: Ratio of [P_GAINR]/[P_GAING] or one of special, bit 30 - recalculate(self cleaning), bit 31 - ignore
#define P_GSCALE_ALL    69
#define P_BSCALE_ALL    70
#define CSCALES_WIDTH     28
#define CSCALES_CTL_BIT   28
#define CSCALES_CTL_WIDTH  2
/// commands to be written to P_*SCALE_CTL
#define CSCALES_CTL_NORMAL  0 /// USE P_*SCALE as is
#define CSCALES_CTL_RECALC  1 /// Recalculate P_*SCALE from P_GAIN*, P_GAING, then use it (will change to CSCALES_CTL_NORMAL when applied)
#define CSCALES_CTL_FOLLOW  2 /// Don't apply P_*SCALE to P_GAIN*, but update it from the current P_*SCALE from P_GAIN*/P_GAING
#define CSCALES_CTL_DISABLE 3 /// Disable P_*SCALE - don't apply P_*SCALE to P_GAIN*, don't update P_*SCALE from P_GAIN*, P_GAING


#define P_ZBINROUND     71 // zero bin + ((rounding add) << 8) 8-bit JPEG quantizer zero bin size, fractional addition to absolute value before truncating
#define P_HISTRQ        72 // per-frame enabling of histogram calculation - bit 0 - Y (G), bit 2 - C (R,G2,B)
#define P_TILES         73 // Number of 16x16 (20x20) tiles in a compressed frame
#define P_SENSOR_PHASE  74 // packed, low 16 bit - signed fine phase, bits [18:17] - 90-degrees shift


#define P_AUTOEXP_ON    76 // unsigned long on;

/// relative histogram (autoexposure) window (changed from % to 1/0x10000)
#define P_HISTWND_RWIDTH  77 // unsigned long width (%)->relative (0x10000 - 1.0);
#define P_HISTWND_RHEIGHT 78 //unsigned long height (%);
#define P_HISTWND_RLEFT   79 // unsigned long left (%);
#define P_HISTWND_RTOP    80 // unsigned long top (%);

/// Are these used anywhere now? ...P_AUTOEXP_SKIP_T
#define P_AUTOEXP_EXP_MAX 81 //unsigned long exp_max;		/* 100 usec == 1 etc... */
#define P_AUTOEXP_OVEREXP_MAX 82 // unsigned long overexp_max;	/* percentages for overexposured pixels - 1% == 100, 5% == 500, 0.02% == 2 etc... */
#define P_AUTOEXP_S_PERCENT 83 // unsigned long s_percent;(controlling that % of pixels that should have value greater than S_INDEX - below)
#define P_AUTOEXP_S_INDEX 84 // unsigned long s_index; Specified number of pixels (S_PERCENT) should have value above S_INDEX
#define P_AUTOEXP_EXP   85 // unsigned long exp; Current exposure time
#define P_AUTOEXP_SKIP_PMIN 86 // unsigned long skip_pmin;	/* percent of delta for skip changes: 1% == 100 */ - no exposure corrections if the desired change is less than that
#define P_AUTOEXP_SKIP_PMAX 87 // unsigned long skip_pmax;	/* percent of changes for wait one frame before apply changes: 1% == 100 */ - do not apply chnanges if they are to big - wait for the next frame
#define P_AUTOEXP_SKIP_T 88 //	unsigned long skip_t;		/* time for skip changes: 100 usec == 1 */ Not quite sure what it is

///same as written to the FPGA for the histogram window
#define P_HISTWND_WIDTH  89 // autoexposure window width  (pixels)
#define P_HISTWND_HEIGHT 90 // autoexposure window height (pixels)
#define P_HISTWND_TOP    91 // autoexposure window top    (pixels)
#define P_HISTWND_LEFT   92 // autoexposure window left   (pixels)

#define P_FOCUS_SHOW     93 // show focus information instead of/combined with the image:
// 0 - regular image, 1 - block focus instead of Y DC (AC=0), 2 - image Y DC combined all frame, 3 combined in WOI
#define P_FOCUS_SHOW1    94 // Additional parameter that modifies visualization mode. Currently just a single bit (how much to add)

#define P_FOCUS_LEFT     96 // focus WOI left margin, inclusive (3 LSB will be zeroed as it should be multiple of 8x8 block width) 
#define P_FOCUS_WIDTH    97 // focus WOI width (3 LSB will be zeroed as it should be multiple of 8x8 block width) 
#define P_FOCUS_TOP      98 // focus WOI top margin, inclusive (3 LSB will be zeroed as it should be multiple of 8x8 block height) 
#define P_FOCUS_HEIGHT   99 // focus WOI height (3 LSB will be zeroed as it should be multiple of 8x8 block height) 
#define P_FOCUS_TOTWIDTH 100 // (readonly) - total width of the image frame in pixels
#define P_FOCUS_FILTER   101 // select 8x8 filter used for the focus calculation (same order as quantization coefficients), 0..14

//!timing generator/trigger delay/external trigger control

#define P_TRIG_CONDITION 102 // trigger condition, 0 - internal, else dibits ((use<<1) | level) for each GPIO[11:0] pin
#define P_TRIG_DELAY     103 // trigger delay, 32 bits in pixel clocks
#define P_TRIG_OUT       104 // trigger output to GPIO, dibits ((use << 1) | level_when_active). Bit 24 - test mode, when GPIO[11:10] are controlled by other internal signals
#define P_TRIG_PERIOD    105 // output sync period (32 bits, in pixel clocks). 0- stop. 1..256 - single, >=256 repetitive with specified period.


#define P_SKIP_FRAMES    107 // number of frames to skip after restarting sensor+compressor - now zero/nonzero?
#define P_I2C_QPERIOD    108 // number of system clock periods in 1/4 of i2c SCL period to the sensor/sensor board
#define P_I2C_BYTES      109 // number of bytes in hardware i2c write (after slave addr) -0/1/2
#define P_IRQ_SMART      110 // "smart" IRQ modes: +1 - wait for VACT in early compressor_done, +2 - wait for dma fifo ready
/// Currently bit 0 will be always 1 (needs fix in FPGA)
#define P_EARLY_TIMESTAMP 111 // "1" - use start of TRIG pulse as a timetamp moment (0 - use start of first visible line readout) - prevent jitter in async mode
#define P_OVERSIZE       112 // ignore sensor dimensions, use absolute WOI_LEFT, WOI_TOP
//#define P_VALID          113 // frame parameters valid (all needed parameters written in time, smth. else)
//#define P_QTABLE         114 // number of quantization table used (0..7)

#define P_RFOCUS_LEFT    115 // relative (0x10000 - 1.0) focus WOI left margin, inclusive (3 LSB will be zeroed as it should be multiple of 8x8 block width) 
#define P_RFOCUS_WIDTH   116 // relative (0x10000 - 1.0)focus WOI width (3 LSB will be zeroed as it should be multiple of 8x8 block width) 
#define P_RFOCUS_TOP     117 // relative (0x10000 - 1.0)focus WOI top margin, inclusive (3 LSB will be zeroed as it should be multiple of 8x8 block height) 
#define P_RFOCUS_HEIGHT  118 // relative (0x10000 - 1.0)focus WOI height (3 LSB will be zeroed as it should be multiple of 8x8 block height) 

#define P_SDRAM_CHN20    125 // data to be written to the SDRAM CH2 REG 0  (last moment)
#define P_SDRAM_CHN21    126 // data to be written to the SDRAM CH2 REG 1 
#define P_SDRAM_CHN22    127 // data to be written to the SDRAM CH2 REG 2 


/// The following 4 parameters should have consecutive indexes
/// see  FRAMEPAIR_MASK_BYTES  to modify just part of the word (i.e. scale, not hash16
#define P_GTAB_R         128 // combines (P_PIXEL_LOW<<24) | (P_GAMMA <<16) and 16-bit (6.10) scale for gamma tables, individually for each color.
//  16Msbs are also "hash16" and do not need to be black level/gamma, just uniquely identify the table for applications
#define P_GTAB_G         129 // same for the first green (red line)
#define P_GTAB_GB        130 // same for the second green (blue line)
#define P_GTAB_B         131 // same for the blue
#define P_QUALITY        132 //JPEG IMAGE QUALITY (now uses 2 bytes)
#define P_ACTUAL_WIDTH   133 // RD P_RO_WIDTH  1  pixels/row
#define P_ACTUAL_HEIGHT  134 // RD P_RO_HEIGHT 2  pixels/column
#define P_COLOR          135 /// mono - 0, color mode - 1, +0 - normal, 256 - sensor test, 512 - FPGA test
#define COLORMODE_MONO6     0 // monochrome, (4:2:0),
#define COLORMODE_COLOR     1 // color, 4:2:0, 18x18(old)
#define COLORMODE_JP46      2 // jp4, original (4:2:0)
#define COLORMODE_JP46DC    3 // jp4, dc -improved (4:2:0)
#define COLORMODE_COLOR20   4 //  color, 4:2:0, 20x20, middle of the tile (not yet implemented)
#define COLORMODE_JP4       5 // jp4, 4 blocks, (legacy)
#define COLORMODE_JP4DC     6 // jp4, 4 blocks, dc -improved
#define COLORMODE_JP4DIFF   7 // jp4, 4 blocks, differential red := (R-G1), blue:=(B-G1), green=G1, green2 (G2-G1). G1 is defined by Bayer shift, any pixel can be used
#define COLORMODE_JP4HDR    8 // jp4, 4 blocks, differential HDR: red := (R-G1), blue:=(B-G1), green=G1, green2 (high gain)=G2) (G1 and G2 - diagonally opposite)
#define COLORMODE_JP4DIFF2  9 // jp4, 4 blocks, differential, divide differences by 2: red := (R-G1)/2, blue:=(B-G1)/2, green=G1, green2 (G2-G1)/2
#define COLORMODE_JP4HDR2  10 // jp4, 4 blocks, differential HDR: red := (R-G1)/2, blue:=(B-G1)/2, green=G1, green2 (high gain)=G2), 
#define COLORMODE_MONO4    14 // monochrome, 4 blocks (but still with 2x2 macroblocks)
/// the following 8 values should go in the same sequence as fields in the histogram page
#define P_FRAME          136 // Frame number (reset with JPEG pointers) -(read only)
#define P_GAINR          137 // R channel gain  8.16 (0x10000 - 1.0). Combines both analog gain and digital scaling
#define P_GAING          138 // G channel gain ("red line")
#define P_GAINGB         139 // G channel gain ("blue line")
#define P_GAINB          140 // B channel gain
#define P_EXPOS          141 //P_RW_EXPOS  1   exposure time      - now in microseconds?
#define P_VEXPOS         142 // video exposure (if 0 - use P_RW_EXPOS in ms)
#define P_FOCUS_VALUE    143 // (readonly) - sum of all blocks focus values inside focus WOI

/// 143 - last to copy

#define P_COMPMOD_BYRSH  160 // Bayer shift in compressor



///TODO: rearrange, combine with other AUTOEXP
/// if  [G_HIST_DIM_01] is set to 0xffffffff that will force re-calibration (1 dark frame)
/// The following is a daemons control so the sleeping daemons can be awaken by the drivers when the corresponding bit is set and
/// one of the following events happen (depending on driver and lseek (SEEK_END) offset:
/// frame interrupt (any - compressed or not) - through "/dev/frameparsall"
/// frame compressed interrupt - through "/dev/circbuf"
/// histogram Y (G1) is ready - through "/dev/histogram_cache"
/// histogram C (R,G1,G2,B) are ready - through "/dev/histogram_cache"

#define P_DAEMON_EN      165 /// disable all autoexp features AEXP, WB, HDR- make extra sleep for AUTOEXP_EN to become non-zero (normal frame rules)
#define P_AEXP_FRACPIX   166 /// Fraction of all pixels that should be below P_AEXP_LEVEL (16.16 - 0x10000 - all pixels)
#define P_AEXP_LEVEL     167 /// Target output level:  [P_AEXP_FRACPIX]/0x10000 of all pixels should have value below it (also 16.16 - 0x10000 - full output scale)

#define P_HDR_DUR        168 /// 0 - HDR 0ff, >1 - duration of same exposure (currently 1 or 2 - for free running)
#define P_HDR_VEXPOS     169 /// if less than 0x10000 - number of lines of exposure, >=10000 - relative to "normal" exposure

#define P_AE_PERIOD      170 /// Autoexposure period (will be increased if below the latency)
#define P_WB_PERIOD      171 /// White balance period (will be increased if below the latency)
#define P_WB_CTRL        172 /// bitmask - which colors to correct (1 - correct, 0 - ignore)
#define P_WB_WHITELEV    173 /// White balance level of white (16.16 - 0x10000 is full scale, 0xfae1 - 98%, default)
#define P_WB_WHITEFRAC   174 /// White balance fraction (16.16) of all pixels that have level above [P_WB_WHITELEV] for the brightest color
/// locally [P_WB_WHITELEV] will be decreased if needed to satisfy [P_WB_WHITELEV]. default is 1% (0x028f)
#define P_WB_MAXWHITE    175 /// Maximal allowed "white" pixels fraction (16.16) to have level above [P_WB_WHITELEV] for the darkest color
/// if this limit is exceeded there will be no correction (waiting for autoexposure to decrease overall brightness)

#define P_WB_SCALE_R     176 /// additional correction for R from calulated by white balance (16.16)
#define P_WB_SCALE_GB    177 /// additional correction for G2(GB) from calulated by white balance (16.16)
#define P_WB_SCALE_B     178 /// additional correction for B from calulated by white balance (16.16)

#define P_EXP_AHEAD      179 /// How many frames ahead of the current frame write exposure to the sensor
#define P_AE_THRESH      180 /// AE error (logariphmic exposures) is integrated between frame and corrections are scaled when error is below thershold (500)
#define P_WB_THRESH      181 /// same for WB

/// Used by white balancing to control analog gains in addition to gamma tables. Can be limited to narrower range than
#define P_GAIN_MIN       182 /// minimal sensor analog gain  0x10000 ~1.0
#define P_GAIN_MAX       183 /// maximal sensor analog gain  0x10000 ~1.0
#define P_GAIN_CTRL      184 /// minimal correction to be applied to the analog gain (should be set larger that sensor actual gain step to prevent oscillations (0x100 - 1.0, 0x20 - 1/8)
#define GAIN_BIT_STEP      0 /// start bit of gain step control in P_GAIN_CTRL
#define GAIN_BIT_ENABLE   16 /// start bit of enabling analog gain controls in white balancing

/// Requests for autocampars daemon
#define P_AUTOCAMPARS_CTRL 185 /// bits 0..24 - groups to restore, bits 24..27 - page number to save bits 28..30: 1 - restore, 2 - save, 3 - set default 4 save as default 5 - init

/// Parameters for ccamftp.php daemon
/// (server, account, password, directories,script names are sepaarte)
#define P_FTP_PERIOD     190 /// FTP image upload period
#define P_FTP_TIMEOUT    191 /// Maximal time allowed for image uploading
#define P_FTP_UPDATE     192 /// Maximal time between updates (camera wil re-read remote configuration file)

// streamer parameters
#define _P_STROP_OFFSET      193
// multicast/unicast transport
#define P_STROP_MCAST_EN        (_P_STROP_OFFSET + 0)	// != 0 for multicast, 0 for unicast
#define P_STROP_MCAST_IP        (_P_STROP_OFFSET + 1)	// 0 for camera IP based multicast, other value - for custom IP
#define P_STROP_MCAST_PORT      (_P_STROP_OFFSET + 2)	// >= 1024 && <= 65532
#define P_STROP_MCAST_TTL       (_P_STROP_OFFSET + 3)	// >= 1 && <= 15
// audio - support only one ("default") soundcard, if present
#define P_STROP_AUDIO_EN        (_P_STROP_OFFSET + 4)	// 0 - disable audio, else - try if soundcard is present
#define P_STROP_AUDIO_RATE      (_P_STROP_OFFSET + 5)	// >= 11250 && <= 48000
#define P_STROP_AUDIO_CHANNEL   (_P_STROP_OFFSET + 6)	// 1 - mono, 2 - stereo
#define P_STROP_FRAMES_SKIP     (_P_STROP_OFFSET + 7)	// 0 - output each frame, 1 - output/skip == 1/1 fomr 2 frames, 2 - output/skip == 1/2 from 3 frames etc
#define P_AUDIO_CAPTURE_VOLUME  (_P_STROP_OFFSET + 8)	// for streamer and camogm2: 0 == 0%; 65535 == 100% capture volume, by default 90% == 58981

#define P_SENSOR_REGS    256 /// shadows of the sensor registers (should be multiple of 32)
#define P_SENSOR_NUMREGS 256 /// number of the sensor registers (should be multiple of 32)

#define P_MAX_PAR        511 /// maximal # of used parameter
//#define P_MAX_GPAR      1023 // maximal # of global parameter
#define P_MAX_GPAR      2047 /// maximal # of global parameter


#define PARS_SAVE_FROM   128 /// PARS_SAVE_NUM parameters starting from PARS_SAVE_FROM from "this" frame will be saved in circular buffer, PASTPARS_SAVE_ENTRIES entries
#define PARS_SAVE_COPY    16 /// number of parameters copied from future (framepars) to the past (pastpars)
#define PARS_SAVE_NUM     32 /// total size of previous parameter save page
#define PP_PROFILE_START  16 /// index of the first profile timestamp in pastpars
#define P_PROFILE        (PARS_SAVE_FROM + PP_PROFILE_START) //index to access profiles as pastpars (i.e. from PHP ELPHEL_PROFILE1,PHP ELPHEL_PROFILE2)

/// TODO: Cahange global names P_* to G_* ?
#define FRAMEPAR_GLOBALS       0x01000  /// start of global (not frame-related) parameters


#define GLOBALPARS(x) globalPars[(x)-FRAMEPAR_GLOBALS] // should work in drivers and applications

#define G_DEBUG         (FRAMEPAR_GLOBALS + 2) /// Each bit turns on/off some debug outputs
#define G_MAXAHEAD      (FRAMEPAR_GLOBALS + 3) /// Maximal number of frames ahead of current to be programmed to hardware
#define G_THIS_FRAME    (FRAMEPAR_GLOBALS + 4) /// Current frame number (may lag from the hardwaere)
#define G_CIRCBUFSIZE   (FRAMEPAR_GLOBALS + 5) /// Size of the circular buffer (in bytes)
//!the following 3 locations should be in the same 32-byte (8 long) cache line
#define G_FREECIRCBUF   (FRAMEPAR_GLOBALS + 6) /// Free space in circbuf (uses global read pointer, in bytes)
#define G_CIRCBUFWP     (FRAMEPAR_GLOBALS + 7) /// circbuf write pointer (in bytes - similar P_JPEG_WP is in long words)
#define G_CIRCBUFRP     (FRAMEPAR_GLOBALS + 8) /// circbuf global read pointer (in bytes )

#define G_SECONDS       (FRAMEPAR_GLOBALS + 9)  /// seconds (R/W to FPGA timer)
#define G_MICROSECONDS  (FRAMEPAR_GLOBALS + 10) /// microseconds (R/W to FPGA timer)

/// Next 5 should go in that sequence
#define G_CALLNASAP     (FRAMEPAR_GLOBALS + 11) /// bitmask - what functions can be used not only in the current frame (ASAP) mode
#define G_CALLNEXT      (FRAMEPAR_GLOBALS + 11) /// (same as G_CALLNASAP) bitmask of actions to be one   or more frames ahead of the programmed one (OR-ed with G_CALLNEXT2..G_CALLNEXT4)
///Leave 4 locations after for (G_CALLNEXT+1)...(G_CALLNEXT+4)
//#define G_CALLNEXT1     (FRAMEPAR_GLOBALS + 12) /// bitmask of actions to be one   or more frames ahead of the programmed one (OR-ed with G_CALLNEXT2..G_CALLNEXT4)
//#define G_CALLNEXT2     (FRAMEPAR_GLOBALS + 13) /// bitmask of actions to be two   or more frames ahead of the programmed one (OR-ed with G_CALLNEXT3..G_CALLNEXT4)
//#define G_CALLNEXT3     (FRAMEPAR_GLOBALS + 14) // bitmask of actions to be three or more frames ahead of the programmed one (OR-ed with G_CALLNEXT4)
//#define G_CALLNEXT4     (FRAMEPAR_GLOBALS + 15) // bitmask of actions to be four  or more frames ahead of the programmed one

#define G_NEXT_AE_FRAME  (FRAMEPAR_GLOBALS + 16) // Next frame to be processed by autoexposure - written directly from daemon through mmap
#define G_NEXT_WB_FRAME  (FRAMEPAR_GLOBALS + 17) // Next frame to be processed by white balance - written directly from daemon through mmap
#define G_HIST_DIM_01    (FRAMEPAR_GLOBALS + 18) // Percentile measured for colors 0 (lower 16 bits) and 1 (high 16 bits) for  VEXPOS=1
#define G_HIST_DIM_23    (FRAMEPAR_GLOBALS + 19) // Percentile measured for colors 2 (lower 16 bits) and 3 (high 16 bits) for  VEXPOS=1
/// if  [G_HIST_DIM_01] is set to 0xffffffff that will force re-calibration (1 dark frame)
//#define G_EW_HYSTCNTR    (FRAMEPAR_GLOBALS + 20) // autoexposure/white balance hysteresis counters , 1 byte each, (sign and count, Y,R,G2,B)
#define G_AE_INTEGERR    (FRAMEPAR_GLOBALS + 20) // current integrated error in the AE loop
#define G_WB_INTEGERR    (FRAMEPAR_GLOBALS + 21) // current integrated error in WB loop

#define G_TASKLET_CTL    (FRAMEPAR_GLOBALS + 22) /// disable individual tasklets  (TODO:rename to DEBUG_CTL?)
#define G_GFOCUS_VALUE   (FRAMEPAR_GLOBALS + 23) // (readonly) - sum of all blocks focus values inside focus WOI (global)

#define TASKLET_CTL_PGM      0 /// disable programming parameters (should not be)
#define TASKLET_CTL_IGNPAST  1 /// "ignore overdue" control bit
#define TASKLET_CTL_NOSAME   2 /// don't try to process parameters immediately after written. If 0, only non-ASAP will be processed to prevent
#define TASKLET_CTL_ENPROF   3 /// enable profiling (saving timing of the interrupts/tasklets in pastpars)
/// effects of uncertainty of when was it called relative to frame sync
#define TASKLET_HIST_ALL     0   /// calculate each frame
#define TASKLET_HIST_HALF    1   /// calculate each even (0,2,4,6 frme of 8)
#define TASKLET_HIST_QUATER  2   /// calculate twice per 8 (0, 4)
/// NOTE: It is safer to allow all histograms at least once in 8 frames so applications will not be locked up waiting for the missed histogram
/// TODO: detect missing histograms and wakeup queue
#define TASKLET_HIST_ONCE    3   /// calculate once  per 8 (0) 
#define TASKLET_HIST_RQONLY  4   /// calculate only when specifically requested
#define TASKLET_HIST_NEVER   7   /// never calculate

#define TASKLET_CTL_HISTY_BIT  4 /// shift of histogram calculation for Y in G_TASKLET_CTL (bits 4,5,6)
#define TASKLET_CTL_HISTC_BIT  8 /// shift of histogram calculation for C in G_TASKLET_CTL (bits 8,9,10)

#define G_HIST_LAST_INDEX (FRAMEPAR_GLOBALS + 24) // last used index in histogram cache
#define G_HIST_Y_FRAME    (FRAMEPAR_GLOBALS + 25) // last frame for which Y histogram was calualted
#define G_HIST_C_FRAME    (FRAMEPAR_GLOBALS + 26) // last frame for which C histograms were calualted
#define G_SKIP_DIFF_FRAME (FRAMEPAR_GLOBALS + 27) // number of frames with different size to tolerate before producing POLLHUP in poll(circbuf)
#define G_FTP_NEXT_TIME   (FRAMEPAR_GLOBALS + 28) // time of the next FTP upload (seconds from epoch)

#define G_DAEMON_ERR      (FRAMEPAR_GLOBALS + 31) // 1 bit per daemon error that needs attention (daemon would put itself to sleep through P_DAEMON_EN)
#define G_DAEMON_RETCODE  (FRAMEPAR_GLOBALS + 32) // return codes (32 32-bit words) for daemons, provided with a corresponding bit in G_DAEMON_ERR set
///next will be (FRAMEPAR_GLOBALS + 64) 

#define G_SENSOR_CALIB   (FRAMEPAR_GLOBALS + 1024) /// 1024 Array of sensor calibration data, sensor dependent.For Micron it is 256*4 actual gains in 8.16 format 
/// Only first 96 for each color are used



///Modifies to the parameter numbers/addresses
#define FRAMEPAIR_FORCE_NEW     0x040000000 // will mark parameter as "modified" even the new==old
#define FRAMEPAIR_FORCE_PROC    0x080000000 // will mark schedule functions for that parameter even if called from setFramePars/setFramePar (normally it is not)
#define FRAMEPAIR_FORCE_NEWPROC 0x0c0000000 // combines both
#define FRAMEPAIR_JUST_THIS     0x10000000 // write only to this frame, don't propagate
// (like "single frame" - compressor, sensor) first write "stop", then - "single" with FRAMEPAIR_JUST_THIS
#define FRAMEPAIR_FRAME_FUNC    0x20000000 // write to func2call instead of the frame parameters
/// compose bit fields to be OR-ed to the parameter number bit 16..25: b - start bit (0..31), w - width 1..32
#define FRAMEPAIR_FRAME_BITS(w,b) ((((w) & 0x1f)<<21) | (((b) & 0x1f)<<16))
/// Shift new data (nd), apply mask and combine with old data (od), taking shift/width information from bits 16..25 of (a)
#define FRAMEPAIR_FRAME_MASK_NEW(a,od,nd) ((((od) ^ ((nd) << (((a)>>16) & 0x1f))) & (((1 << (((a)>>21) & 0x1f))-1) << (((a)>>16) & 0x1f))) ^ (od))

/// read bit field from the data (d), use bit information encoded in bits 16..25 of the parameter address (a)
#define FRAMEPAIR_FRAME_FIELD(a,d) (((d) >> (((a)>>16) & 0x1f)) &  ((1 << (((a) >> 21) & 0x1f))-1))

#define FRAMEPAIR_MASK_BYTES   (FRAMEPAIR_FRAME_BITS(31,31)) /// 0x03ff0000 - if parameter address & FRAMEPAIR_FRAME_MASK is nonzero, chnage only some bits

///NOTE: byte/word masks not to be OR-ed!
#define FRAMEPAIR_BYTE0        (FRAMEPAIR_FRAME_BITS( 8,  0)) // overwrite only byte0 (LSB) in the paremater
#define FRAMEPAIR_BYTE1        (FRAMEPAIR_FRAME_BITS( 8,  8)) // overwrite only byte1 in the paremater
#define FRAMEPAIR_BYTE2        (FRAMEPAIR_FRAME_BITS( 8, 16)) // overwrite only byte2 in the paremater
#define FRAMEPAIR_BYTE3        (FRAMEPAIR_FRAME_BITS( 8, 24)) // overwrite only byte3 (MSB) in the paremater
#define FRAMEPAIR_WORD0        (FRAMEPAIR_FRAME_BITS(16,  0)) // overwrite only word0 (LSW) in the paremater (i.e. gamma scale)
#define FRAMEPAIR_WORD1        (FRAMEPAIR_FRAME_BITS(16, 16)) // overwrite only word1 (MSW) in the paremater (i.e. gamma hash16)

//#define P_DAEMON_EN      165 // disable all autoexp features AEXP, WB, HDR- make extra sleep for AUTOEXP_EN to become non-zero (normal frame rules)
#define DAEMON_BIT_AUTOEXPOSURE 0
#define DAEMON_BIT_STREAMER     1
#define DAEMON_BIT_CCAMFTP      2
#define DAEMON_BIT_CAMOGM       3
#define DAEMON_BIT_AUTOCAMPARS  4
// add up to 31

#define P_DAEMON_EN_AUTOEXPOSURE (P_DAEMON_EN | FRAMEPAIR_FRAME_BITS(1, DAEMON_BIT_AUTOEXPOSURE))
#define P_DAEMON_EN_STREAMER     (P_DAEMON_EN | FRAMEPAIR_FRAME_BITS(1, DAEMON_BIT_STREAMER))
#define P_DAEMON_EN_CCAMFTP      (P_DAEMON_EN | FRAMEPAIR_FRAME_BITS(1, DAEMON_BIT_CCAMFTP))
#define P_DAEMON_EN_CAMOGM       (P_DAEMON_EN | FRAMEPAIR_FRAME_BITS(1, DAEMON_BIT_CAMOGM))
#define P_DAEMON_EN_AUTOCAMPARS  (P_DAEMON_EN | FRAMEPAIR_FRAME_BITS(1, DAEMON_BIT_AUTOCAMPARS))

//#define P_GAIN_CTRL       184 // combines GAIN_STEP and ANA_GAIN_ENABLE
#define P_GAIN_STEP      (P_GAIN_CTRL |  FRAMEPAIR_FRAME_BITS(16, GAIN_BIT_STEP))   // minimal correction to be applied to the analog gain
// (should be set larger that sensor actual gain step to prevent oscillations (0x100 - 1.0, 0x20 - 1/8)
#define P_ANA_GAIN_ENABLE    (P_GAIN_CTRL |  FRAMEPAIR_FRAME_BITS(1,  GAIN_BIT_ENABLE)) // enable analog gain adjustment in white balance procedure

#define WB_CTRL_BIT_EN   4
#define P_WB_MASK        (P_WB_CTRL |  FRAMEPAIR_FRAME_BITS(4,               0)) // Colors adjusted in automatic white balance
#define P_WB_EN          (P_WB_CTRL |  FRAMEPAIR_FRAME_BITS(1,  WB_CTRL_BIT_EN)) // Enabling/disabling automatic white balance adjustment

#define P_RSCALE         (P_RSCALE_ALL |  FRAMEPAIR_FRAME_BITS(CSCALES_WIDTH, 0)) // Red-to-Green ratio, 0x10000 ~ 1.0
#define P_GSCALE         (P_GSCALE_ALL |  FRAMEPAIR_FRAME_BITS(CSCALES_WIDTH, 0)) // Green2-to-Green ratio, 0x10000 ~ 1.0
#define P_BSCALE         (P_BSCALE_ALL |  FRAMEPAIR_FRAME_BITS(CSCALES_WIDTH, 0)) // Blue-to-Green ratio, 0x10000 ~ 1.0

#define P_RSCALE_CTL     (P_RSCALE_ALL |  FRAMEPAIR_FRAME_BITS(CSCALES_CTL_WIDTH, CSCALES_CTL_BIT)) // Red-to-Green ratio control
#define P_GSCALE_CTL     (P_GSCALE_ALL |  FRAMEPAIR_FRAME_BITS(CSCALES_CTL_WIDTH, CSCALES_CTL_BIT)) // Green2-to-Green ratio control
#define P_BSCALE_CTL     (P_BSCALE_ALL |  FRAMEPAIR_FRAME_BITS(CSCALES_CTL_WIDTH, CSCALES_CTL_BIT)) // Blue-to-Green ratio control

#define P_SENSOR_SINGLE      (P_SENSOR_RUN | FRAMEPAIR_JUST_THIS)       // is only good to write SENSOR_RUN_SINGLE there!
#define P_COMPRESSOR_SINGLE  (P_COMPRESSOR_RUN | FRAMEPAIR_JUST_THIS)   // is only good to write COMPRESSOR_RUN_SINGLE there!


//#define P_HISTRQ        67 // per-frame enabling of histogram calculation - bit 0 - Y (G), bit 2 - C (R,G2,B)
//#define   HISTRQ_BITY    0
//#define   HISTRQ_BITC    1 
#define   HISTRQ_BIT_Y    0
#define   HISTRQ_BIT_C    1 

#define P_HISTRQ_Y  (P_HISTRQ | FRAMEPAIR_FRAME_BITS(1, HISTRQ_BIT_Y) | FRAMEPAIR_JUST_THIS) /// request calculation of the Y-histogram for just this frame
#define P_HISTRQ_C  (P_HISTRQ | FRAMEPAIR_FRAME_BITS(1, HISTRQ_BIT_C) | FRAMEPAIR_JUST_THIS) /// request calculation of the C-histogram for just this frame
#define P_HISTRQ_YC (P_HISTRQ | FRAMEPAIR_FRAME_BITS(2, HISTRQ_BIT_Y) | FRAMEPAIR_JUST_THIS) /// request calculation of both the Y-histogram and C-histogrames for just this frame

#define G_HISTMODE_Y   (G_TASKLET_CTL | FRAMEPAIR_FRAME_BITS(3, TASKLET_CTL_HISTY_BIT)) /// control for histogram calculation Y (see TASKLET_HIST_*)
#define G_HISTMODE_C   (G_TASKLET_CTL | FRAMEPAIR_FRAME_BITS(3, TASKLET_CTL_HISTC_BIT)) /// control for histogram calculation Y (see TASKLET_HIST_*)

#define G_PROFILING_EN (G_TASKLET_CTL | FRAMEPAIR_FRAME_BITS(1, TASKLET_CTL_ENPROF)) /// enable profiling (saving timing of the interrupts/tasklets in pastpars)


//#define P_AUTOCAMPARS_CTRL 184 // bits 0..24 - groups to restore, bits 24..27 - page number to save bits 28..30: 1 - restore, 2 - save, 3 - set default 4 save as default 5 - init
#define P_AUTOCAMPARS_GROUPS (P_AUTOCAMPARS_CTRL | FRAMEPAIR_FRAME_BITS(24, 0)) 
#define P_AUTOCAMPARS_PAGE   (P_AUTOCAMPARS_CTRL | FRAMEPAIR_FRAME_BITS(4, 24))
#define P_AUTOCAMPARS_CMD    (P_AUTOCAMPARS_CTRL | FRAMEPAIR_FRAME_BITS(3, 28))

///NOTE page 0 is write protected, page 15 (0x0f) is "default" page
#define AUTOCAMPARS_CMD_RESTORE  1  /// restore specified groups of parameters from the specified page
#define AUTOCAMPARS_CMD_SAVE     2  /// save all current parameters to the specified group (page 0 is write-protected)
#define AUTOCAMPARS_CMD_DFLT     3  /// make selected page the default one (used at startup), page 0 OK 
#define AUTOCAMPARS_CMD_SAVEDFLT 4  /// save all current parameters to the specified group (page 0 is write-protected) and make it default (used at startup)
#define AUTOCAMPARS_CMD_INIT     5  /// reset sensor/sequencers, restore all parameters from the specified page



/// if defined 1 - will wakeup each frame, regardless of the availability of the histograms
#define HISTOGRAMS_WAKEUP_ALWAYS 0


/// Making use of FPGA queues of i2c and sequencer commands (up to 6 frames ahead)
/// The P_* parameters will now be stored in 8 pages (previous frame, this frame (+0), next(+1),...(+6)
/// Top index (0..7) corresponds to hardware frame counter, parameters are copied after the frame sync/compressor done interrupts.
/// when the 3-bit counter is combined with the software variable to get the full 32-bit frame number
/// Each parameter page includes 927 parameter registers, as well as 97 bitmasks to speed up updates between frames
/// So if no parameters are changed - nothing to be copied from page to page
#define PARS_FRAMES                                  8      // number of frames handled in buffer
#define PARS_FRAMES_MASK     (PARS_FRAMES-1)               // currently 7
#define PASTPARS_SAVE_ENTRIES       (PARS_FRAMES << 8)     // 2048
#define PASTPARS_SAVE_ENTRIES_MASK ((PARS_FRAMES << 8)-1)  // 0x7ff
struct framepars_t {
	unsigned long pars[927];      // parameter values (indexed by P_* constants)
	unsigned long functions;      // each bit specifies function to be executed (triggered by some parameters change)
	unsigned long modsince[31];   // parameters modified after this frame - each bit corresponds to one element in in par[960] (bit 31 is not used) 
	unsigned long modsince32;     // parameters modified after this frame super index - non-zero elements in in mod[31]  (bit 31 is not used) 
	unsigned long mod[31];        // modified parameters - each bit corresponds to one element in in par[960] (bit 31 is not used) 
	unsigned long mod32;          // super index - non-zero elements in in mod[31]  (bit 31 is not used) 
	unsigned long needproc[31];   /// FIXME: REMOVE parameters "modified and not yet processed" (some do not need any processing)
	unsigned long needproc32;     /// FIXME: REMOVE parameters "modified and not yet processed" frame super index - non-zero elements in in mod[31]  (bit 31 is not used) 
};
///TODO: rearrange onchage_* - functions will be executed in this sequence (from 0 to 31)

/// pgm_memcompressor             uses pgm_memsensor
/// pgm_compctl,pgm_comprestart   use pgm_memcompressor
/// pgm_limitfps                  uses pgm_memcompressor

/// pgm_memcompressor             uses pgm_memsensor
/// pgm_compctl,pgm_comprestart   use  pgm_memcompressor
/// pgm_limitfps                  uses pgm_memcompressor
/// pgm_limitfps                  uses pgm_compmode
/// pgm_trigseq                   uses pgm_limitfps
/// pgm_sensorin (bayer)          uses pgm_window (flip)
///                               onchange_i2c should be the first after init sensor (even before onchange_sensorphase)


/// phase (common part conditionally triggers init) -> init -> i2c -> sensorregs -> afterinit
/// reset i2c - only once, when the sensor is reset, it is stopped, by frame numbers go on (and parameters are not erased)

///TODO: onchange_exposure should be after onchange_limitfps
enum onchange_functions_t {
	onchange_recalcseq=0,    /// recalculate sequences/latencies, according to P_SKIP, P_TRIG
	onchange_detectsensor,   /// detect sensor type, sets sensor structure (capabilities), function pointers
	onchange_sensorphase,    /// program sensor clock/phase (needs to know maximal clock frequency)
	onchange_i2c,            /// program i2c
	onchange_sensorregs,      /// write sensor registers (only changed from outside the driver as they may have different latencies)?
	onchange_initsensor,     /// resets sensor, reads sensor registers, schedules "secret" manufacturer's corrections to the registers (stops/re-enables hardware i2c)
	onchange_afterinit,       /// restore image size, decimation,... after sensor reset or set them according to sensor capabilities if none were specified
	onchange_window,         /// program sensor WOI and mirroring (flipping)
	onchange_window_safe,    /// program sensor WOI and mirroring (flipping) - lower latency, no bad frames
	//  onchange_exposure,       /// program exposure
	onchange_gains,          /// program analog gains
	onchange_triggermode,    /// program sensor trigger mode
	onchange_sensorin,       /// program sensor input in FPGA (Bayer, 8/16 bits, ??)
	onchange_sensorstop,     /// Stop acquisition from the sensor to the FPGA (start has latency of 2)
	onchange_sensorrun,      /// Start/single acquisition from the sensor to the FPGA (stop has latency of 1)
	onchange_gamma,          /// program gamma table
	onchange_hist,           /// program histogram window
	onchange_aexp,           /// program autoexposure mode
	onchange_quality,        /// program quantization table(s)
	onchange_memsensor,      /// program memory channels 0 (sensor->memory) and 1 (memory->FPN)
	onchange_memcompressor,  /// program memory channel 2 (memory->compressor)
	onchange_limitfps,       /// check compressor will keep up, limit sensor FPS if needed
	onchange_exposure,       /// program exposure - NOTE: was just after onchange_window

	onchange_compmode,       /// program compressor modes (excluding start/stop/single)
	onchange_focusmode,      /// program focus modes
	onchange_trigseq,        /// program sequencer (int/ext)
	onchange_irq,            /// program smart IRQ mode (needs to be on)
	onchange_comprestart,    /// restart after changing geometry  (recognizes ASAP and programs memory channel 2 then)
	onchange_compstop,       /// stop compressor when changing geometry
	onchange_compctl,        /// only start/stop/single (after explicitly changed, not when geometry was changed)
	onchange_gammaload,      /// write gamma tables (should be prepared). Maybe - just last byte, to activate?
	onchange_prescal         /// change scales for per-color digital gains, apply vignetting correction
		//  onchange_sensorregs      /// write sensor registers (only changed from outside the driver as they may have different latencies)?

		/// add others  
};

struct framepars_past_t {
	unsigned long past_pars[PARS_SAVE_NUM];
};

struct framepars_all_t {
	struct framepars_t      framePars[PARS_FRAMES];
	struct framepars_t      func2call;        /// func2call.pars[] - each parameter has a 32-bit mask of what pgm_function to call - other fields not used
	unsigned long          globalPars[P_MAX_GPAR]; /// parameters that are not frame-related, their changes do not initiate any actions so they can be mmaped for both R/W
	struct framepars_past_t pastPars [PASTPARS_SAVE_ENTRIES];
};

struct frameparspair_t {
	unsigned long num;           // parameter index ( as defined by P_* constants) ored with "force new" (0x10000) - parameter value will be considered a new one
	unsigned long val;           // parameter value
};


//framePars errors - change to avoid defined in errno.h?
#define ERR_FRAMEPARS_TOOEARLY 100
#define ERR_FRAMEPARS_TOOLATE  101
#define ERR_FRAMEPARS_BADINDEX 102
#define ERR_PGM_TRYAGAINLATER  103 /// tried to program too early (gamma, ?)


#define FRAMEPARS_SETFRAME     0xff01
#define FRAMEPARS_SETFRAMEREL  0xff02
#define FRAMEPARS_SETLATENCY   0xff03
#define FRAMEPARS_SETFPGATIME  0xff04
#define FRAMEPARS_GETFPGATIME  0xff05

#define FRAME_DEAFAULT_AHEAD   3  // program current frame+3 if not specified


//!for structure mapping:
#define P_AUTOEXP P_AUTOEXP_ON
#define P_AEXPWND P_HISTWND_WIDTH


struct autoexp_t {
	unsigned long on;
	/*
	 * in percents: 1 == 1, 100 == 100
	 */
	unsigned long width;
	unsigned long height;
	unsigned long left;
	unsigned long top;
	/*
	 * start exposure time really not needed...
	 */
	unsigned long exp_max;		/* 100 usec == 1 etc... */
	unsigned long overexp_max;	/* percentages for overexposured pixels - 1% == 100, 5% == 500, 0.02% == 2 etc... */
	/*
	 * changed chema - balance exposition for set percent of pixels in needed index
	 */
	unsigned long s_percent;
	unsigned long s_index;
	/*
	 * return current state
	 */
	unsigned long exp;
	/*
	 * "sleep" settings
	 */
	unsigned long skip_pmin;	/* percent of delta for skip changes: 1% == 100 */
	unsigned long skip_pmax;	/* percent of changes for wait one frame before apply changes: 1% == 100 */
	unsigned long skip_t;		/* time for skip changes: 100 usec == 1 */
};
struct aexp_window_t {
	unsigned long width;
	unsigned long height;
	unsigned long top;
	unsigned long left;
};


struct p_names_t {
	int   value;
	char* name;
};

#define P_NAME_ENTRY(y) { P_##y, #y }
#define G_NAME_ENTRY(y) { G_##y, #y }
#define DEFINE_P_NAMES(x) struct p_names_t x[]= { \
	P_NAME_ENTRY(NUMBER), \
	P_NAME_ENTRY(SENSOR), \
	P_NAME_ENTRY(SENSOR_RUN), \
	P_NAME_ENTRY(SENSOR_SINGLE), \
	P_NAME_ENTRY(ACTUAL_WIDTH), \
	P_NAME_ENTRY(ACTUAL_HEIGHT), \
	P_NAME_ENTRY(BAYER), \
	P_NAME_ENTRY(PERIOD), \
	P_NAME_ENTRY(FP1000SLIM), \
	P_NAME_ENTRY(FRAME), \
	P_NAME_ENTRY(CLK_FPGA), \
	P_NAME_ENTRY(CLK_SENSOR), \
	P_NAME_ENTRY(FPGA_XTRA), \
	P_NAME_ENTRY(TRIG), \
	P_NAME_ENTRY(EXPOS), \
	P_NAME_ENTRY(BGFRAME), \
	P_NAME_ENTRY(IMGSZMEM), \
	P_NAME_ENTRY(PAGE_ACQ), \
	P_NAME_ENTRY(PAGE_READ), \
	P_NAME_ENTRY(OVERLAP), \
	P_NAME_ENTRY(VIRT_KEEP), \
	P_NAME_ENTRY(VIRT_WIDTH), \
	P_NAME_ENTRY(VIRT_HEIGHT), \
	P_NAME_ENTRY(WOI_LEFT), \
	P_NAME_ENTRY(WOI_TOP), \
	P_NAME_ENTRY(WOI_WIDTH), \
	P_NAME_ENTRY(WOI_HEIGHT), \
	P_NAME_ENTRY(FLIPH), \
	P_NAME_ENTRY(FLIPV), \
	P_NAME_ENTRY(FPSFLAGS), \
	P_NAME_ENTRY(DCM_HOR), \
	P_NAME_ENTRY(DCM_VERT), \
	P_NAME_ENTRY(BIN_HOR), \
	P_NAME_ENTRY(BIN_VERT), \
	P_NAME_ENTRY(FPGATEST), \
	P_NAME_ENTRY(TESTSENSOR), \
	P_NAME_ENTRY(COLOR), \
	P_NAME_ENTRY(FRAMESYNC_DLY), \
	P_NAME_ENTRY(PF_HEIGHT), \
	P_NAME_ENTRY(BITS), \
	P_NAME_ENTRY(SHIFTL), \
	P_NAME_ENTRY(FPNS), \
	P_NAME_ENTRY(FPNM), \
	P_NAME_ENTRY(VEXPOS), \
	P_NAME_ENTRY(VIRTTRIG), \
	P_NAME_ENTRY(PERIOD_MIN), \
	P_NAME_ENTRY(PERIOD_MAX), \
	P_NAME_ENTRY(SENSOR_PIXH), \
	P_NAME_ENTRY(SENSOR_PIXV), \
	P_NAME_ENTRY(GAINR), \
	P_NAME_ENTRY(GAING), \
	P_NAME_ENTRY(GAINB), \
	P_NAME_ENTRY(GAINGB), \
	P_NAME_ENTRY(RSCALE_ALL), \
	P_NAME_ENTRY(GSCALE_ALL), \
	P_NAME_ENTRY(BSCALE_ALL), \
	P_NAME_ENTRY(RSCALE), \
	P_NAME_ENTRY(GSCALE), \
	P_NAME_ENTRY(BSCALE), \
	P_NAME_ENTRY(RSCALE_CTL), \
	P_NAME_ENTRY(GSCALE_CTL), \
	P_NAME_ENTRY(BSCALE_CTL), \
	P_NAME_ENTRY(FATZERO), \
	P_NAME_ENTRY(QUALITY), \
	P_NAME_ENTRY(FP1000S), \
	P_NAME_ENTRY(SENSOR_WIDTH), \
	P_NAME_ENTRY(SENSOR_HEIGHT), \
	P_NAME_ENTRY(COLOR_SATURATION_BLUE), \
	P_NAME_ENTRY(COLOR_SATURATION_RED), \
	P_NAME_ENTRY(VIGNET_AX), \
	P_NAME_ENTRY(VIGNET_AY), \
	P_NAME_ENTRY(VIGNET_BX), \
	P_NAME_ENTRY(VIGNET_BY), \
	P_NAME_ENTRY(VIGNET_C), \
	P_NAME_ENTRY(VIGNET_SHL), \
	P_NAME_ENTRY(SCALE_ZERO_IN), \
	P_NAME_ENTRY(SCALE_ZERO_OUT), \
	P_NAME_ENTRY(DGAINR), \
	P_NAME_ENTRY(DGAING), \
	P_NAME_ENTRY(DGAINGB), \
	P_NAME_ENTRY(DGAINB), \
	P_NAME_ENTRY(ZBINROUND), \
	P_NAME_ENTRY(TILES), \
	P_NAME_ENTRY(SENSOR_PHASE), \
	P_NAME_ENTRY(AUTOEXP_ON), \
	P_NAME_ENTRY(HISTWND_RWIDTH), \
	P_NAME_ENTRY(HISTWND_RHEIGHT), \
	P_NAME_ENTRY(HISTWND_RLEFT), \
	P_NAME_ENTRY(HISTWND_RTOP), \
	P_NAME_ENTRY(AUTOEXP_EXP_MAX), \
	P_NAME_ENTRY(AUTOEXP_OVEREXP_MAX), \
	P_NAME_ENTRY(AUTOEXP_S_PERCENT), \
	P_NAME_ENTRY(AUTOEXP_S_INDEX), \
	P_NAME_ENTRY(AUTOEXP_EXP), \
	P_NAME_ENTRY(AUTOEXP_SKIP_PMIN), \
	P_NAME_ENTRY(AUTOEXP_SKIP_PMAX), \
	P_NAME_ENTRY(AUTOEXP_SKIP_T), \
	P_NAME_ENTRY(HISTWND_WIDTH), \
	P_NAME_ENTRY(HISTWND_HEIGHT), \
	P_NAME_ENTRY(HISTWND_TOP), \
	P_NAME_ENTRY(HISTWND_LEFT), \
	P_NAME_ENTRY(FOCUS_SHOW), \
	P_NAME_ENTRY(FOCUS_SHOW1), \
	P_NAME_ENTRY(FOCUS_LEFT), \
	P_NAME_ENTRY(FOCUS_WIDTH), \
	P_NAME_ENTRY(FOCUS_TOP), \
	P_NAME_ENTRY(FOCUS_HEIGHT), \
	P_NAME_ENTRY(FOCUS_TOTWIDTH), \
	P_NAME_ENTRY(FOCUS_FILTER), \
	P_NAME_ENTRY(TRIG_CONDITION), \
	P_NAME_ENTRY(TRIG_DELAY), \
	P_NAME_ENTRY(TRIG_OUT), \
	P_NAME_ENTRY(TRIG_PERIOD), \
	P_NAME_ENTRY(SKIP_FRAMES), \
	P_NAME_ENTRY(I2C_QPERIOD), \
	P_NAME_ENTRY(I2C_BYTES), \
	P_NAME_ENTRY(IRQ_SMART), \
	P_NAME_ENTRY(EARLY_TIMESTAMP), \
	P_NAME_ENTRY(OVERSIZE), \
	P_NAME_ENTRY(GTAB_R), \
	P_NAME_ENTRY(GTAB_G), \
	P_NAME_ENTRY(GTAB_GB), \
	P_NAME_ENTRY(GTAB_B), \
	P_NAME_ENTRY(RFOCUS_LEFT), \
	P_NAME_ENTRY(RFOCUS_WIDTH), \
	P_NAME_ENTRY(RFOCUS_TOP), \
	P_NAME_ENTRY(RFOCUS_HEIGHT), \
	P_NAME_ENTRY(SDRAM_CHN20), \
	P_NAME_ENTRY(SDRAM_CHN21), \
	P_NAME_ENTRY(SDRAM_CHN22), \
	P_NAME_ENTRY(COMPRESSOR_RUN), \
	P_NAME_ENTRY(COMPRESSOR_SINGLE), \
	P_NAME_ENTRY(COMPMOD_BYRSH), \
	P_NAME_ENTRY(COMPMOD_TILSH), \
	P_NAME_ENTRY(COMPMOD_DCSUB), \
	P_NAME_ENTRY(COMPMOD_QTAB), \
	P_NAME_ENTRY(SENSOR_REGS), \
	P_NAME_ENTRY(SENSOR_NUMREGS), \
	P_NAME_ENTRY(DAEMON_EN), \
	P_NAME_ENTRY(DAEMON_EN_AUTOEXPOSURE), \
	P_NAME_ENTRY(DAEMON_EN_STREAMER), \
	P_NAME_ENTRY(DAEMON_EN_CCAMFTP), \
	P_NAME_ENTRY(DAEMON_EN_CAMOGM), \
	P_NAME_ENTRY(DAEMON_EN_AUTOCAMPARS), \
	P_NAME_ENTRY(AEXP_FRACPIX), \
	P_NAME_ENTRY(AEXP_LEVEL), \
	P_NAME_ENTRY(HDR_DUR), \
	P_NAME_ENTRY(HDR_VEXPOS), \
	P_NAME_ENTRY(EXP_AHEAD), \
	P_NAME_ENTRY(AE_THRESH), \
	P_NAME_ENTRY(WB_THRESH), \
	P_NAME_ENTRY(AE_PERIOD), \
	P_NAME_ENTRY(WB_PERIOD), \
	P_NAME_ENTRY(WB_CTRL), \
	P_NAME_ENTRY(WB_MASK), \
	P_NAME_ENTRY(WB_EN), \
	P_NAME_ENTRY(WB_WHITELEV), \
	P_NAME_ENTRY(WB_WHITEFRAC), \
	P_NAME_ENTRY(WB_MAXWHITE), \
	P_NAME_ENTRY(WB_SCALE_R), \
	P_NAME_ENTRY(WB_SCALE_GB), \
	P_NAME_ENTRY(WB_SCALE_B), \
	P_NAME_ENTRY(HISTRQ), \
	P_NAME_ENTRY(HISTRQ_Y), \
	P_NAME_ENTRY(HISTRQ_C), \
	P_NAME_ENTRY(HISTRQ_YC), \
	P_NAME_ENTRY(PROFILE), \
	P_NAME_ENTRY(GAIN_MIN), \
	P_NAME_ENTRY(GAIN_MAX), \
	P_NAME_ENTRY(GAIN_CTRL), \
	P_NAME_ENTRY(GAIN_STEP), \
	P_NAME_ENTRY(ANA_GAIN_ENABLE), \
	P_NAME_ENTRY(AUTOCAMPARS_CTRL), \
	P_NAME_ENTRY(AUTOCAMPARS_GROUPS), \
	P_NAME_ENTRY(AUTOCAMPARS_PAGE), \
	P_NAME_ENTRY(AUTOCAMPARS_CMD), \
	P_NAME_ENTRY(FTP_PERIOD), \
	P_NAME_ENTRY(FTP_TIMEOUT), \
	P_NAME_ENTRY(FTP_UPDATE), \
	P_NAME_ENTRY(STROP_MCAST_EN), \
	P_NAME_ENTRY(STROP_MCAST_IP), \
	P_NAME_ENTRY(STROP_MCAST_PORT), \
	P_NAME_ENTRY(STROP_MCAST_TTL), \
	P_NAME_ENTRY(STROP_AUDIO_EN), \
	P_NAME_ENTRY(STROP_AUDIO_RATE), \
	P_NAME_ENTRY(STROP_AUDIO_CHANNEL), \
	P_NAME_ENTRY(STROP_FRAMES_SKIP), \
	P_NAME_ENTRY(AUDIO_CAPTURE_VOLUME), \
	G_NAME_ENTRY(DEBUG), \
	G_NAME_ENTRY(MAXAHEAD), \
	G_NAME_ENTRY(THIS_FRAME), \
	G_NAME_ENTRY(CIRCBUFSIZE), \
	G_NAME_ENTRY(FREECIRCBUF), \
	G_NAME_ENTRY(CIRCBUFWP), \
	G_NAME_ENTRY(CIRCBUFRP), \
	G_NAME_ENTRY(SECONDS), \
	G_NAME_ENTRY(MICROSECONDS), \
	G_NAME_ENTRY(CALLNASAP), \
	G_NAME_ENTRY(CALLNEXT), \
	G_NAME_ENTRY(NEXT_AE_FRAME), \
	G_NAME_ENTRY(NEXT_WB_FRAME), \
	G_NAME_ENTRY(HIST_DIM_01), \
	G_NAME_ENTRY(HIST_DIM_23), \
	G_NAME_ENTRY(AE_INTEGERR), \
	G_NAME_ENTRY(WB_INTEGERR), \
	G_NAME_ENTRY(TASKLET_CTL), \
	G_NAME_ENTRY(GFOCUS_VALUE), \
	G_NAME_ENTRY(HISTMODE_Y), \
	G_NAME_ENTRY(HISTMODE_C), \
	G_NAME_ENTRY(HIST_LAST_INDEX), \
	G_NAME_ENTRY(HIST_Y_FRAME), \
	G_NAME_ENTRY(HIST_C_FRAME), \
	G_NAME_ENTRY(SKIP_DIFF_FRAME), \
	G_NAME_ENTRY(FTP_NEXT_TIME), \
	G_NAME_ENTRY(DAEMON_ERR), \
	G_NAME_ENTRY(DAEMON_RETCODE), \
	G_NAME_ENTRY(PROFILING_EN), \
	G_NAME_ENTRY(SENSOR_CALIB) \
};

#define ONCHANGE_NAME_ENTRY(y) { onchange_##y, #y }
#define DEFINE_ONCHANGE_NAMES(x) struct p_names_t x[]= { \
	ONCHANGE_NAME_ENTRY(recalcseq), \
	ONCHANGE_NAME_ENTRY(detectsensor), \
	ONCHANGE_NAME_ENTRY(sensorphase), \
	ONCHANGE_NAME_ENTRY(i2c), \
	ONCHANGE_NAME_ENTRY(sensorregs), \
	ONCHANGE_NAME_ENTRY(initsensor), \
	ONCHANGE_NAME_ENTRY(afterinit), \
	ONCHANGE_NAME_ENTRY(window), \
	ONCHANGE_NAME_ENTRY(window_safe), \
	ONCHANGE_NAME_ENTRY(gains), \
	ONCHANGE_NAME_ENTRY(triggermode), \
	ONCHANGE_NAME_ENTRY(sensorin), \
	ONCHANGE_NAME_ENTRY(sensorstop), \
	ONCHANGE_NAME_ENTRY(sensorrun), \
	ONCHANGE_NAME_ENTRY(gamma), \
	ONCHANGE_NAME_ENTRY(hist), \
	ONCHANGE_NAME_ENTRY(aexp), \
	ONCHANGE_NAME_ENTRY(quality), \
	ONCHANGE_NAME_ENTRY(memsensor), \
	ONCHANGE_NAME_ENTRY(memcompressor), \
	ONCHANGE_NAME_ENTRY(limitfps), \
	ONCHANGE_NAME_ENTRY(exposure), \
	ONCHANGE_NAME_ENTRY(compmode), \
	ONCHANGE_NAME_ENTRY(focusmode), \
	ONCHANGE_NAME_ENTRY(trigseq), \
	ONCHANGE_NAME_ENTRY(irq), \
	ONCHANGE_NAME_ENTRY(comprestart), \
	ONCHANGE_NAME_ENTRY(compstop), \
	ONCHANGE_NAME_ENTRY(compctl), \
	ONCHANGE_NAME_ENTRY(gammaload), \
	ONCHANGE_NAME_ENTRY(prescal) \
};



/* i2c errors */
#ifndef ERR_I2C_SCL_ST0
#define	ERR_I2C_SCL_ST0		 1
#define	ERR_I2C_SDA_ST0		 2
#define	ERR_I2C_SCL_ST1		 4
#define	ERR_I2C_SDA_ST1		 8
#define	ERR_I2C_SCL_NOPULLUP 16
#define	ERR_I2C_SDA_NOPULLUP 32

/* i2c_diagnose called by i2c_start (?) could not find any problems. Try again start */
#define    ERR_I2C_NOTDETECTED  64
#define	ERR_I2C_SHORT		 128
#define	ERR_I2C_BSY		     256
#define	ERR_I2C_NACK		 512
#endif


/* supported ioctl _IOC_NR's */
#define IO_CCAM_SET_EXT_EXPOSURE  0x06
#define IO_CCAM_MONITOR_SEQ       0x07

//#define IO_CCAM_STOP_DMA	0x08
//#define IO_CCAM_START_DMA	0x09 // just starts DMA - descriptor list should be set eatlier
//#define IO_CCAM_START_RAW	0x0a // Programs DMA descriptor list according to current frame size, FPGA registers and starts DMA

/// MOST ARE OBSOLETE - WILL REMOVE WHEN UPDATING STREAMERS
#define IO_CCAM_JPEG		0x08 /// JPEG-compressor related commands

#define      JPEG_CMD_RESET       0x00 ///	Resets pointers - both acquisition and readout
//#define      JPEG_CMD_ARM       0x01 /// Prepare compressor to read next frame acquired
#define      JPEG_CMD_GET         0x02 /// Read current page (will return empty (and length==0) if not ready
#define      JPEG_CMD_FORGET      0x03 /// increment read frame pointer
#define      JPEG_CMD_CATCHUP     0x04 /// set read pointer to the last acquired (or acquiring if none is acquired yet)
#define      JPEG_CMD_ACQUIRE     0x05 /// acquire and compress one frame
#define      JPEG_CMD_SAVE_RP     0x06 /// save read pointer
#define      JPEG_CMD_RESTORE_RP  0x07 /// restore read pointer
#define      JPEG_CMD_N_DONE      0x08 /// return 1 if no more frames to be acquired (frame number)
#define      JPEG_CMD_L_DONE      0x09 /// return 1 if no more frames to be acquired (total length)
#define      JPEG_CMD_START       0x0a /// start constant compression mode
#define      JPEG_CMD_STOP        0x0b /// stop constant compression mode (may want to wait for CAMSEQ_DONE)
#define      JPEG_CMD_FRAMES      0x0c /// returns number of frames in buffer, (re)uilds frames chain
#define      JPEG_CMD_JUST_STOP   0x0d /// just stop - don't start cycle if was allready off!
#define      JPEG_CMD_DUMP        0x0f /// printk all static data/tables
#define      JPEG_CMD_RESET0      0x10 /// same as JPEG_CMD_RESET, but non-zero, to be used from lseek (SEEK_END)

//#define      PROGRAM_SENSOR_0     0x11 /// programSensor(0) - to be used from lseek (SEEK_END)
//#define      PROGRAM_SENSOR_1     0x12 /// programSensor(1) - to be used from lseek (SEEK_END)
/// Compressor state now applies only to particular frame
//#define      LSEEK_CAMSEQSTATE    0x13 /// return camSeqState - to be used from lseek (SEEK_END)
#define      LSEEK_GAMMA_INIT        1 // SEEK_END LSEEK_GAMMA_INIT to initialize all the gamma data structures
#define      LSEEK_GAMMA_ISCURRENT   2 // SEEK_END to check if the selected node(pointed by file pointer) is current - returns 0 if not, otherwise - node index

// parameters for lseek circbuf
#define      LSEEK_CIRC_TORP         1
#define      LSEEK_CIRC_TOWP         2
#define      LSEEK_CIRC_PREV         3
#define      LSEEK_CIRC_NEXT         4
#define      LSEEK_CIRC_LAST         5
#define      LSEEK_CIRC_FIRST        6
#define      LSEEK_CIRC_SCND         7
#define      LSEEK_CIRC_SETP         8
#define      LSEEK_CIRC_VALID        9
#define      LSEEK_CIRC_READY       10
#define      LSEEK_CIRC_WAIT        11
#define      LSEEK_CIRC_FREE        12
#define      LSEEK_CIRC_USED        13

#define      LSEEK_HUFFMAN_DC0      1
#define      LSEEK_HUFFMAN_AC0      2
#define      LSEEK_HUFFMAN_DC1      3
#define      LSEEK_HUFFMAN_AC1      4
#define      LSEEK_HUFFMAN_FPGATAB  5
#define      LSEEK_HUFFMAN_DEFAULT  6
#define      LSEEK_HUFFMAN_FPGACALC 7
#define      LSEEK_HUFFMAN_FPGAPGM  8

//#define      LSEEK_RESET_SENSOR   0x14 /// reset sensor and FPGA - next time will reprogram it
//#define      LSEEK_INIT_SENSOR    0x15 /// initialise SDRAM and sensor if it is not programmed yet (or reset)

#define      LSEEK_GET_FPGA_TIME  0x16 /// get FPGA timer to G_SECONDS, G_MICROSECONDS
#define      LSEEK_SET_FPGA_TIME  0x17 /// set FPGA timer to G_SECONDS, G_MICROSECONDS

//#define      LSEEK_FLUSH_CACHE    0x18 // workaround for Axis mmap cache coherency problems - flush all cache (8KB)
#define      LSEEK_AUTOEXP_SET    0x19 /// set autoexposure parameters
#define      LSEEK_AUTOEXP_GET    0x1a /// copy window and exposure parameters to autoexp_state
#define      LSEEK_TRIGGER_PGM    0x1b /// program trigger parameters
#define      LSEEK_I2C_PGM        0x1c /// program hardware i2c speed/bytes
#define      LSEEK_IRQ_SMART_PGM  0x1d /// program "smart" irq modes (+1 - wait VACT, +2 - wait dma fifo)
#define      LSEEK_EARLY_TIMESTAMP_PGM 0x1e /// 1 - early timestamp in async mode, 0 (or sync) - uses start of first visible line readout
#define      LSEEK_DMA_INIT       0x1f /// (re-) initialize ETRAX DMA for compressor 
#define      LSEEK_DMA_STOP       0x20 /// STOP ETRAX DMA
#define      LSEEK_DMA_START      0x21 /// STARTETRAX DMA
#define      LSEEK_COMPRESSOR_RESET 0x22 /// reset compressor and pointers
#define      LSEEK_INTERRUPT_OFF  0x23 /// disable camera interrupts
#define      LSEEK_INTERRUPT_ON   0x24 /// enable camera interrupts

#define      LSEEK_FRAMEPARS_INIT 0x25 /// reset hardware sequencers, init framepars structure
#define      LSEEK_SENSORPROC     0x26 /// process modified parameters in frame 0 (to start sensor detection)

#define      LSEEK_FRAME_RESET    0x27 /// reset absolute frame number to avoid integer overflow

///Histograms related commands
#define      LSEEK_HIST_WAIT_Y    0x28 /// set histogram waiting for the Y (actually G1) histogram (default after open)
#define      LSEEK_HIST_WAIT_C    0x29 /// set histogram waiting for the C (actually R, G2, B) histograms to become available - implies G1 too
#define      LSEEK_HIST_REQ_EN    0x2a /// enable histogram request when reading histogram (safer, but may be not desirable in HDR mode) - default after opening
#define      LSEEK_HIST_REQ_DIS   0x2b /// disable histogram request when reading histogram - will read latest available relying it is available
#define      LSEEK_HIST_NEEDED    0x10000 /// set histogram "needed" mask - 0x10000..0x1ffff
//#define      LSEEK_HIST_WAIT_AE   0x2a /// wait for autoexposure enabled

#define      LSEEK_DAEMON_FRAME   0x80 ///  LSEEK_DAEMON_FRAME+B wait for frame interrupt and corresponding bit (B) in P_DAEMON_EN is set
#define      LSEEK_DAEMON_CIRCBUF 0xa0 ///  LSEEK_DAEMON_FRAME+B wait for frame compressed interrupt and corresponding bit (B) in P_DAEMON_EN is set
#define      LSEEK_DAEMON_HIST_Y  0xc0 ///  LSEEK_DAEMON_FRAME+B wait for histogram Y ready and corresponding bit (B) in P_DAEMON_EN is set
#define      LSEEK_DAEMON_HIST_C  0xe0 ///  LSEEK_DAEMON_FRAME+B wait for all histograms ready and corresponding bit (B) in P_DAEMON_EN is set


#define      LSEEK_FRAME_WAIT_REL 0x100 /// LSEEK_WAIT_FRAME_REL+N - skip N frames (0<N<256)
#define      LSEEK_FRAME_WAIT_ABS 0x200 /// LSEEK_WAIT_FRAME_ABS+N - wait absolute frame N

#define      LSEEK_FSDRAM_RESET   0x01 // re-program FSDRAM (to be programmed again when accessed)

#define      JPEG_CTRL_MONOCHROME    0x400
#define      JPEG_CTRL_MONOCHROME_BLOCKED    0x1000
#define      JPEG_CTRL_NOMOSAIC    0x1000

#define IO_CCAM_JPEG_QUALITY	0x09 // Set P_QUALITY

#define IO_CCAM_JPEG_GET_N	0x0a	// get specified number of frames (will add to already asked for if any)
#define IO_CCAM_JPEG_GET_L	0x0b	// get specified length (will stop after frame if got more)

#define IO_CCAM_JPEG_CTRL	0x0c // Write JPEG control word (0x10000 - use header, LSW - other settings)
#define IO_CCAM_DMA		0x0d
#define CCAM_DMA_CMD_STOP	  0x00
#define CCAM_DMA_CMD_START  0x01 // just starts DMA - descriptor list should be set eatlier

#define IO_CCAM_CR_MODIFY 0x0e	//(bit number)<<2 | op; op= 0 - nop, 1 - set, 2 - reset, 3 - toggle)
#define IO_CCAM_CR_SHADOW 0x0f

#define IO_CCAM_PINS_WRITE	0x20
#define IO_CCAM_PINS_READ	0x21


#define LSEEK_NAME_ENTRY(y) { LSEEK_##y, #y }
#define DEFINE_LSEEK_NAMES(x) struct p_names_t x[]= { \
	LSEEK_NAME_ENTRY(GAMMA_INIT), \
	LSEEK_NAME_ENTRY(GAMMA_ISCURRENT), \
	LSEEK_NAME_ENTRY(CIRC_TORP), \
	LSEEK_NAME_ENTRY(CIRC_TOWP), \
	LSEEK_NAME_ENTRY(CIRC_PREV), \
	LSEEK_NAME_ENTRY(CIRC_NEXT), \
	LSEEK_NAME_ENTRY(CIRC_LAST), \
	LSEEK_NAME_ENTRY(CIRC_FIRST), \
	LSEEK_NAME_ENTRY(CIRC_SCND), \
	LSEEK_NAME_ENTRY(CIRC_SETP), \
	LSEEK_NAME_ENTRY(CIRC_VALID), \
	LSEEK_NAME_ENTRY(CIRC_READY), \
	LSEEK_NAME_ENTRY(CIRC_WAIT), \
	LSEEK_NAME_ENTRY(CIRC_FREE), \
	LSEEK_NAME_ENTRY(CIRC_USED), \
	LSEEK_NAME_ENTRY(HUFFMAN_DC0), \
	LSEEK_NAME_ENTRY(HUFFMAN_AC0), \
	LSEEK_NAME_ENTRY(HUFFMAN_DC1), \
	LSEEK_NAME_ENTRY(HUFFMAN_AC1), \
	LSEEK_NAME_ENTRY(HUFFMAN_FPGATAB), \
	LSEEK_NAME_ENTRY(HUFFMAN_DEFAULT), \
	LSEEK_NAME_ENTRY(HUFFMAN_FPGACALC), \
	LSEEK_NAME_ENTRY(HUFFMAN_FPGAPGM), \
	LSEEK_NAME_ENTRY(GET_FPGA_TIME), \
	LSEEK_NAME_ENTRY(SET_FPGA_TIME), \
	LSEEK_NAME_ENTRY(AUTOEXP_SET), \
	LSEEK_NAME_ENTRY(AUTOEXP_GET), \
	LSEEK_NAME_ENTRY(TRIGGER_PGM), \
	LSEEK_NAME_ENTRY(I2C_PGM), \
	LSEEK_NAME_ENTRY(IRQ_SMART_PGM), \
	LSEEK_NAME_ENTRY(EARLY_TIMESTAMP_PGM), \
	LSEEK_NAME_ENTRY(DMA_INIT), \
	LSEEK_NAME_ENTRY(DMA_STOP), \
	LSEEK_NAME_ENTRY(DMA_START), \
	LSEEK_NAME_ENTRY(COMPRESSOR_RESET), \
	LSEEK_NAME_ENTRY(INTERRUPT_OFF), \
	LSEEK_NAME_ENTRY(INTERRUPT_ON), \
	LSEEK_NAME_ENTRY(FRAMEPARS_INIT), \
	LSEEK_NAME_ENTRY(SENSORPROC), \
	LSEEK_NAME_ENTRY(FRAME_RESET), \
	LSEEK_NAME_ENTRY(HIST_WAIT_Y), \
	LSEEK_NAME_ENTRY(HIST_WAIT_C), \
	LSEEK_NAME_ENTRY(HIST_REQ_EN), \
	LSEEK_NAME_ENTRY(HIST_REQ_DIS), \
	LSEEK_NAME_ENTRY(HIST_NEEDED), \
	LSEEK_NAME_ENTRY(DAEMON_FRAME), \
	LSEEK_NAME_ENTRY(DAEMON_CIRCBUF), \
	LSEEK_NAME_ENTRY(DAEMON_HIST_Y), \
	LSEEK_NAME_ENTRY(DAEMON_HIST_C), \
	LSEEK_NAME_ENTRY(FRAME_WAIT_REL), \
	LSEEK_NAME_ENTRY(FRAME_WAIT_ABS), \
	LSEEK_NAME_ENTRY(FSDRAM_RESET) \
};


#define CCAM_BYTES_PER_CHUNK  (1<<16)  /* dma buffer bytes per descriptor */
#define CCAM_DESCR_PER_CHUNK  1
/* If CCAM_CHUNK_PER_DMABUF is 100 then buffer is about 6.5 million bytes
 *       which is probably bigger than any single image we'll generate,
 *       and is also bigger than raw data (which is 5.5MB).
 *       However, images bigger than 6.5/2 == 3.25 million bytes will
 *       not be able to be double-buffered and thus will slow things down.
 */
// increasing 3 times - about 20MB
//#define CCAM_CHUNK_PER_DMABUF 102  /* no. of 64Kbyte chunks per buffer */
#define CCAM_CHUNK_PER_DMABUF 302  /* no. of 64Kbyte chunks per buffer */
#define CCAM_WORDS_PER_DMABUF (CCAM_CHUNK_PER_DMABUF<<14) /*32bit words...*/
#define CCAM_BYTES_PER_DMABUF (CCAM_CHUNK_PER_DMABUF<<16)
/*  For past compatibility, CCMA_DMA_SIZE...
 */
#define CCAM_DMA_SIZE CCAM_WORDS_PER_DMABUF
/*
 *       CCAM_MMAP_OFFSET... -- offsets in bytes in memory mapped region.
 *       CCAM_MMAP_SIZE -- no. of bytes to mmap.
 */       
#define CCAM_MMAP_OFFSET_MMAP_HEADER 0
#define CCAM_MMAP_OFFSET_JPEG_HEADER (PAGE_SIZE)
#define CCAM_MMAP_OFFSET_DMABUF (4*PAGE_SIZE)
#define CCAM_MMAP_SIZE (PAGE_SIZE*sizeof(long)+CCAM_BYTES_PER_DMABUF)

#define CCAM_MMAP_META 12 // extra bytes included at the end of each frame (last aligned to 32 bytes)
#define CCAM_MMAP_META_LENGTH 4 // displacement to length frame length data from the end of the 32-byte aligned frame slot
#define CCAM_MMAP_META_USEC 8 // (negative) displacement to USEC data - 20 bits (frame timestamp)
#define CCAM_MMAP_META_SEC 12 // (negative) displacement to SEC data - 32 bits (frame timestamp)

//!Moved from cc353.c
#define CX313_FPGA_TABLES_SIZE 0xC00 //=3000 bytes, 32-bit wide, LSB first, some tables use less
#define CX313_FPGA_TABLES_QUANT 0x0   // 0x200 words quantization (8*64*2/2)
#define CX313_FPGA_TABLES_HUFF  0x200   // 0x200 words Huffman table
#define CX313_FPGA_TABLES_GAMMA 0x400 // 0x400 words gamma-correction (or arbitrary table)
#define CX313_FPGA_TABLES_FOCUS 0x800 // 15*64 16-bit words (now high 16 bits are unused)
#define CX313_FPGA_TABLES_FOCUSPARS 0xbc0 //block of focus-related parameters: left[11:0],right[11:0],top[11:0],bottom[11:0],full_width[11:0],filter_sel[3:0]


// make this structure common for sensors, add fields as needed
struct sensor_t {
	// sensor constants
	unsigned long  imageWidth;     /// nominal image width for final images
	unsigned long  imageHeight;    /// nominal image height for final images
	unsigned long  clearWidth;     /// maximal clear (useful) image width
	unsigned long  clearHeight;    /// maximal clear (useful) image height;
	unsigned long  clearTop;       /// top margin to the first clear pixel
	unsigned long  clearLeft;      /// left margin to the first clear pixel
	unsigned long  arrayWidth;     /// total image array width (including black and boundary)
	unsigned long  arrayHeight;    /// total image array height (including black and boundary)
	unsigned long  minWidth;       /// minimal WOI width
	unsigned long  minHeight;      /// minimal WOI height
	unsigned long  minHorBlank;    /// minimal horizontal blanking, in pixels in no-decimation, no-binning mode.
	unsigned long  minLineDur;     /// minimal total line duration, in pixels in no-decimation, no-binning mode.
	unsigned long  maxHorBlank;    /// maximal horizontal blanking/Virtual frame width (depends on sensor type)
	unsigned long  minVertBlank;   /// minimal vertical blanking
	unsigned long  maxVertBlank;   /// maximal vertical blanking/Virtual frame height (depends on sensor type)
	unsigned long  maxShutter;     /// Maximal shutter duration (in lines)
	unsigned long  flips;          /// capabilities: bit mask bit 0 - flipX, 1 - flipY
	unsigned long  init_flips;     /// normal orientation flips bit mask bit 0 - flipX, 1 - flipY. will be XOR-ed with [P_FLIP] to get sensor flip
	unsigned long  bayer;          /// bayer shift for flips==0
	unsigned long  dcmHor;         /// bit mask bit 0 - 1:1, bit 31 - by 32
	unsigned long  dcmVert;        /// bit mask bit 0 - 1:1, bit 31 - by 32
	unsigned long  binHor;         /// bit mask bit 0 - 1:1, bit 31 - by 32
	unsigned long  binVert;        /// bit mask bit 0 - 1:1, bit 31 - by 32
	unsigned long  maxGain256;     /// maximal analog gain times 0x100
	unsigned long  minClockFreq;   /// Minimal clock frequency
	unsigned long  maxClockFreq;   /// Maximal clock frequency
	unsigned long  nomClockFreq;   ///nominal clock frequency
	unsigned long  sensorType;     /// sensor type (for Elphel cameras)
	unsigned long  i2c_addr;       /// i2c address
	unsigned long  i2c_period;     /// SCL period in ns, (standard i2c - 2500)
	unsigned long  i2c_bytes;      /// number of bytes/ register
	unsigned long  hact_delay;     /// hact delay (in ps) from data
	unsigned short sensorPhase90;  /// (0..3) 90-degree shift (fpcf -w 8 80)
	signed   short sensorPhase;    /// positive "fpcf -w 8 20", negative - "fpcf -w 8 10"
	unsigned long  needReset;      /// bit 0 - need reset after clock frequency change, bit 1 - need reset after phase change
};
#define SENSOR_NEED_RESET_CLK   1
#define SENSOR_NEED_RESET_PHASE 2

struct sensorproc_t {
	struct sensor_t sensor;
	/// functions return <0 on error (and do nothing)
	/// first 32 functions are called directly when appropriate bit is set, next 32 - sensor specific that are called
	/// by corresponding one with (number-32) if not NULL. Sensor initilaization should set up those functions
	int (*pgm_func[64]) (struct sensor_t    * sensor,     /// pointer to sensor parameters
			struct framepars_t * framepars,  /// pointer to structure with array of current frame parameters
			struct framepars_t * prevpars,   /// pointer to structure with array of previous frame parameters
			int                  frame8);    /// frame to program (latency applied), -1 - ASAP
};


/*!***************************************************************************************************
 *! This is essential data related to the last frame aquired to be stored in the circular buffer before
 *! each frame received from the FPGA - place where FPGA data is padded by 32 bytes of 0.
 *! 6 bytes are already used by next frame pointer signature, so only 26 bytes are left
 *! Structure also includes 8 bytes of timestamp (after 2 bytes skipped) - they will be obtained from the circbuf data
 *! that goes after the encoded frame, so total is 36 bytes (26+2+8)
 !****************************************************************************************************/
// move fram x353.h 
#define DEFAULT_COLOR_SATURATION_BLUE 0x90 // 100*realtive saturation blue
#define DEFAULT_COLOR_SATURATION_RED  0xb6 // 100*realtive saturation red

//#define EXPOSURE_UNIT 100 // to move to finer exposure settings - current unit in microseconds. TODO: Propagate it to drivers...
#define EXPOSURE_UNIT 1 // to move to finer exposure settings - current unit in microseconds. TODO: Propagate it to drivers...
/// width,height, quality are still needed even with new Exif - it is used to rebuild JPEG header

// most parameters are moved out, but width, height, quality are needed for JPEG header, so currently the following are used:
/// width
/// height
/// quality
/// meta_index
/// signffff
/// timestamp_sec (camogm only, exif is separate)
/// timestamp_usec (camogm only, exif is separate)
struct interframe_params_t {
	/// This data will survive as long as the frame itself in the circular buffer. Some other fields (like exposure) are stored in Exif 
	/// dont move - should partially match P_* area
	union{
		unsigned long hash32_r; 
		struct{
			unsigned short scale_r; 
			union {
				unsigned short hash16_r; 
				struct{
					unsigned char gamma_r; 
					unsigned char black_r; 
				};
			};
		};
	}; ///00-03
	
	union{
		unsigned long hash32_g; struct{unsigned short scale_g; union {unsigned short hash16_g; struct{unsigned char gamma_g; unsigned char black_g; };};};}; ///04-07
	union{
		unsigned long hash32_gb;struct{unsigned short scale_gb;union {unsigned short hash16_gb;struct{unsigned char gamma_gb;unsigned char black_gb;};};};}; ///08-11
	union{
		unsigned long hash32_b; struct{unsigned short scale_b; union {unsigned short hash16_b; struct{unsigned char gamma_b; unsigned char black_b; };};};}; ///12-15
	unsigned short quality2;       /// Quality is represented by 2-byte value. Each byte uses Y table if the value is Q<128,// 16-17
	/// and C table with (Q-128) if it is Q>=128.
	/// If the High byte is zero, it is treated as Q^0x80  (Q|=(Q^0x80)<<8) for compatibility
	/// with a standard single-byte Q value
	unsigned char  color;          /// color mode //18
	unsigned char  byrshift;       /// bayer shift in compressor //19
	unsigned short width;          /// frame width, pixels   20-21 - NOTE: should be 20-21
	unsigned short height;         /// frame height, pixels  22-23

# if 0
	/*00-03*/ unsigned long  exposure;       //  currently - exposure time measured in 100usec. Really need to change it to smaller increments?
	/*04-05*/ unsigned short width;          //! frame width, pixels
	/*06-07*/ unsigned short height;         //! frame height, pixels
	/*08-11*/ unsigned long  colorsat;       //  matches FPGA format , for 1.0 it is DEFAULT_COLOR_SATURATION_RED<<16 + DEFAULT_COLOR_SATURATION_BLUE
	/*12   */ unsigned char  color;          //  0 - mono, 1 - color, 2 - jp4 + (0x40 - flipX) + (0x80 - flipY) 
	/*13   */ unsigned char  quality;        //! compression quality (%)
	/*14   */ unsigned char  gamma;          //  (%), 255 - non-gamma curve, 0 - raw (16-bit data) - not yet implemented
	/*15   */ unsigned char  black;          //  black level shift (255 - full scale)
	/*16-17*/ unsigned short rscale;         //  8.8 - red  relative to green - "gamma" table, not sensor gain
	/*18-19*/ unsigned short bscale;         //  8.8 - blue relative to green - "gamma" table, not sensor gain


	/*20-21*/ unsigned short unused20;       ///  unused for now
	/*22-23*/ unsigned short past_index;     ///  index in the array of past frames
#endif

	/*24   *//// unsigned char  bindec_hor;     //! ((bh-1) << 4) | (dh-1) & 0xf (binning/decimation horizontal, 1..16 for each)
	/*25   *//// unsigned char  bindec_vert;    //! ((bv-1) << 4) | (dv-1) & 0xf (binning/decimation vertical  , 1..16 for each)
	/*24-25*/ unsigned short meta_index;     //! index of the linked meta page

	/*26-27*/ unsigned short signffff;       //! should be 0xffff - it will be a signature that JPEG data was not overwritten,
	//! JPEG bitstream can not have two 0xff after each other
	union {
		/*28-31*/ unsigned long  timestamp_sec ; //! number of seconds since 1970 till the start of the frame exposure
		/*28-31*/ unsigned long  frame_length ;  //! JPEG frame length in circular buffer, bytes
	};
	/*32-35*/ unsigned long  timestamp_usec; //! number of microseconds to add
};

struct i2c_timing_t {
	unsigned char scl_high; //0x02, //! SCL high:
	unsigned char scl_low;  //0x02, //! SCL low:
	unsigned char slave2master; //0x01, //! slave -> master
	unsigned char master2slave; //0x01, //! master -> slave
	unsigned char filter_sda;   //0x07, //! filter SDA read data by testing multiple times - currently just zero/non zero
	unsigned char filter_scl;  //0x07};//! filter SCL read data by testing multiple times - currently just zero/non zero 
	};

/// Gamma data for one component, including direct and reverse tables, hash (i.e. black level+gamma) and links for caching
#define GAMMA_CACHE_NUMBER 256 // number of gamma-tables cached
#define GAMMA_VALID_MASK    1  // table is calculated, matches given hash/scale
#define GAMMA_VALID_REVERSE 2  // reverse table is calculated for the given hash/scale
#define GAMMA_FPGA_MASK     4  // gamma-table encoded for the FPGA is valid
//#define GAMMA_LOCK_MASK     8  // table is locked until programmed to FPGA - now locked is a separate member

// bits passed in int mode
#define GAMMA_MODE_NOT_NICE     1  // if set, no interrupts will be enabled between steps, whole operation is atomic
#define GAMMA_MODE_NEED_REVERSE 2  // reverse gamma table is needed
#define GAMMA_MODE_HARDWARE     4  // the table is needed to program FPGA: fpga-encoded table will be calculated (if not yet),
#define GAMMA_MODE_LOCK         8  // Lock the table for the specified color (used from irq/tasklet - it is needed because all 4 tables in FPGA have to be overwritten at once)

#define GAMMA_SCALE_SHIFT     10  // when scaling - shift right by GAMMA_SCALE_SHIFT (treat scale as 6.10)
#define GAMMA_SCLALE_1 ( 1 << GAMMA_SCALE_SHIFT )      // gamma scale 1.0 - 0x400
struct gamma_stuct_t {
	union {
		unsigned long hash32; /// fully identifies current table
		struct {
			unsigned short scale; /// 6.10: 0x400 is 1.0 scale (>=1.0) is applied in the driver, saturating result
			union {
				unsigned short hash16; /// scale-independent part of the table (tables themselves are calculated outside of the driver)
				struct {
					unsigned char gamma; /// "gamma" in the range 0.0 ... 2.55
					unsigned char black; /// black level to subtract (scaled to full scale) from the input data
				};
			};
		};
	};
	int valid;      /// 0 - table invalid, 1 - table valid +2 for table locked (until sent to FPGA)
	//          int locked;     /// bit frame+ (color<<3) locked for color/frame
	int locked;     /// NOTE: Changed to just color locked for color
	int this_non_scaled;      // 0 for non-scaled, others - (for scaled) - pointer to the corresponding non-scaled 
	union { /// used in head (element 0) and non-scaled chain (not used in scaled)
		struct { /// element 0 - heads of the chains
			int oldest_non_scaled; // 
			int newest_non_scaled; // 
		};
		struct { /// non-scaled (gamma data is full 16-bit)
			int newer_non_scaled; // table type (non-scaled prototype) used later than this one
			int older_non_scaled; // table type (non-scaled prototype) used before this one
		};
	};
	union {  /// used in head (element 0) and scaled chain (not used in non-scaled) (or maybe it will be used?)
		struct { /// element 0 - heads of the chains
			int oldest_all;    // 
			int newest_all;    //
		};
		struct { /// scaled (gamma data is hardware defined 10 bit)
			int newer_all;    /// newer in a single  chain of all scaled tables, regardless of the prototype
			int older_all;    /// older in a single  chain of all scaled tables, regardless of the prototype
			/// *_all also includes yet unused nodes (after init)
		};
	};
	union { /// used in non-scaled and scaled, not in the head (element 0)
		struct { /// non-scaled
			int oldest_scaled;    // oldest derivative of this prototype (scaled)
			int newest_scaled;    // newest derivative of this prototype (scaled)
		};
		struct { /// scaled (gamma data is hardware defined 10 bit)
			int newer_scaled; // table type (non-scaled prototype) used later than this one
			int older_scaled; // table type (non-scaled prototype) used before this one
		};
		struct { /// reuse in the head (element 0) - to make this variable visible through mmap to PHP (for debugging)
			int non_scaled_length; // current number of different hash values
			int num_locked;        // number of nodes locked (until table sent to FPGA)
		};
	};
	union {
		struct { 
			unsigned short direct[257];   // "Gamma" table, 16-bit for both non-scaled prototypes and scaled, 0..0xffff range (hardware will use less)
			unsigned short dummy1;        // to have it 32-bit aligned
			//              unsigned short reverse[256];  // reverse table to speed-up reversing (still need interpolation).Index - most significant 8 bits, data - largest direct argument...
			unsigned char reverse[256];  /// reverse table to speed-up reversing. No division, but needs interpolation by the application
			unsigned long fpga[256]; // data encoded for FPGA "gamma" table (18 bits, "floating point")
		};
		struct {
			//             int locked_col_frame[4 * PARS_FRAMES]; //index of the table to load to color/frame (should be locked, until unlocked)
			int locked_color[4]; /// NOTE: Changed to just color (locked last written to FPGA - maybe needed again, as the FPGA needs all table to be overwritten - two pages)
			//             int other [129+128+256 -(4 * PARS_FRAMES)];
			//             int other [129+64+256 -(4 * PARS_FRAMES)];
			int other [129+64+256 -4];
		};
	};
};

///histograms related structure
#define HISTOGRAM_CACHE_NUMBER 8 // number of frames histograms are kept after acquisition (should be 2^n)
#define COLOR_RED            0
#define COLOR_GREEN1         1
#define COLOR_GREEN2         2 
#define COLOR_BLUE           3


#define COLOR_Y_NUMBER      COLOR_GREEN1 // green1 (index=1) is used as Y color (i.e. for auto exposure). Histogram for is calculated first (or only)
/*
/// the following 8 values should go in the same sequence as fields in the histogram page
#define P_FRAME          136 // Frame number (reset with JPEG pointers) -(read only)
#define P_GAINR          137 // R channel gain  8.16 (0x10000 - 1.0). Combines both analog gain and digital scaling
#define P_GAING          138 // G channel gain ("red line")
#define P_GAINGB         139 // G channel gain ("blue line")
#define P_GAINB          140 // B channel gain
#define P_EXPOS          141 //P_RW_EXPOS  1   exposure time      - now in microseconds?
#define P_VEXPOS         142 // video exposure (if 0 - use P_RW_EXPOS in ms)
#define P_FOCUS_VALUE    143 // (readonly) - sum of all blocks focus values inside focus WOI

 */

#define HISTOGRAM_TABLE_OFFSET 52 /// Histogram tables data starts 44 bytes from the histogram page structure (for PHP raw histogram)
///TODO: Update when histogram_stuct_t is changed
struct histogram_stuct_t {
	unsigned long frame;                /// frame number correspoding to the current histogram
	/// Color gains for the frame of the histogram
	union {
		unsigned long gains[4];
		struct {
			unsigned long gain_r;
			unsigned long gain_g;
			unsigned long gain_gb;
			unsigned long gain_b;
		};
	};
	unsigned long expos;                /// Exposure time (usec) for the frame of the histogram
	unsigned long vexpos;               /// number of exposure lines for the frame of the histogram
	unsigned long focus;                /// sum of all blocks focus values inside focus WOI
	unsigned long valid;                /// bit mask of valid arrays (0 - hist_r, ... ,4-cumul_hist_r, ...,  11 - percentile_b)

	/// Gamma tables hash values for the frame of the histogram
	union {
		unsigned long gtab[4];
		struct {
			unsigned long gtab_r;
			unsigned long gtab_g;
			unsigned long gtab_gb;
			unsigned long gtab_b;
		};
	};
	/// Direct histograms, loaded from the FPGA
	union {
		unsigned long hist[1024] ;          /// All 4 histograms
		struct {
			unsigned long hist_r [256] ;        /// Histogram for the red component
			unsigned long hist_g [256] ;        /// Histogram for the first green component (in the "red" line)
			unsigned long hist_gb[256] ;        /// Histogram for the second green component (in the "blue" line)
			unsigned long hist_b [256] ;        /// Histogram for blue component
		};
	};
	/// Direct cumulative histograms, calculated from the loaded from the FPGA
	union {
		unsigned long cumul_hist[1024] ;          /// All 4 cumulative histograms
		struct {
			unsigned long cumul_hist_r [256] ;    /// Cumulative histogram for the red component
			unsigned long cumul_hist_g [256] ;    /// Cumulative histogram for the first green component (in the "red" line)
			unsigned long cumul_hist_gb[256] ;    /// Cumulative histogram for the second green component (in the "blue" line)
			unsigned long cumul_hist_b [256] ;    /// Cumulative histogram for blue component
		};
	};
	/// Calculated reverse cumulative histograms (~percentiles) - for the given 1 byte input X (0 - 1/256 of all pixels, ..., 255 - all pixels)
	/// returns threshold value P (0..255), so that number of pixels with value less than x is less or equal to (P/256)*total_number_of_pixels,
	/// and number of pixels with value less than (x+1) is greater than (P/256)*total_number_of_pixels,
	/// P(0)=0, P(256)=256 /not included in the table/
	/// percentiles arrays are calculated without division for each element, interpolation (with division) will be done only for the value of interest
	/// on demand, in the user space.
	/// NOTE: - argument is _output_ value (after gamma-correction), reverse gamma table is needed to relate percentiles to amount of light (proportional to exposure)
	union {
		unsigned char percentile[1024] ;     /// All 4 percentiles
		struct {
			unsigned char percentile_r [256] ; /// percentile for the red component
			unsigned char percentile_g [256] ; /// percentile for the first green component (in the "red" line)
			unsigned char percentile_gb[256] ; /// percentile for the second green component (in the "blue" line)
			unsigned char percentile_b [256] ; /// percentile for the blue component
		};
	};

};

/// Used to provide encoded huffman tables. Those tables (4 of them) will be used in the output JPEG/JP4 files
/// and whill be programmed to the FPGA
struct huffman_encoded_t {
	unsigned char bits[16];     /// number of symbols with length k+1
	unsigned char huffval[256]; /// The symbols, in order of incr code length
};

/// All other integer constants exported to PHP space (C:"CONSTANT" -> PHP:"ELPHEL_CONST_CONSTANT)
#define CONST_NAME_ENTRY(y) { y, #y }
#define DEFINE_CONST_NAMES(x) struct p_names_t x[]= { \
	CONST_NAME_ENTRY(SENSOR_RUN_STOP), \
	CONST_NAME_ENTRY(SENSOR_RUN_SINGLE), \
	CONST_NAME_ENTRY(SENSOR_RUN_CONT), \
	CONST_NAME_ENTRY(COMPRESSOR_RUN_STOP), \
	CONST_NAME_ENTRY(COMPRESSOR_RUN_SINGLE), \
	CONST_NAME_ENTRY(COMPRESSOR_RUN_CONT), \
	CONST_NAME_ENTRY(TASKLET_CTL_PGM), \
	CONST_NAME_ENTRY(TASKLET_CTL_IGNPAST), \
	CONST_NAME_ENTRY(TASKLET_CTL_NOSAME), \
	CONST_NAME_ENTRY(COLORMODE_MONO6), \
	CONST_NAME_ENTRY(COLORMODE_COLOR), \
	CONST_NAME_ENTRY(COLORMODE_JP46), \
	CONST_NAME_ENTRY(COLORMODE_JP46DC), \
	CONST_NAME_ENTRY(COLORMODE_COLOR20), \
	CONST_NAME_ENTRY(COLORMODE_JP4), \
	CONST_NAME_ENTRY(COLORMODE_JP4DC), \
	CONST_NAME_ENTRY(COLORMODE_JP4DIFF), \
	CONST_NAME_ENTRY(COLORMODE_JP4HDR), \
	CONST_NAME_ENTRY(COLORMODE_JP4DIFF2), \
	CONST_NAME_ENTRY(COLORMODE_JP4HDR2), \
	CONST_NAME_ENTRY(COLORMODE_MONO4), \
	CONST_NAME_ENTRY(PARS_FRAMES), \
	CONST_NAME_ENTRY(PARS_FRAMES_MASK), \
	CONST_NAME_ENTRY(PASTPARS_SAVE_ENTRIES), \
	CONST_NAME_ENTRY(PASTPARS_SAVE_ENTRIES_MASK), \
	CONST_NAME_ENTRY(FRAMEPAIR_FORCE_NEW), \
	CONST_NAME_ENTRY(FRAMEPAIR_FORCE_PROC), \
	CONST_NAME_ENTRY(FRAMEPAIR_FORCE_NEWPROC), \
	CONST_NAME_ENTRY(FRAMEPAIR_JUST_THIS), \
	CONST_NAME_ENTRY(FRAMEPAR_GLOBALS), \
	CONST_NAME_ENTRY(FRAMEPAIR_FRAME_FUNC), \
	CONST_NAME_ENTRY(FRAMEPAIR_MASK_BYTES), \
	CONST_NAME_ENTRY(FRAMEPAIR_BYTE0), \
	CONST_NAME_ENTRY(FRAMEPAIR_BYTE1), \
	CONST_NAME_ENTRY(FRAMEPAIR_BYTE2), \
	CONST_NAME_ENTRY(FRAMEPAIR_BYTE3), \
	CONST_NAME_ENTRY(FRAMEPAIR_WORD0), \
	CONST_NAME_ENTRY(FRAMEPAIR_WORD1), \
	CONST_NAME_ENTRY(ERR_FRAMEPARS_TOOEARLY), \
	CONST_NAME_ENTRY(ERR_FRAMEPARS_TOOLATE), \
	CONST_NAME_ENTRY(ERR_FRAMEPARS_BADINDEX), \
	CONST_NAME_ENTRY(DAEMON_BIT_AUTOEXPOSURE), \
	CONST_NAME_ENTRY(DAEMON_BIT_STREAMER), \
	CONST_NAME_ENTRY(DAEMON_BIT_CCAMFTP), \
	CONST_NAME_ENTRY(DAEMON_BIT_CAMOGM), \
	CONST_NAME_ENTRY(DAEMON_BIT_AUTOCAMPARS), \
	CONST_NAME_ENTRY(ERR_PGM_TRYAGAINLATER), \
	CONST_NAME_ENTRY(FRAMEPARS_SETFRAME), \
	CONST_NAME_ENTRY(FRAMEPARS_SETFRAMEREL), \
	CONST_NAME_ENTRY(FRAMEPARS_SETLATENCY), \
	CONST_NAME_ENTRY(FRAMEPARS_SETFPGATIME), \
	CONST_NAME_ENTRY(FRAMEPARS_GETFPGATIME), \
	CONST_NAME_ENTRY(GAMMA_CACHE_NUMBER), \
	CONST_NAME_ENTRY(GAMMA_VALID_MASK), \
	CONST_NAME_ENTRY(GAMMA_VALID_REVERSE), \
	CONST_NAME_ENTRY(GAMMA_FPGA_MASK), \
	CONST_NAME_ENTRY(GAMMA_MODE_NOT_NICE), \
	CONST_NAME_ENTRY(GAMMA_MODE_NEED_REVERSE), \
	CONST_NAME_ENTRY(GAMMA_MODE_HARDWARE), \
	CONST_NAME_ENTRY(GAMMA_MODE_LOCK), \
	CONST_NAME_ENTRY(GAMMA_SCALE_SHIFT), \
	CONST_NAME_ENTRY(GAMMA_SCLALE_1), \
	CONST_NAME_ENTRY(HISTOGRAM_CACHE_NUMBER), \
	CONST_NAME_ENTRY(COLOR_Y_NUMBER), \
	CONST_NAME_ENTRY(FRAME_DEAFAULT_AHEAD), \
	CONST_NAME_ENTRY(AUTOCAMPARS_CMD_RESTORE), \
	CONST_NAME_ENTRY(AUTOCAMPARS_CMD_SAVE), \
	CONST_NAME_ENTRY(AUTOCAMPARS_CMD_DFLT), \
	CONST_NAME_ENTRY(AUTOCAMPARS_CMD_SAVEDFLT), \
	CONST_NAME_ENTRY(AUTOCAMPARS_CMD_INIT), \
	CONST_NAME_ENTRY(COLOR_RED), \
	CONST_NAME_ENTRY(COLOR_GREEN1), \
	CONST_NAME_ENTRY(COLOR_GREEN2), \
	CONST_NAME_ENTRY(COLOR_BLUE), \
	CONST_NAME_ENTRY(CSCALES_WIDTH), \
	CONST_NAME_ENTRY(CSCALES_CTL_BIT), \
	CONST_NAME_ENTRY(CSCALES_CTL_WIDTH), \
	CONST_NAME_ENTRY(CSCALES_CTL_NORMAL), \
	CONST_NAME_ENTRY(CSCALES_CTL_RECALC), \
	CONST_NAME_ENTRY(CSCALES_CTL_FOLLOW), \
	CONST_NAME_ENTRY(CSCALES_CTL_DISABLE), \
	CONST_NAME_ENTRY(HISTOGRAM_TABLE_OFFSET) \
};
/*
///NOTE page 0 is write protected, page 15 (0x0f) is "default" page
#define AUTOCAMPARS_CMD_RESTORE  1  /// restore specified groups of parameters from the specified page
#define AUTOCAMPARS_CMD_SAVE     2  /// save all current parameters to the specified group (page 0 is write-protected)
#define AUTOCAMPARS_CMD_DFLT     3  /// make selected page the default one (used at startup), page 0 OK 
#define AUTOCAMPARS_CMD_SAVEDFLT 4  /// save all current parameters to the specified group (page 0 is write-protected) and make it default (used at startup)
#define AUTOCAMPARS_CMD_INIT     5  /// reset sensor/sequencers, restore all parameters from the specified page

 */

#endif /* _ASM_CMOSCAM_H */
