
#ifndef FPGA_CLOCK_IOCTYPE
/* _IOC_TYPE, bits 8 to 15 in ioctl cmd */

  #define FPGA_CLOCK_IOCTYPE       131 // same as major
  #define FPGA_CLOCK_IOCTYPE_RD    135 // read clock frequency (now - just shadow) 


/* supported ioctl _IOC_NR's */
  #define FPGA_CLOCK_I2C_WRITEREG 0x1   /* write to an i2c register */
  #define FPGA_CLOCK_I2C_READREG  0x2   /* read from an i2c register */
#endif

#ifndef I2C_ARGVALUE

// #define I2C_WRITEARG(bus, slave, reg, value) (((bus) << 24) | ((slave) << 16) | ((reg) << 8) | (value))
// #define I2C_READARG(bus, slave, reg) (((bus) << 24) | ((slave) << 16) | ((reg) << 8))

 #define I2C_ARGBUS(arg) (((arg) >> 24)  & 0x1)
 #define I2C_ARGSLAVE(arg) (((arg) >> 16)  & 0xff)
 #define I2C_ARGREG(arg) (((arg) >> 8) & 0xff)
 #define I2C_ARGVALUE(arg) ((arg) & 0xff)
#endif

#ifndef ERR_I2C_SCL_ST0
 #define ERR_I2C_SCL_ST0       1
 #define ERR_I2C_SDA_ST0       2
 #define ERR_I2C_SCL_ST1       4
 #define ERR_I2C_SDA_ST1       8
 #define ERR_I2C_SCL_NOPULLUP 16
 #define ERR_I2C_SDA_NOPULLUP 32

/* i2c_diagnose called by i2c_start (?) could not find any problems. Try again start */
 #define    ERR_I2C_NOTDETECTED  64
 #define ERR_I2C_SHORT      128
 #define ERR_I2C_BSY         256
 #define ERR_I2C_NACK       512
#endif
