#============================================================= -*-Perl-*-
#
# Template::Factory
#
# DESCRIPTION
#
# AUTHORS
#   Andy Wardley <abw@kfs.org>
#   Lyle Brooks <brooks@deseret.com>
#
# COPYRIGHT
#   Copyright (C) 1996-2000 Andy Wardley.  All Rights Reserved.
#   Copyright (C) 1998-2000 Canon Research Centre Europe Ltd.
#
#   This module is free software; you can redistribute it and/or
#   modify it under the same terms as Perl itself.
#
#----------------------------------------------------------------------------
#
# $Id: Factory.pm,v 2.20 2001/06/29 13:09:00 abw Exp $
#
#============================================================================

package Template::Factory;

require 5.004;

use strict;
use vars qw( $VERSION $DEBUG);

$VERSION = sprintf("%d.%02d", q$Revision: 2.20 $ =~ /(\d+)\.(\d+)/);

#========================================================================
#                         -- PUBLIC METHODS --
#========================================================================

sub new {

   my $class = shift;

   if (ref($class)) {     # called as an object method
      my $self = $class;
      my $args = shift;
      $self->module->new($self->get_args($args));
   }
   else {                 # called as a class method
      my $module = shift;
      #my $self = bless { module => $module }, $class;
      my $self = bless \$module, $class;
      return $self;
   }
}

#------------------------------------------------------------------------

sub error { 'Factory Error!!! ' }

#------------------------------------------------------------------------

sub module {

   my $self = shift;

   $$self = shift if @_;
   $$self;
}

#------------------------------------------------------------------------

sub get_args {                    # return all but 1st element
   my @args = @{$_[1]};
   shift @args;
   @args;
}

#------------------------------------------------------------------------

sub DESTROY { }

#========================================================================

package Template::Factory::Plugin;

use base qw(Template::Factory);

#------------------------------------------------------------------------

sub get_args { @{$_[1]} }          # leave the context object on the arg list

#------------------------------------------------------------------------

sub DESTROY { }

1;

__END__


=head1 NAME

Template::Factory - Factory abstraction module

=head1 SYNOPSIS

    use Template::Factory;

    $factory = Template::Factory->new('Net::Netmask');

    @args = ('216.207.107.0/24');

    $plugin = $factory->new(\@args);

=head1 DESCRIPTION

The Template::Factory module provides an abstraction for factory 
objects.  Factory objects basically come in two flavors - Plugins and
non-Plugins.  Plugins are those modules that expect a $context variable
as the second argument in @_ (ie. $_[1]).  Non-Plugins are everything
else, such as standard perl object modules.

Template::Factory provides a way to get the right arguments passed
to the underlying object.

=head1 METHODS

=head2 new($module)  or new(\@args)

Used as a class method, this saves the name of the underlying module
and returns a Template::Factory object.

Used as an object method, it invokes the underlying module's new()
method as a class method returning an new object of the same
class as the underlying module.  Used as an object method, new()
expects an array reference which it will pass to the underlying
modules constructor.

It is expected that you would call new() first as a class method
and then later call it as an object method.

=head2 get_args(\@args)

get_args() accepts an array reference and returns array elements minus
the first element.  This corresponds to removing the $context argument
for Non-Plugin object modules.

For Plugin objects, get_args() can be subclassed to return all the
array elements.


=head1 AUTHOR

Lyle Brooks E<lt>brooks@deseret.com<gt>

L<http://www.deseret.com/|http://www.deseret.com/>


=head1 VERSION

2.20, distributed as part of the
Template Toolkit version 2.04, released on 29 June 2001.

=head1 COPYRIGHT

  Copyright (C) 1996-2001 Lyle Brooks.  All Rights Reserved.

This module is free software; you can redistribute it and/or
modify it under the same terms as Perl itself.

=head1 SEE ALSO

L<Template|Template>, L<Template::Plugin|Template::Plugin>, L<Template::Context|Template::Context>
