/*
 *      menu-plugin.c
 *
 *      Copyright 2008 Jelle de Jong <jelledejong@powercraft.nl>
 *
 *		based on tex-open-terminal-plugin.c
 *		Copyright (c) 2005 Benedikt Meurer <benny@xfce.org>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

 #ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <menuplugin/menu.h>

static GType type_list[1];

G_MODULE_EXPORT void
thunar_extension_initialize (ThunarxProviderPlugin *plugin)
{
  const gchar *mismatch;

  /* verify that the thunarx versions are compatible */
  mismatch = thunarx_check_version (THUNARX_MAJOR_VERSION, THUNARX_MINOR_VERSION, THUNARX_MICRO_VERSION);
  if (G_UNLIKELY (mismatch != NULL))
    {
      g_warning ("Version mismatch: %s", mismatch);
      return;
    }

  g_message ("Initializing menu extension");

  /* register the types provided by this plugin */
  foo_register_type (plugin);

  /* setup the plugin type list */
  type_list[0] = TYPE_FOO;
}

G_MODULE_EXPORT void
thunar_extension_shutdown (void)
{
  g_message ("Shutting down menu extension");
}

G_MODULE_EXPORT void
thunar_extension_list_types (const GType **types, gint *n_types)
{
  *types = type_list;
  *n_types = G_N_ELEMENTS (type_list);
}
