/*
 *      menu.c
 *
 *      Copyright 2008 Jelle de Jong <jelledejong@powercraft.nl>
 *
 * 		based on tex-open-terminal.c
 * 		Copyright (c) 2005 Benedikt Meurer <benny@xfce.org>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#ifdef HAVE_MEMORY_H
#include <memory.h>
#endif
#ifdef HAVE_STRING_H
#include <string.h>
#endif

#include <menuplugin/menu.h>

static void   foo_class_init         (FooClass *klass);
static void   foo_menu_provider_init (ThunarxMenuProviderIface *iface);
static void   foo_init               (Foo *open_terminal);
static GList *foo_get_file_actions   (ThunarxMenuProvider *provider, GtkWidget *window, GList *files);
//static GList *foo_get_folder_actions (ThunarxMenuProvider *provider, GtkWidget *window, ThunarxFileInfo *folder);
static void   foo_activated          (GtkAction *action, GtkWidget *window);
void hello();

struct _FooClass
{
  GObjectClass __parent__;
};

struct _Foo
{
  GObject __parent__;
};

THUNARX_DEFINE_TYPE_WITH_CODE (Foo, foo, G_TYPE_OBJECT, THUNARX_IMPLEMENT_INTERFACE (THUNARX_TYPE_MENU_PROVIDER, foo_menu_provider_init));

static void
foo_class_init (FooClass *klass)
{
  /* nothing to do here */
}

static void
foo_init (Foo *open_terminal)
{
  /* nothing to do here */
}

static void
foo_menu_provider_init (ThunarxMenuProviderIface *iface)
{
  iface->get_file_actions = foo_get_file_actions;
  //iface->get_folder_actions = foo_get_folder_actions;
}

static GList*
foo_get_file_actions (ThunarxMenuProvider *provider, GtkWidget *window, GList *files)
{
  GtkAction *action = NULL;
  gchar     *scheme;
  gchar     *path;
  gchar     *uri;
  GList		*actions = NULL;

  //g_message("TESTINGGGG!!!!");

  /* determine the uri scheme of the folder and check if we support it */
  scheme = thunarx_file_info_get_mime_type (files->data);
  if (G_LIKELY (strcmp (scheme, "text/html") == 0))
    {
      /* determine the local path to the folder */
      uri = thunarx_file_info_get_uri (files->data);
      path = g_filename_from_uri (uri, NULL, NULL);
      g_free (uri);

      /* check if we have a valid path here */
      if (G_LIKELY (path != NULL))
        {
			action = gtk_action_new ("FooFFF::start firefox", "Open in Firefox", "Start in Firefox", NULL);
			g_signal_connect (G_OBJECT (action), "activate", G_CALLBACK (foo_activated), window);
			g_object_set_data_full (G_OBJECT (action), "open-ff-hier", path, g_free);
          
          	actions = 	g_list_prepend( actions , action );
          	
          	GtkWidget* file_menu = gtk_menu_new ();
          	GtkWidget* open_item = gtk_menu_item_new_with_label ("Open");
          	gtk_menu_shell_append (GTK_MENU_SHELL (file_menu), open_item);
          	
          	action = gtk_action_new("blaat", "tekst", "tooltip", NULL);
          	//GtkWidget* file_item = NULL;
			//gtk_menu_item_set_submenu( GTK_MENU_ITEM (file_item), file_menu);
			//gtk_menu_attach_to_widget(GTK_MENU(file_menu),  window, NULL);
		    //gtk_container_add (GTK_CONTAINER (window), menu_bar);

            actions = 	g_list_prepend( actions , action ); 
          	
        }
    }
  g_free (scheme);

  //return (action != NULL) ? g_list_prepend (NULL, action) : NULL;
  return actions;
}

static void
foo_activated (GtkAction *action, GtkWidget *window)
{
  const gchar *path;
  GtkWidget   *dialog;
  GError      *error = NULL;
  gchar       *command;

  /* determine the folder path */
  path = g_object_get_data (G_OBJECT (action), "open-ff-hier");
  if (G_UNLIKELY (path == NULL))
    return;
  
  /* build up the command line for the terminal */
  command = g_strdup_printf ("firefox \"%s\"", path);

  /* try to run the terminal command */
  if (!gdk_spawn_command_line_on_screen (gtk_widget_get_screen (window), command, &error))
    {
      /* display an error dialog */
      dialog = gtk_message_dialog_new (GTK_WINDOW (window),
                                       GTK_DIALOG_DESTROY_WITH_PARENT,
                                       GTK_MESSAGE_ERROR,
                                       GTK_BUTTONS_CLOSE,
                                       "Gefaald om de webpagina te openen: %s.",
                                       path);
      gtk_message_dialog_format_secondary_text (GTK_MESSAGE_DIALOG (dialog), "%s.", error->message);
      gtk_dialog_run (GTK_DIALOG (dialog));
      gtk_widget_destroy (dialog);
      g_error_free (error);
    }

  /* cleanup */
  g_free (command);
}

void hello()
{
	g_message("hoi");
}
