/*
 *      menu.h
 *
 *      Copyright 2008 Jelle de Jong <jelledejong@powercraft.nl>
 *
 *		based on tex-open-terminal.h
 *		Copyright (c) 2005 Benedikt Meurer <benny@xfce.org>
 *
 *      This program is free software; you can redistribute it and/or modify
 *      it under the terms of the GNU General Public License as published by
 *      the Free Software Foundation; either version 2 of the License, or
 *      (at your option) any later version.
 *
 *      This program is distributed in the hope that it will be useful,
 *      but WITHOUT ANY WARRANTY; without even the implied warranty of
 *      MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *      GNU General Public License for more details.
 *
 *      You should have received a copy of the GNU General Public License
 *      along with this program; if not, write to the Free Software
 *      Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 *      MA 02110-1301, USA.
 */

#ifndef __FOO_H__
#define __FOO_H__

#include <thunarx/thunarx.h>

G_BEGIN_DECLS;

typedef struct _FooClass FooClass;
typedef struct _Foo      Foo;

#define TYPE_FOO            (foo_get_type ())
#define FOO(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FOO, Foo))
#define FOO_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FOO, FooClass))
#define IS_FOO(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FOO))
#define IS_FOO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FOO))
#define FOO_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FOO, FooClass))

GType foo_get_type      (void) G_GNUC_CONST G_GNUC_INTERNAL;
void  foo_register_type (ThunarxProviderPlugin *plugin) G_GNUC_INTERNAL;

G_END_DECLS;

#endif /* !__FOO_H__ */
