
generic module IntSensorsP(uint16_t period) {
  provides interface Init;
  uses {
    interface Timer<TMilli>;
    interface ReadStream<uint16_t>;
  }
}
implementation {
  uint16_t values[2];

  command error_t Init.init() {
    call Timer.startOneShot(period);
    return SUCCESS;
  }

  event void Timer.fired() {
    if (call ReadStream.postBuffer(values, sizeof(values)/sizeof(uint16_t))
          != SUCCESS ||
        call ReadStream.read(0) != SUCCESS)
      call Timer.startOneShot(period);
  }

  event void ReadStream.bufferDone(error_t result, uint16_t* data,
      uint16_t count) {
    if (result == SUCCESS && data == values &&
        count == sizeof(values)/sizeof(uint16_t)) {
      /* See wired Msp430Adc12Config to see ADC assignments */
      /* The data are in data[0], ... data[count - 1] */
    }
    call Timer.startOneShot(period);
  }

  event void ReadStream.readDone(error_t error, uint32_t actualPeriod) {}
}
