  command error_t Init.init()
  {
    call Msp430Adc12.configurePins(call Msp430Adc12Config.getSettings());
    atomic {
      state = 0;
      zeroX = zeroY = zeroZ = 0;
    }
    return SUCCESS;
  }

  async command error_t ReadNow.read()
  {
    if (!zeroX || state != STATE_IDLE ||
        call Resource.immediateRequest() != SUCCESS)
      return FAIL;
    memset(&result, 0, sizeof(result));
    if (call Msp430Adc12.startRepeat(call Msp430Adc12Config.getSettings(),
        SPORIAN_A3AC_JIFFIES) != SUCCESS)
      return FAIL;
    else {
      state = STATE_SAMPLE;
      call Alarm.start(SPORIAN_A3AC_WINDOW);
      return SUCCESS;
    }
  }

  async event void Alarm.fired()
  {
    state = STATE_ALARM;
  }

  async event bool Msp430Adc12.sequenceReady(uint16_t *data, uint8_t len)
  {
    if (state == STATE_SAMPLE) {
      int16_t tmp;
      uint16_t newMag;
      int16_t newX = data[0] - zeroX;
      int16_t newY = data[1] - zeroY;
      int16_t newZ = data[2] - zeroZ;

      /* Use hw mult to help create magnitude */
      tmp = newX >> 4;
      MPYS = tmp;
      OP2 = tmp;
      newMag = RESLO;
      tmp = newY >> 4;
      MPYS = tmp;
      OP2 = tmp;
      newMag += RESLO;
      tmp = newZ >> 4;
      MPYS = tmp;
      OP2 = tmp;
      newMag += RESLO;
      if (newMag > result.magnitude) {
        result.x = newX;
        result.y = newY;
        result.z = newZ;
        result.magnitude = newMag;
      }
      result.count++;
      return TRUE;
    } else if (state == STATE_CAL) {
      zeroX += (data[0] >> 4);
      zeroY += (data[1] >> 4);
      zeroZ += (data[2] >> 4);
      if (++result.count < (1 << 8))
        return TRUE;
      zeroX >>= 4;
      zeroY >>= 4;
      zeroZ >>= 4;
      post signalCalibrated();
      state = STATE_IDLE;
      return FALSE;
    } else if (state == STATE_ALARM) {
      call Msp430Adc12.cancel();
      call Resource.release();
      signal ReadNow.readDone(SUCCESS, result);
      state = STATE_IDLE;
      return TRUE; /* already stopped with cancel() */
    }
    return FALSE;
  }

  /* unused */
  async event bool Msp430Adc12.singleReady(uint16_t data) { return FALSE; }
}
