#include <Msp430Adc12.h>

module SporianA3aConfigP {
  provides interface Msp430Adc12Config;
}
implementation {

  static adc12memctl_t sequence[] = {
    { inch: INPUT_CHANNEL_A4, sref: REFERENCE_VREFplus_AVss },
    { inch: INPUT_CHANNEL_A3, sref: REFERENCE_VREFplus_AVss },
    { inch: INPUT_CHANNEL_A5, sref: REFERENCE_VREFplus_AVss }
  };

  static msp430adc12_channel_config_t config = {
    ref2_5v: REFVOLT_LEVEL_2_5,
    adc12ssel: SHT_SOURCE_ADC12OSC,
    adc12div: SHT_CLOCK_DIV_1,
    sht: SAMPLE_HOLD_64_CYCLES,
    sampcon_ssel: SAMPCON_SOURCE_SMCLK,
    sampcon_id: SAMPCON_CLOCK_DIV_1,
    count: sizeof(sequence)/sizeof(adc12memctl_t),
    channels: { sequence: sequence },
  };

  async command msp430adc12_channel_config_t *Msp430Adc12Config.getSettings()
  {
    return &config;
  }
}
