/**
 * Submit interface (sensor) layer for sporian shock sensor
 */

#include "Sample.h"

configuration ShockSensorC {
  uses interface SamplePut;
}
implementation {
  components MainC, ShockSensorP, SporianA3aC,
    new TimerMilliC();

  SamplePut = ShockSensorP;

  MainC.SoftwareInit -> ShockSensorP.Init;
  ShockSensorP.Timer -> TimerMilliC;
  ShockSensorP.CalNotify -> SporianA3aC;
  ShockSensorP.Notify -> SporianA3aC;
  ShockSensorP.A3aControl -> SporianA3aC.SplitControl;

  components new Shock3DMetaC("SporianA3a");
  ShockSensorP.SensorMeta -> Shock3DMetaC;

  components new SensorSampleC(SENSOR_TYPE_SHOCK3D_LEN);
  ShockSensorP.SensorSample -> SensorSampleC;

  components AppNoLedsC as AppLedsC;
  ShockSensorP.Leds -> AppLedsC;
  ShockSensorP.FlashLeds -> AppLedsC;
}
