#include "Sample.h"
#include "sporian_a3a.h"
#include "sensor_meta.h"

module ShockSensorP {
  provides interface Init;
  uses {
    interface SensorMeta;
    interface SensorSample;
    interface SamplePut;
    interface Timer<TMilli>;
    interface SplitControl as A3aControl;
    interface Notify<sporian_a3a_calibrate_t> as CalNotify;
    interface Notify<sporian_a3a_t>;
    interface Leds;
    interface FlashLeds;
  }
}
implementation {
  command error_t Init.init()
  {
    call Timer.startOneShot(1000);
    return SUCCESS;
  }

  event void Timer.fired()
  {
    if (call A3aControl.start() != SUCCESS)
      call Timer.startOneShot(1000);
  }

  event void A3aControl.startDone(error_t error)
  {
    if (error != SUCCESS)
      call Timer.startOneShot(1000);
  }

  event void CalNotify.notify(sporian_a3a_calibrate_t cal)
  {
    call SensorSample.setIds(call SensorMeta.getId(),
        SENSOR_TYPE_SHOCK3D_CAL_UNIT);
    call SensorSample.addUInt16(cal.x);
    call SensorSample.addUInt16(cal.y);
    call SensorSample.addUInt16(cal.z);
    call SamplePut.put(call SensorSample.ptr(), call SensorSample.size());
  }

  event void Notify.notify(sporian_a3a_t result)
  {
    call SensorSample.setIds(call SensorMeta.getId(),
        SENSOR_TYPE_SHOCK3D_SAMPLE_UNIT);
    call SensorSample.addInt16(result.x);
    call SensorSample.addInt16(result.y);
    call SensorSample.addInt16(result.z);
    call SensorSample.addUInt16(result.count);
    call SamplePut.put(call SensorSample.ptr(), call SensorSample.size());
  }

  event void A3aControl.stopDone(error_t error) {}
}
