/*
 * Copyright (c) 2007 Toilers Research Group - Colorado School of Mines
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of Toilers Research Group - Colorado School of 
 *   Mines  nor the names of its contributors may be used to endorse 
 *   or promote products derived from this software without specific
 *   prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL STANFORD
 * UNIVERSITY OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */
/**
 * Author: Chad Metcalf
 * Date: Oct 1, 2007
 *
 * A simple TOSSIM driver for the TestSerial application that utilizes 
 * TOSSIM Live extensions.
 *
 */

#include <stdio.h>
#include <tossim.h>
#include <SerialForwarder.h>
#include <Throttle.h>
#include <radio.h>
#include <math.h>
#include <unistd.h>

#define FIRST_MOTE_NUM 0
#define LAST_MOTE_NUM 1

int main() {
 Tossim* t = new Tossim(NULL);
 Radio* r = t->radio();
// t-> init();

 Throttle throttle(t, 10);
 SerialForwarder sf(9001);

 for (int i = FIRST_MOTE_NUM; i <= LAST_MOTE_NUM; i++) {
   Mote* m = t->getNode(i);
   m->bootAtTime(rand() % t->ticksPerSecond());

//    r->setNoise(i, -105.0, 1.0);
   for (int j = FIRST_MOTE_NUM; j <= LAST_MOTE_NUM; j++) {
       if (i != j) {
         r->add(i, j, -50.0);
       }
     }
     for (int j = 0; j < 500; j++) {
        m->addNoiseTraceReading((char)(drand48() * 20) - 90);
     }
     m->createNoiseModel();
//      r->add(i, j, -96.0 - (double)abs(i - j));
//      r->add(j, i, -96.0 - (double)abs(i - j));

 }


 t->addChannel("messages", stdout);
 t->addChannel("Serial", stdout);
// t->addChannel("TestSerialC", stdout);
// t->addChannel("fwe", stdout);
// t->addChannel("mhe", stdout);
// t->addChannel("de", stdout);
 t->addChannel("dt", stdout);
 t->addChannel("ag", stdout);
 t->addChannel("Atm128AlarmC", stdout);


sf.process();

 throttle.initialize();
//while(t->time() < 600 * t->ticksPerSecond()) {
while(t->time() < 1000 * t->ticksPerSecond()) {
   throttle.checkThrottle();
   sf.process();
   t->runNextEvent();
 }
}
