/*									tab:4
 * "Copyright (c) 2005 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation for any purpose, without fee, and without written
 * agreement is hereby granted, provided that the above copyright
 * notice, the following two paragraphs and the author appear in all
 * copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY
 * PARTY FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL
 * DAMAGES ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS
 * DOCUMENTATION, EVEN IF THE UNIVERSITY OF CALIFORNIA HAS BEEN
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 */

/**
 * Java-side application for testing serial port communication.
 * 
 *
 * @author Phil Levis <pal@cs.berkeley.edu>
 * @date August 12 2005
 */

// java TestTymoLoop -comm sf@localhost:9001

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.BufferedReader;

import net.tinyos.message.*;
import net.tinyos.packet.*;
import net.tinyos.util.*;

public class TestTymoLoop implements MessageListener {

  private MoteIF moteIF;
  private long sentAt;
  
  public TestTymoLoop(MoteIF moteIF) {
    this.moteIF = moteIF;
    this.moteIF.registerListener(new TestTymoLoopMsg(), this);
  }

  public void sendPackets() {
    int counter = 0;
    TestTymoLoopMsg payload = new TestTymoLoopMsg();
    
    try {

     InputStreamReader isrKB = new InputStreamReader(System.in);
     BufferedReader brKB = new BufferedReader(isrKB);

      while (true) {
        System.out.print("Please enter a number: ");
        String tmp = brKB.readLine();
        counter = Integer.parseInt(tmp);
	System.out.println("Sending packet " + counter);
	payload.set_counter(counter);
        sentAt = System.currentTimeMillis();
	moteIF.send(0, payload);
        
	//counter++;
	
//	try {Thread.sleep(80);}
	try {Thread.sleep(300);}   // YOU CAN CHANGE THE DELAY HERE !!!!!!
	catch (InterruptedException exception) {}
        
      }

    }
    catch (IOException exception) {
      System.err.println("Exception thrown when sending packets. Exiting.");
      System.err.println(exception);
    }
  }

  public void messageReceived(int to, Message message) {
    TestTymoLoopMsg msg = (TestTymoLoopMsg)message;
    System.out.println("after " + (System.currentTimeMillis()-sentAt) + "ms received number " + msg.get_counter());
  }
  
  private static void usage() {
    System.err.println("usage: TestSerial [-comm <source>]");
  }
  
  public static void main(String[] args) throws Exception {
    String source = null;
    if (args.length == 2) {
      if (!args[0].equals("-comm")) {
	usage();
	System.exit(1);
      }
      source = args[1];
    }
    else if (args.length != 0) {
      usage();
      System.exit(1);
    }
    
    PhoenixSource phoenix;
    
    if (source == null) {
      phoenix = BuildSource.makePhoenix(PrintStreamMessenger.err);
    }
    else {
      phoenix = BuildSource.makePhoenix(source, PrintStreamMessenger.err);
    }

    MoteIF mif = new MoteIF(phoenix);
    TestTymoLoop testTymoLoop = new TestTymoLoop(mif);
    testTymoLoop.sendPackets();
  }


}
