// $Id: TestTymoLoopC.nc,v 1.5 2007/02/08 01:00:25 scipio Exp $

/*									tab:4
 * "Copyright (c) 2000-2003 The Regents of the University  of California.  
 * All rights reserved.
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the author appear in all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * 
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Copyright (c) 2002-2003 Intel Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached INTEL-LICENSE     
 * file. If you do not find these files, copies can be found by writing to
 * Intel Research Berkeley, 2150 Shattuck Avenue, Suite 1300, Berkeley, CA, 
 * 94704.  Attention:  Intel License Inquiry.
 */

/**
 * The TinyOS 2.x base station that forwards packets between the UART
 * and radio.It replaces the GenericBase of TinyOS 1.0 and the
 * TOSBase of TinyOS 1.1.
 *
 * <p>On the serial link, TestTymoLoop sends and receives simple active
 * messages (not particular radio packets): on the radio link, it
 * sends radio active messages, whose format depends on the network
 * stack being used. TestTymoLoop will copy its compiled-in group ID to
 * messages moving from the serial link to the radio, and will filter
 * out incoming radio messages that do not contain that group ID.</p>
 *
 * <p>TestTymoLoop includes queues in both directions, with a guarantee
 * that once a message enters a queue, it will eventually leave on the
 * other interface. The queues allow the TestTymoLoop to handle load
 * spikes.</p>
 *
 * <p>TestTymoLoop acknowledges a message arriving over the serial link
 * only if that message was successfully enqueued for delivery to the
 * radio link.</p>
 *
 * <p>The LEDS are programmed to toggle as follows:</p>
 * <ul>
 * <li><b>RED Toggle:</b>: Message bridged from serial to radio</li>
 * <li><b>GREEN Toggle:</b> Message bridged from radio to serial</li>
 * <li><b>YELLOW/BLUE Toggle:</b> Dropped message due to queue overflow in either direction</li>
 * </ul>
 *
 * @author Phil Buonadonna
 * @author Gilman Tolle
 * @author David Gay
 * @author Philip Levis
 * @date August 10 2005
 */

#ifdef AG_USE_MULTIHOP

  //#define CC2420_DEF_RFPOWER 1
  #define MAX_TABLE_SIZE 10
  //#define DYMO_MONITORING

#endif

//#include "printf.h"

configuration TestTymoLoopC {
}

implementation {
  components MainC, TestTymoLoopP, LedsC;
  components new TimerMilliC();
#ifdef AG_USE_MULTIHOP
  components DymoNetworkC as Radio;
#else
  components ActiveMessageC as Radio;
#endif
  components SerialActiveMessageC as Serial;
  
  
  TestTymoLoopP.Boot -> MainC.Boot;

  TestTymoLoopP.RadioControl  -> Radio;
  TestTymoLoopP.SerialControl -> Serial;
  
  TestTymoLoopP.UartSend     -> Serial;
  TestTymoLoopP.UartReceive  -> Serial.Receive;
  TestTymoLoopP.UartPacket   -> Serial;
  TestTymoLoopP.UartAMPacket -> Serial;

#ifdef AG_USE_MULTIHOP
  TestTymoLoopP.RadioPacket    -> Radio;
  TestTymoLoopP.RadioAMPacket  -> Radio;
  TestTymoLoopP.RadioReceive   -> Radio.Receive[1];
  TestTymoLoopP.RadioIntercept -> Radio.Intercept[1];
  TestTymoLoopP.RadioSend      -> Radio.MHSend[1];
#else
  TestTymoLoopP.RadioSend     -> Radio;
  TestTymoLoopP.RadioReceive  -> Radio.Receive;
  TestTymoLoopP.RadioSnoop    -> Radio.Snoop;
  TestTymoLoopP.RadioPacket   -> Radio;
  TestTymoLoopP.RadioAMPacket -> Radio;
#endif

#ifdef DYMO_MONITORING
  TestTymoLoopP.DymoMonitor -> DymoNetworkC;
#endif

  TestTymoLoopP.Leds -> LedsC;
  TestTymoLoopP.Timer -> TimerMilliC;
}
