module BugP
{
  uses {
    interface Boot;
    interface SplitControl as RadioSplitControl;
    interface AMSend;
  }
}

implementation
{
  message_t lmsg;

  typedef nx_struct {
    nx_uint8_t error;
    nx_uint8_t state;
  } status_t;

  status_t status;

  task void t()
  {
    status_t *p = (status_t *)call AMSend.getPayload(&lmsg, sizeof(status_t));
    memcpy(p, &status, sizeof(status_t));
  }

  event void Boot.booted()
  {
    call RadioSplitControl.start();
  }

  event void RadioSplitControl.startDone(error_t error)
  {
    post t();
  }

  event void RadioSplitControl.stopDone(error_t error) { }
  event void AMSend.sendDone(message_t *msg, error_t error) { }
}
