// $Id: MSP430DAC.nc 582 2006-02-22 01:37:39Z polastre $
/*
 * Copyright (c) 2005 Moteiv Corporation
 * All rights reserved.
 *
 * This file is distributed under the terms in the attached MOTEIV-LICENSE     
 * file. If you do not find these files, copies can be found at
 * http://www.moteiv.com/MOTEIV-LICENSE.txt and by emailing info@moteiv.com.
 */
includes MSP430DAC12;

interface MSP430DAC {

  // intended process for single output
  // - bind, specifically ref volt
  // - enable
  // - wait for enableDone
  // - enableOutput
  // - set
  // - do whatever
  // - disable

  // intended process for multiple outputs
  // - bind, specifically ref volt
  //     load select bits ignored (reset later)
  // - enable
  // - wait for enableDone
  // - enableOutput
  // - setSequence / Repeat
  //     the DMA and TimerA are set for the user
  // - do whatever
  // - disable

  command result_t bind(dac12ref_t reference, 
			dac12res_t resolution, 
			dac12load_t loadselect, 
			dac12fsout_t fsout, 
			dac12amp_t amp, 
			dac12df_t dataformat,
			dac12group_t group); 

  // turn the dac on or off
  // includes a calibration step and turning refvolt on
  async command result_t enable();
  event void enableDone(result_t success);

  // turn the dac off
  // release dependence on refvolt
  async command result_t disable();
  event void disableDone(result_t success);

  async command result_t enableOutput();
  async command result_t disableOutput();
  
  // set the value, fails if sequence or repeat in progress
  async command result_t set(uint16_t dacunits);

}
