#include "ADCRead.h"

configuration ADCReadAppC {}

implementation {
	components MainC, ADCReadC, LedsC;
	components new TimerMilliC() as MyTimer;
	components new SensorMDA300CA() as Mda300;
	components SerialActiveMessageC;
	components new SerialAMSenderC(AM_ADC);

	ADCReadC.Boot -> MainC.Boot;
	ADCReadC.Timer0 -> MyTimer;
	ADCReadC.Leds -> LedsC.Leds;

	ADCReadC.Packet -> SerialAMSenderC;
	ADCReadC.AMPacket -> SerialAMSenderC;
	ADCReadC.AMSend -> SerialAMSenderC;
	ADCReadC.AMControl -> SerialActiveMessageC;

	ADCReadC.Sensor_0_Read -> Mda300.ADC_0;
	ADCReadC.Sensor_1_Read -> Mda300.ADC_1;
	ADCReadC.Sensor_2_Read -> Mda300.ADC_2;
	ADCReadC.Sensor_3_Read -> Mda300.ADC_3;
	ADCReadC.Sensor_4_Read -> Mda300.ADC_4;
	ADCReadC.Sensor_5_Read -> Mda300.ADC_5;
	ADCReadC.Sensor_6_Read -> Mda300.ADC_6;
	ADCReadC.Sensor_7_Read -> Mda300.ADC_7;

}
