#include "ADCRead.h"

module ADCReadC @safe() {

	uses {
		//////////////////////////////////////////
		// Interfacce per la lettura dei valori //
		//////////////////////////////////////////

		interface Read<uint16_t> as Sensor_0_Read;
		interface Read<uint16_t> as Sensor_1_Read;
		interface Read<uint16_t> as Sensor_2_Read;
		interface Read<uint16_t> as Sensor_3_Read;
		interface Read<uint16_t> as Sensor_4_Read;
		interface Read<uint16_t> as Sensor_5_Read;
		interface Read<uint16_t> as Sensor_6_Read;
		interface Read<uint16_t> as Sensor_7_Read;



		////////////////////////////////////////////////
		// Interfacce per la comunicazione dei valori //
		////////////////////////////////////////////////

		interface Packet;
		interface AMPacket;
		interface AMSend;
		interface SplitControl as AMControl;



		/////////////////////////////////////////
		// Altre interfacce: Boot, Leds, Timer //
		/////////////////////////////////////////

		interface Boot;
		interface Leds;
		interface Timer<TMilli> as Timer0;
	}
}
implementation {

	//////////////////////////////////////////
	// Variabili per la lettura dei sensori //
	//////////////////////////////////////////

	uint16_t val_sensor_0 = 0;
	uint16_t val_sensor_1 = 0;
	uint16_t val_sensor_2 = 0;
	uint16_t val_sensor_3 = 0;
	uint16_t val_sensor_4 = 0;
	uint16_t val_sensor_5 = 0;
	uint16_t val_sensor_6 = 0;
	uint16_t val_sensor_7 = 0;

	bool adc0Done = FALSE;
	bool adc1Done = FALSE;
	bool adc2Done = FALSE;
	bool adc3Done = FALSE;
	bool adc4Done = FALSE;
	bool adc5Done = FALSE;
	bool adc6Done = FALSE;
	bool adc7Done = FALSE;



	///////////////////////////////////////////////////////////
	// Variabile busy per la comunicazione (radio o seriale) //
	///////////////////////////////////////////////////////////

	bool busy = FALSE;



	/////////////////////////
	// Variabile pacchetto //
	/////////////////////////

	message_t pkt;



	///////////////////////////////////////
	// Dichiarazione Task readDoneTask() //
	//////////////////////////////////////

	task void readDoneTask();



	///////////////////////////////////////////////////////////////////////////
	// Evento di Boot: chiama AMControl.start() per avviare l'ActiveMessageC //
	///////////////////////////////////////////////////////////////////////////

	event void Boot.booted() {
		call AMControl.start();
	}



	////////////////////////////////////////////////////////////////////////
	// Eventi di AMControl: se AMControl è avviato allora chiama il timer //
	////////////////////////////////////////////////////////////////////////

	event void AMControl.startDone(error_t err) {

		if(err == SUCCESS) {
			if(call Leds.get() & LEDS_LED0) {
				call Leds.led0Off();
			}

			call Timer0.startPeriodic(TIMER_PERIOD_MILLI);

		} else {

			if(call Leds.get() & LEDS_LED0) {
				;
			} else {
				call Leds.led0On();
			}

			call AMControl.start();
		}
	}

	event void AMControl.stopDone(error_t err) {
		if(call Leds.get() & LEDS_LED0) {
			call Leds.led0Off();
		}
	}



	event void Timer0.fired() {
		if(busy == FALSE) {
			call Sensor_0_Read.read();
			call Sensor_1_Read.read();
			call Sensor_2_Read.read();
			call Sensor_3_Read.read();
			call Sensor_4_Read.read();
			call Sensor_5_Read.read();
			call Sensor_6_Read.read();
			call Sensor_7_Read.read();
			call Leds.led2Toggle();
		}
	}

	event void Sensor_0_Read.readDone(error_t err, uint16_t val) {
		///////////
		// DEBUG //
		///////////
		call Leds.led1Toggle();

		if(err == SUCCESS) {
			val_sensor_0 = val;
			adc0Done = TRUE;
			post readDoneTask();
		}
	}

	event void Sensor_1_Read.readDone(error_t err, uint16_t val) {
		if(err == SUCCESS) {
			val_sensor_1 = val;
			adc1Done = TRUE;
			post readDoneTask();
		}
	}

	event void Sensor_2_Read.readDone(error_t err, uint16_t val) {
		if(err == SUCCESS) {
			val_sensor_2 = val;
			adc2Done = TRUE;
			post readDoneTask();
		}
	}

	event void Sensor_3_Read.readDone(error_t err, uint16_t val) {
		if(err == SUCCESS) {
			val_sensor_3 = val;
			adc3Done = TRUE;
			post readDoneTask();
		}
	}

	event void Sensor_4_Read.readDone(error_t err, uint16_t val) {
		if(err == SUCCESS) {
			val_sensor_4 = val;
			adc4Done = TRUE;
			post readDoneTask();
		}
	}

	event void Sensor_5_Read.readDone(error_t err, uint16_t val) {
		if(err == SUCCESS) {
			val_sensor_5 = val;
			adc5Done = TRUE;
			post readDoneTask();
		}
	}

	event void Sensor_6_Read.readDone(error_t err, uint16_t val) {
		if(err == SUCCESS) {
			val_sensor_6 = val;
			adc6Done = TRUE;
			post readDoneTask();
		}
	}

	event void Sensor_7_Read.readDone(error_t err, uint16_t val) {
		if(err == SUCCESS) {
			val_sensor_7 = val;
			adc7Done = TRUE;
			post readDoneTask();
		}
	}



	event void AMSend.sendDone(message_t* msg, error_t error) {
		if (&pkt == msg) {
			busy = FALSE;
    		}
	}



	task void readDoneTask() {
		if(adc0Done && adc1Done && adc2Done && adc3Done && adc4Done && adc5Done && adc6Done && adc7Done && !busy) {

			ADCMsg* adcpkt = (ADCMsg*)(call Packet.getPayload(&pkt, sizeof(ADCMsg)));
			if(adcpkt == NULL) {
				return;
			}
			adcpkt->nodeid = TOS_NODE_ID;
			adcpkt->adcvalue0 = val_sensor_0;
			adcpkt->adcvalue1 = val_sensor_1;
			adcpkt->adcvalue2 = val_sensor_2;
			adcpkt->adcvalue3 = val_sensor_3;
			adcpkt->adcvalue4 = val_sensor_4;
			adcpkt->adcvalue5 = val_sensor_5;
			adcpkt->adcvalue6 = val_sensor_6;
			adcpkt->adcvalue7 = val_sensor_7;
			if (call AMSend.send(AM_BROADCAST_ADDR, &pkt, sizeof(ADCMsg)) == SUCCESS) {
				busy = TRUE;
			}

			adc0Done = FALSE;
			adc1Done = FALSE;
			adc2Done = FALSE;
			adc3Done = FALSE;
			adc4Done = FALSE;
			adc5Done = FALSE;
			adc6Done = FALSE;
			adc7Done = FALSE;
		}
	}
}
