


import static java.lang.System.out;
import java.io.IOException;
import java.util.ArrayList;
import java.io.FileOutputStream;
import java.io.PrintStream;
import net.tinyos.message.*;
import net.tinyos.util.*;

class AcousticRanger implements MessageListener{
	private MoteIF mif;
	private int recMsgNum=0;
	private FileOutputStream fileOutput;
	private PrintStream printToFile;
	public int counter, nodeID;
	
	public AcousticRanger()
	{
		mif = new MoteIF(PrintStreamMessenger.err);
		mif.registerListener(new DataMsg(),this);

	}
	public void messageReceived(int dest_addr,Message msg)
	{
		if(msg instanceof DataMsg)
		{
			DataMsg datamsg=(DataMsg)msg;
			nodeID = datamsg.get_nodeID();
			counter = datamsg.get_counter();
			recMsgNum++;
		}
	}
	
	public void Display(String testType)
	{
		try{
			int nodeCount = 0;
			if(recMsgNum == 0)
			{
			}
			else
			{
				out.println();
				out.printf("%-13s %-13s","NodeID","Counter(ms)");
				printToFile.printf("%-13s %-13s","NodeID","Counter(ms)");
				
				while(nodeCount!=recMsgNum)
				{
						out.printf("%-13d %-13d",nodeID, counter);	

						printToFile.printf("%-13d %-13d",nodeID, counter);	

					 
					nodeCount++;
				}// end while
			}// end else
		}// end try
		catch(IOException e){
			out.println("Cannot open the file");
		}
	}


	public static void main (String[] args)
	{
		
			AcousticRanger tester= new AcousticRanger();

			tester.Display(args[0]);
			System.exit(0);
		}
	}	
}
