 /*
 * @author Muneera Albabtain
 * @Organization King Abdulaziz City for Science and Technology
 */

#include <Timer.h>
#include "ToneDetector.h"

module ToneDetectorC {
	uses interface Boot;
	uses interface MicSetting;
	uses interface Leds;
	uses interface Resource as MicResource;
  	uses interface Timer<TMilli> as Timer0;
	uses interface Receive;
	uses interface SplitControl as AMControl;
	uses interface AMSend as DataSend;
	uses interface Packet as DataPacket;
}

implementation {

   uint16_t counterT = 0;


	event void Boot.booted() {
		call AMControl.start();

		call MicResource.request();
	}

	event void AMControl.startDone(error_t err) {
    		if (err != SUCCESS) {
			call AMControl.start();
		}
	}

	event void AMControl.stopDone(error_t err) {  }

	event message_t* Receive.receive(message_t* msg, void* payload, uint8_t len){

		call Timer0.startPeriodic(10);
		return msg;
  	}
	

	 event void Timer0.fired() {
    		counterT++;
    		call Leds.led0On();
	}

	async event error_t MicSetting.toneDetected() {
  	message_t msg;
	datamsg_t* packet;
		// Stuff to do when tone detected
		 call Timer0.stop();
		call Leds.led1Toggle();
		packet = (datamsg_t*)(call DataPacket.getPayload(&msg, sizeof(datamsg_t)));
    		packet-> nodeID = TOS_NODE_ID;
		packet-> counter = counterT;
		call DataSend.send(0, &msg, sizeof(datamsg_t));
		

		return SUCCESS;
	}
	event void DataSend.sendDone(message_t* bufPtr, error_t error)
	{
	if (error == SUCCESS)
	call Leds.led2Toggle();
  	}

	event void MicResource.granted() {
		call MicSetting.enable();
	}
}

