/**
 * 
 * @author Chanaka Lloyd <chanakalloyd@gmail.com>
 * @brief Access SPI for Radio on Meshbean platform (Zigbit Amp)
 * @brief Reason for app: Radio power On and OFF presented issues. Now resolved.
 *
 */

#include "Timer.h"
#include "RadioOnOff.h"

module RadioOnOffC @safe()
{
  	uses{
    		interface Boot;
    		interface SplitControl as RadioControl;
    		interface AMSend;
    		interface Timer<TMilli>;
    		interface Leds;
  	}
}
implementation
{
	message_t sendBuf;
	mypacket_t pkt;
	
	bool radioFlag;

	event void Boot.booted(){
		pkt.interval = DEFAULT_INTERVAL;
    	pkt.id = TOS_NODE_ID;
    	// some arbitrary two readings just to fill the the packet
    	pkt.readings[0] = 1000;
    	pkt.readings[1] = 2000;
		call Timer.startPeriodic(2000);
		radioFlag = FALSE;
	}

	event void Timer.fired() {
		if(radioFlag)
		{
			call RadioControl.stop();
		}
		else
		{
			call RadioControl.start();
		}
	}

	event void RadioControl.startDone(error_t error) {
		call Leds.led0Toggle();
		memmove(call AMSend.getPayload(&sendBuf, sizeof(pkt)), &pkt, sizeof pkt);
		call AMSend.send(AM_BROADCAST_ADDR, &sendBuf, sizeof pkt);
		radioFlag = TRUE;
	}

	event void RadioControl.stopDone(error_t error) {
    	call Leds.led1Toggle();
    	radioFlag = FALSE;
	}

	event void AMSend.sendDone(message_t *msg, error_t error){
		if(error == SUCCESS)
		  call Leds.led2Toggle();
	}
}