#include <Timer.h>
#include "Temperature.h"


 module TemperatureP{
    uses
    {
        interface Boot;
        interface Leds;
        interface Read<uint16_t>;
        interface Timer<TMilli>;
        
   
        interface Packet;                    
        interface AMPacket;                  
        interface AMSend;                    
        interface Receive; 	          
        interface SplitControl as AMControl; 
	

    }
    	
}
implementation
{ 
  
  message_t pkt;
  bool busy = FALSE;

 
  BlinkToRadioMsg local;



  
  void report_problem() { call Leds.led0Toggle(); }


  event void Boot.booted() {
    call AMControl.start();  
  }



   event void AMControl.startDone(error_t err) {
    if (err == SUCCESS) {
      call Timer.startPeriodic(250);
    }
    else {
      call AMControl.start();
    }
  }


  event void AMControl.stopDone(error_t err) {
  }

  

 

  event void Timer.fired() {
	if (call Read.read() != SUCCESS)
      		report_problem();
  }

 


  event void Read.readDone(error_t result, uint16_t data) {
  
            
    if (result != SUCCESS)
      {
	data = 0xffff;
	report_problem();
      }

  
    if (!busy) {
      BlinkToRadioMsg* btrpkt = 
	(BlinkToRadioMsg*)(call Packet.getPayload(&pkt, sizeof(BlinkToRadioMsg)));
      if (btrpkt == NULL) {
	return;
      }
      btrpkt->nodeid = TOS_NODE_ID;
      btrpkt->data = data;



      if (call AMSend.send(AM_BROADCAST_ADDR, 
          &pkt, sizeof(BlinkToRadioMsg)) == SUCCESS) {
        busy = TRUE;
       }
    }


  }

  
    event void AMSend.sendDone(message_t* msg, error_t err) {
      if (&pkt == msg) {
        busy = FALSE;
      }
  
    }

   event message_t* Receive.receive(message_t* msg, void* payload, uint8_t len){
    if (len == sizeof(BlinkToRadioMsg)) {
      BlinkToRadioMsg* btrpkt = (BlinkToRadioMsg*)payload;
      
    }
    return msg;
  }
    
 

}
