#include <iostream>
#include <cxxtools/http/server.h>
#include <cxxtools/xmlrpc/service.h>
#include <cxxtools/eventloop.h>

class CalcService : public cxxtools::xmlrpc::Service
{
  public:
    CalcService()
    {
      registerMethod("add", *this, &CalcService::add);
      registerMethod("sub", *this, &CalcService::sub);
      registerMethod("mul", *this, &CalcService::mul);
      registerMethod("div", *this, &CalcService::div);
    }

    double add(double a, double b);
    double sub(double a, double b);
    double mul(double a, double b);
    double div(double a, double b);
};

double CalcService::add(double a, double b)
{
  return a + b;
}

double CalcService::sub(double a, double b)
{
  return a - b;
}

double CalcService::mul(double a, double b)
{
  return a * b;
}

double CalcService::div(double a, double b)
{
  if (b == 0)
    throw std::runtime_error("division by zero");
  return a / b;
}

int main(int argc, char* argv[])
{
  try
  {
    cxxtools::EventLoop eventLoop;
    cxxtools::http::Server server(eventLoop, "", 7001);
    CalcService calcService;
    server.addService("/calc", calcService);
    eventLoop.run();
  }
  catch (const std::exception& e)
  {
    std::cerr << e.what() << std::endl;
  }
}


