/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.startup;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import org.apache.catalina.loader.StandardClassLoader;

public final class Bootstrap {
    private static int debug = 0;

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if ("-debug".equals(stringArray[n])) {
                debug = 1;
            }
            ++n;
        }
        ClassLoader classLoader = Bootstrap.createCommonLoader();
        ClassLoader classLoader2 = Bootstrap.createCatalinaLoader(classLoader);
        ClassLoader classLoader3 = Bootstrap.createSharedLoader(classLoader);
        try {
            Object object;
            if (System.getSecurityManager() != null) {
                object = "org.apache.catalina.";
                classLoader2.loadClass((String)object + "core.ApplicationContext$PrivilegedGetRequestDispatcher");
                classLoader2.loadClass((String)object + "core.ApplicationDispatcher$PrivilegedForward");
                classLoader2.loadClass((String)object + "core.ApplicationDispatcher$PrivilegedInclude");
                classLoader2.loadClass((String)object + "session.StandardSession");
                classLoader2.loadClass((String)object + "util.Enumerator");
                classLoader2.loadClass("javax.servlet.http.Cookie");
            }
            if (debug >= 1) {
                Bootstrap.log("Loading startup class");
            }
            object = classLoader2.loadClass("org.apache.catalina.startup.Catalina");
            Object t = ((Class)object).newInstance();
            if (debug >= 1) {
                Bootstrap.log("Setting startup class properties");
            }
            String string = "setParentClassLoader";
            Class[] classArray = new Class[]{Class.forName("java.lang.ClassLoader")};
            Object[] objectArray = new Object[]{classLoader3};
            Method method = t.getClass().getMethod(string, classArray);
            method.invoke(t, objectArray);
            if (debug >= 1) {
                Bootstrap.log("Calling startup class process() method");
            }
            string = "process";
            classArray = new Class[]{stringArray.getClass()};
            objectArray = new Object[]{stringArray};
            method = t.getClass().getMethod(string, classArray);
            method.invoke(t, objectArray);
        }
        catch (Exception exception) {
            System.out.println("Exception during startup processing");
            exception.printStackTrace(System.out);
            System.exit(2);
        }
        System.exit(0);
    }

    private static ClassLoader createCommonLoader() {
        Object object;
        Object object2;
        Object object3;
        if (debug >= 1) {
            Bootstrap.log("Creating COMMON class loader");
        }
        boolean bl = true;
        try {
            Class.forName("javax.naming.Context");
            bl = false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File file = new File(System.getProperty("catalina.home"), "common/lib");
        if (!(file.exists() && file.canRead() && file.isDirectory())) {
            System.out.println("Directory " + file.getAbsolutePath() + " does not exist");
            System.exit(1);
        }
        String[] stringArray = file.list();
        int n = 0;
        while (n < stringArray.length) {
            object3 = stringArray[n].toLowerCase();
            if (((String)object3).endsWith(".jar") && ((String)object3).indexOf("bootstrap.jar") == -1 && (bl || ((String)object3).indexOf("jndi.jar") == -1)) {
                object2 = new File(file, stringArray[n]);
                try {
                    object = new URL("file", null, ((File)object2).getCanonicalPath());
                    if (debug >= 1) {
                        Bootstrap.log("  Adding " + ((URL)object).toString());
                    }
                    arrayList.add(((URL)object).toString());
                }
                catch (IOException iOException) {
                    System.out.println("Cannot create URL for " + stringArray[n]);
                    iOException.printStackTrace(System.out);
                    System.exit(1);
                }
            }
            ++n;
        }
        object3 = new File(System.getProperty("catalina.home"), "common/classes");
        if (((File)object3).exists() && ((File)object3).canRead() && ((File)object3).isDirectory()) {
            try {
                object2 = new URL("file", null, ((File)object3).getCanonicalPath() + "/");
                if (debug >= 1) {
                    Bootstrap.log("  Adding " + ((URL)object2).toString());
                }
                arrayList.add(((URL)object2).toString());
            }
            catch (IOException iOException) {
                System.out.println("Cannot create URL for " + ((File)object3).getAbsolutePath());
                iOException.printStackTrace(System.out);
                System.exit(1);
            }
        }
        object2 = arrayList.toArray(new String[arrayList.size()]);
        object = new StandardClassLoader((String[])object2);
        return object;
    }

    private static ClassLoader createCatalinaLoader(ClassLoader classLoader) {
        Object object;
        File file;
        if (debug >= 1) {
            Bootstrap.log("Creating CATALINA class loader");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File file2 = new File(System.getProperty("catalina.home"), "server/lib");
        if (!(file2.exists() && file2.canRead() && file2.isDirectory())) {
            System.out.println("Directory " + file2.getAbsolutePath() + " does not exist");
            System.exit(1);
        }
        String[] stringArray = file2.list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].toLowerCase().endsWith(".jar")) {
                file = new File(file2, stringArray[n]);
                try {
                    object = new URL("file", null, file.getCanonicalPath());
                    if (debug >= 1) {
                        Bootstrap.log("  Adding " + ((URL)object).toString());
                    }
                    arrayList.add(((URL)object).toString());
                }
                catch (IOException iOException) {
                    System.out.println("Cannot create URL for " + stringArray[n]);
                    iOException.printStackTrace(System.out);
                    System.exit(1);
                }
            }
            ++n;
        }
        file = new File(System.getProperty("catalina.home"), "server/classes");
        if (file.exists() && file.canRead() && file.isDirectory()) {
            try {
                object = new URL("file", null, file.getCanonicalPath() + "/");
                if (debug >= 1) {
                    Bootstrap.log("  Adding " + ((URL)object).toString());
                }
                arrayList.add(((URL)object).toString());
            }
            catch (IOException iOException) {
                System.out.println("Cannot create URL for " + file.getAbsolutePath());
                iOException.printStackTrace(System.out);
                System.exit(1);
            }
        }
        object = arrayList.toArray(new String[arrayList.size()]);
        StandardClassLoader standardClassLoader = new StandardClassLoader((String[])object, classLoader);
        return standardClassLoader;
    }

    private static ClassLoader createSharedLoader(ClassLoader classLoader) {
        Object object;
        File file;
        if (debug >= 1) {
            Bootstrap.log("Creating SHARED class loader");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        File file2 = new File(System.getProperty("catalina.home"), "lib");
        if (!(file2.exists() && file2.canRead() && file2.isDirectory())) {
            System.out.println("Directory " + file2.getAbsolutePath() + " does not exist");
            System.exit(1);
        }
        String[] stringArray = file2.list();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n].toLowerCase().endsWith(".jar")) {
                file = new File(file2, stringArray[n]);
                try {
                    object = new URL("file", null, file.getCanonicalPath());
                    if (debug >= 1) {
                        Bootstrap.log("  Adding " + ((URL)object).toString());
                    }
                    arrayList.add(((URL)object).toString());
                }
                catch (IOException iOException) {
                    System.out.println("Cannot create URL for " + stringArray[n]);
                    iOException.printStackTrace(System.out);
                    System.exit(1);
                }
            }
            ++n;
        }
        file = new File(System.getProperty("catalina.home"), "classes");
        if (file.exists() && file.canRead() && file.isDirectory()) {
            try {
                object = new URL("file", null, file.getCanonicalPath() + "/");
                if (debug >= 1) {
                    Bootstrap.log("  Adding " + ((URL)object).toString());
                }
                arrayList.add(((URL)object).toString());
            }
            catch (IOException iOException) {
                System.out.println("Cannot create URL for " + file.getAbsolutePath());
                iOException.printStackTrace(System.out);
                System.exit(1);
            }
        }
        object = arrayList.toArray(new String[arrayList.size()]);
        StandardClassLoader standardClassLoader = new StandardClassLoader((String[])object, classLoader);
        return standardClassLoader;
    }

    private static void log(String string) {
        System.out.print("Bootstrap: ");
        System.out.println(string);
    }

    static {
        try {
            System.loadLibrary("DLS");
            System.err.println("Load library 'DLS' success");
        }
        catch (Throwable throwable) {
            System.err.println("Load library 'DLS' fail(" + throwable.getMessage() + ")");
        }
    }
}

