#!/usr/bin/env python
#    Created by Eugenio Cutolo  <me@eugesoftware.com>
#
#    This program can be distributed under the terms of the GNU GPL.
#    See the file COPYING.
#

#QtTracker Relase 0.1

import sys,os,dbus,re
from kdecore import KApplication, KCmdLineArgs, KURL,KIconTheme,KIcon
from kio import KMimeType, KServiceTypeProfile
from mainform import *

class TrackerClient:

	def __init__(self):
		bus = dbus.SessionBus()
		obj = bus.get_object('org.freedesktop.Tracker','/org/freedesktop/tracker')
		#self.tracker = dbus.Interface(obj, 'org.freedesktop.Tracker')
		self.keywords_iface = dbus.Interface(obj, 'org.freedesktop.Tracker.Keywords')
		self.search_iface = dbus.Interface(obj, 'org.freedesktop.Tracker.Search')
		self.files_iface = dbus.Interface(obj, 'org.freedesktop.Tracker.Files')
		
		#self.version = self.tracker.GetVersion()

		#Self service eheheh
		#self.services = self.tracker.GetServices(True)
		self.services = ['Files','Development Files','Documents','Images','Music','Text Files','Videos']
		self.query_id = 0

	def search(self,mode,service,input):
		self.fatalerr = 0
		if mode == 0:
			self.filelist = self.search_iface.Text(	1,service,input,0,-1)
			self.filelist = map(lambda x: str(x),self.filelist)
		elif mode == 1: 
			self.filelist = self.keywords_iface.Search(-1,service,[input,] ,-1,-1)
			self.filelist = map(lambda x: str(x),self.filelist)
			
		if len(self.filelist) == 0:
			self.on_tracker_error("Nothing found with "+input)

#Thank you Mikkel
	def text_snippet(self, text, result, service='Files'):
		snippet = self.search_iface.GetSnippet(service, result, text)
		snippet = snippet.replace('<!--', '&lt;!--').strip()
		return snippet

	def on_tracker_error(self, e):
		print "Error:"+e
		self.fatalerr = 1

class TrackerGui(MainForm,TrackerClient):
	
	def __init__(self):
		MainForm.__init__(self)
		TrackerClient.__init__(self)
		self.mip = 6#Max item for page

	def _refresh_page(self):
		self.result_list.clear()
		
		if self.pagen > 0:
			self.prevbtn.setEnabled(1)
		elif self.pagen == 0:
			self.prevbtn.setEnabled(0)
		if len(self.filelist) > self.mip and self.pagen < len(self.filelist) / self.mip:
			self.nextbtn.setEnabled(1)
		else:
			self.nextbtn.setEnabled(0)

		self.pagen_display.setText("Results "+str((self.mip*self.pagen)+1)+" - "+str((self.mip*self.pagen)+self.mip)+" of about "+str(len(self.filelist)))
		results = range((self.mip*self.pagen)+self.mip-1,(self.mip*self.pagen)-1,-1)
		self._show_result(results)

	def _show_result(self,result):
		self.result_list.setSorting(-1)
		for f in result:
			if f < len(self.filelist):
				file = self.filelist[f]
				service = self.files_iface.GetServiceType(file)
				item = RichListViewItem(self.result_list,None)
				item.setMultiLinesEnabled(1)
				if len(os.path.dirname(file)) > 40:
					dirname = os.path.dirname(file)[0:40]+"..."
				else:
					dirname = os.path.dirname(file)
				item.setText(0,os.path.basename(file)+"\n"+dirname+"\n"+service)
				#self.mime_icon = QPixmap(self._get_iconc(service))
				item.setPixmap(0,self._get_iconc(file))
				item.setText(1,self.text_snippet(self.input,file))

	def _get_iconc(self,path):
		mobj = KMimeType.findByPath(path)
		return mobj.pixmap(KURL(""),KIcon .Desktop,48)
	
	def on_tracker_error(self, e):
		self.result_list.clear()
		self.pagen_display.setText(e)
		self.fatalerr = 1

	def exec_file(self):
		item = self.result_list.currentItem()
		npos = (item.itemPos() / item.totalHeight()) + (self.pagen * self.mip)
		mime = KMimeType.findByPath(self.filelist[npos]).name()
		offer = KServiceTypeProfile.preferredService(mime, "Application")
		print re.sub('%.','',str(offer.exec_ ())),str(self.filelist[npos])
		#os.spawnlp(os.P_WAIT, 'gedit', 'gedit',)
		
#----------------Qt Events----------------------------
	
	def findbtn_clicked(self):
		self.input = str(self.searchinp.text())
		service = self.services[self.services_combo.currentItem()]
		self.search(self.mode_combo.currentItem(),service,self.input)
		self.prevbtn.setEnabled(0)
		self.nextbtn.setEnabled(0)
		self.pagen = 0
		if self.fatalerr == 0: self._refresh_page()

	def nextbtn_clicked(self):
		self.result_list.clear()
		self.pagen = self.pagen + 1
		self._refresh_page()

	def prevbtn_clicked(self):
		self.result_list.clear()
		self.pagen = self.pagen - 1
		self._refresh_page()

	def result_list_doubleClicked(self,item):
		self.self.exec_file()

	def result_list_contextMenuRequested(self,item):
		if item != self.result_list:
			contextMenu = QPopupMenu(self)
			contextMenu.insertItem( "&Open with Konqueror", self.exec_file, Qt.CTRL+Qt.Key_O )
			contextMenu.insertItem( "&Open with...", self.exec_file, Qt.CTRL+Qt.Key_S )
			contextMenu.exec_loop( QCursor.pos() )

if __name__ == "__main__":
	KCmdLineArgs.init(sys.argv, "qttrackergui", "qtgui", "0.1")
	app = KApplication()
	gui = TrackerGui()
	gui.show()
	app.setMainWidget(gui)
	app.exec_loop()