package org.apache.maven.changelog;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Maven" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Maven", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

/**
 * A set of information about revisions of a file as returned by CVS's log
 * command
 * @todo remove previous revision along with parser changes
 * @author <a href="mailto:dion@multitask.com.au">dIon Gillard</a>
 * @version $Id: ChangeLogFile.java,v 1.9 2002/04/21 11:14:22 dion Exp $
 */
public class ChangeLogFile
{
    /** the name of the file relative to the project directory. */
    private String name;
    /** the latest revision of the file. */
    private String revision;

    /**
     * Constructor for the ChangeLogFile object without all details available
     * @param name file name
     */
    public ChangeLogFile(String name)
    {
        setName(name);
    }
    
    /**
     * Constructor for the ChangeLogFile object
     *
     * @param name file name
     * @param rev latest revision of the file
     */
    public ChangeLogFile(String name, String rev)
    {
        setName(name);
        setRevision(rev);
    }

    /**
     * Gets the name attribute of the ChangeLogFile object.
     * @return the file name
     */
    public String getName()
    {
        return name;
    }

    /**
     * Gets the revision attribute of the ChangeLogFile object.
     * @return the latest revision of the file
     */
    public String getRevision()
    {
        return revision;
    }

    /**
     * Setter for property name.
     * @param name New value of property name.
     */
    public void setName(String name)
    {
        this.name = name;
    }
    
    /**
     * Setter for property revision.
     * @param revision New value of property revision.
     */
    public void setRevision(String revision)
    {
        this.revision = revision;
    }

    /**
     * Provide a version of the object as a string for debugging purposes
     * @return a {@link String} made up of the properties of the object
     */
    public String toString() 
    {
        StringBuffer buffer = new StringBuffer(getName());
        if (getRevision() != null)
        {
            buffer.append(", ").append(getRevision());
        }
        return buffer.toString();
    }
    
} // end of ChangeLogFile

