package org.apache.maven.changelog;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Maven" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Maven", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

import java.io.InputStream;
import java.io.IOException;
import java.util.Collection;

/**
 * Instance of <code>ChangeLogParser</code> are intended to parse an {@link
 * java.io.InputStream} created by a {@link ChangeLogGenerator} into individual
 * {@link ChangeLogEntry} objects.
 *
 * @author Glenn McAllister
 * @version $Id$
 */
public interface ChangeLogParser
{
    /**
     * Initialize the ChangeLogParser instance with the controlling {@link
     * ChangeLog} instance.  Any configuration required for the parser should
     * be obtained from the <code>changeLog</code>.  This method is guaranteed
     * to be called before {@link #parse}.
     *
     * @param changeLog the controlling ChangeLog instance
     */
    void init( ChangeLog changeLog );

    /**
     * Returns a {@link java.util.Collection} of ChangeLogEntry objects, parsed
     * from the {@link java.io.InputStream}.  This method is guaranteed to be
     * called after {@link #init} and before {@link #cleanup}.  However, it is
     * up to a {@link ChangeLogGenerator} instance to call this method, so no
     * guarantee can be made this this method will be called.
     *
     * @param in the input stream to parse
     * @returns a Collection of ChangeLogEntry objects
     * @throws IOException if there is an error while parsing the input stream
     */
    Collection parse( InputStream in ) throws IOException;

    /**
     * Provides the opportunity for the parser to do any required cleanup.
     * This method is guaranteed to be called after the {@link #init} (and
     * presumably the {@link #parse}) method.
     */
    void cleanup();
}
