package org.apache.maven.changelog;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Maven" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Maven", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

/**
 * Test cases for {@link ChangeLogFile}
 * @author dIon Gillard
 * @version $Id: ChangeLogFileTest.java,v 1.5 2002/04/21 11:14:22 dion Exp $
 */
public class ChangeLogFileTest extends TestCase {

    /** the {@link ChangeLogFile} used for testing */
    private ChangeLogFile instance;
    
    /**
     * Create a test with the given name
     * @param testName the name of the test
     */
    public ChangeLogFileTest(String testName) {
        super(testName);
    }
    
    /**
     * Run the test using the {@link TestRunner}
     * @param args command line provided arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    /**
     * Create a test suite for this class
     * @return a {@link TestSuite} for all tests in this class
     */
    public static Test suite() {
        return new TestSuite(ChangeLogFileTest.class);
    }

    /**
     * Initialize per test data
     */
    public void setUp() throws Exception
    {
        instance = new ChangeLogFile("maven:dummy", "maven:rev");
    }

    /**
     * Test of getName method
     */
    public void testGetName() {
        assertEquals("Name not being retrieved correctly", "maven:dummy", 
            instance.getName()); 
    }
    
    /**
     * Test of getRevision method
     */
    public void testGetRevision() {
        assertEquals("Revision not being retrieved correctly", "maven:rev", 
            instance.getRevision()); 
    }
    
    /** 
     * Test of setName method
     */
    public void testSetName() {
        instance.setName("maven:dummy:name");
        assertEquals("Name not set correctly", "maven:dummy:name", 
            instance.getName());
    }
    
    /**
     * Test of setRevision method
     */
    public void testSetRevision() {
        instance.setRevision("maven:rev:test");
        assertEquals("Revision not set correctly", "maven:rev:test", 
            instance.getRevision());
    }
    
    /** 
     * Test of toString method
     */
    public void testToString() {
        String value = instance.toString();
        assertTrue("Name not found in string", 
            value.indexOf(instance.getName()) != -1);
        assertTrue("Revision not found in string",
            value.indexOf(instance.getRevision()) != -1);
    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {    
}
