package org.apache.maven.cvslib;

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2002 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *    "Apache Maven" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    "Apache Maven", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

import org.apache.maven.changelog.ChangeLogEntry;

/**
 * Test cases for {@link ChangeLogParser}
 * @author dion
 * @version $Id: ChangeLogParserTest.java,v 1.2 2002/04/21 11:05:14 dion Exp $
 */
public class CvsChangeLogParserTest extends TestCase {
    
    /** the {@link CvsChangeLogParser} used for testing */
    private CvsChangeLogParser instance;
    /** */
    private String testFile;
    
    /**
     * Create a test with the given name
     * @param testName the name of the test
     */
    public CvsChangeLogParserTest(String testName) {
        super(testName);
    }

    /**
     * Run the test using the {@link TestRunner}
     * @param args command line provided arguments
     */
    public static void main(String[] args) {
        TestRunner.run(suite());
    }
    
    /**
     * Create a test suite for this class
     * @return a {@link TestSuite} for all tests in this class
     */
    public static Test suite() {
        return new TestSuite(CvsChangeLogParserTest.class);
    }

    /**
     * Initialize per test data
     */
    public void setUp() throws Exception
    {
        String baseDir = System.getProperty("basedir");
        assertNotNull("The system property basedir was not defined.", baseDir);
        String fs = System.getProperty("file.separator");
        assertNotNull("The system property file.separator was not defined.", 
            fs);
        testFile = baseDir + fs + "src/test-cvslib/cvslog.txt";
        instance = new CvsChangeLogParser();
    }

    /** 
     * Test of parse method
     */
    public void testParse() throws Exception {
        FileInputStream fis = new FileInputStream(testFile);
        Collection entries = instance.parse(fis);
        assertEquals("Wrong number of entries returned", 3, entries.size());
        ChangeLogEntry entry = null;
        int countPrevRevision = 0;
        int countRevOnly = 0;
        for (Iterator i = entries.iterator(); i.hasNext();) 
        {
            entry = (ChangeLogEntry)i.next();
            assertTrue("ChangeLogEntry erroneously picked up",
                entry.toString().indexOf("ChangeLogEntry.java") == -1);
        }

    }
    
    // Add test methods here, they have to start with 'test' name.
    // for example:
    // public void testHello() {}
    
    
}
