import cherrypy
import turbogears
from turbogears import controllers, expose, error_handler, validate

from turbogears.widgets import *
from turbogears.validators import *





# A custom widget in case the available ones don't fit your needs
# or you want to reuse...
class YesNoField(RadioButtonList):
    validator = StringBoolean(if_empty=False)
    def __init__(self, *args, **kw):
        options = [(True,"Yes"), (False,"No")]
        super(YesNoField, self).__init__(options=options, *args, **kw)




# Fields for our user info fieldset
class UserInfoFields(WidgetsList):
    group = SingleSelectField(
        options = list(enumerate(["Admin", "Editor", "Member", "Anonymous"])),
        default = 3 ,
        label = "Group",
    )
    email = TextField(validator=Email(not_empty=True))
    address = TextArea(validator=String(not_empty=True))
    postal_code = TextField(validator=PostalCode(not_empty=True))
    birth_date = CalendarDatePicker()
    phone = TextField(validator=PhoneNumber(not_empty=True), help_text="'555-555-5555'")
    web_page = TextField(field_class="url", attrs=dict(length=50), validator=URL())
    is_polite = YesNoField(default=False, label="Is polite?")



# The form fields
class UserRegisterFields(WidgetsList):
    username = TextField(validator = String(not_empty=True), default="jvanasco")
    password = PasswordField(validator=NotEmpty())
    password_c = PasswordField(validator=NotEmpty())
    user_info = FieldSet(fields=UserInfoFields())
    

    
# Your form
class UserRegisterForm(TableForm):
    fields = UserRegisterFields() 
    validator = Schema(
        chained_validators = [FieldsMatch("password", "password_c")]
    )
    submit_text = "New user"
    #template = ....
        
    






# The controller, this should be in another module, but that's your choice
class Root(controllers.RootController):

    # the form will submit to 'save'
    form = UserRegisterForm(action="save")



    
    @expose(template="sampleform.templates.welcome")
    def index(self):
        # return a dict with the form instance to the template
        # so you can display it there. If you want to prepopulate the form
        # or override some field's options do it here...
        options = {}
        value = {}
        return dict(
            form = self.form,
            value = value,
            options = options,
        )




    # Decorate with validate to... validate
    @validate(form=form)
    # If validation errors ocurr, branch to 'index' to redisplay
    # the form with nice error messages and previous values.
    @error_handler(index)
    # Expose the method
    @expose()
    def save(self, **data):
        # I'm sure you will find something more useful to do with
        # the data... Notice how it's all coerce into nice python objects.
        # All dirty work is done in the validators so your controller code
        # only needs to do the *real* work.
        return repr(data)
