from turbogears.widgets import *
from turbogears.validators import *

class YesNoField(RadioButtonList):
    validator = StringBoolean(if_empty=False)
    def __init__(self, *args, **kw):
        options = [(True,"Yes"), (False,"No")]
        super(YesNoField, self).__init__(options=options, *args, **kw)

class UserRegisterFields(WidgetsList):
    username = TextField(validator = String(not_empty=True), default="jvanasco")
    password = PasswordField(validator=NotEmpty())
    password_c = PasswordField(validator=NotEmpty())
    
class UserInfoFields(WidgetsList):
    group = SingleSelectField(
        options = list(enumerate(["Admin", "Editor", "Member", "Anonymous"])),
        default = 3 ,
        label = "Group",
    )
    email = TextField(validator=Email(not_empty=True))
    address = TextArea(validator=String(not_empty=True))
    postal_code = TextField(validator=PostalCode(not_empty=True))
    birth_date = CalendarDatePicker()
    phone = TextField(validator=PhoneNumber(not_empty=True), help_text="'555-555-5555'")
    web_page = TextField(field_class="url", attrs=dict(length=50), validator=URL())
    is_polite = YesNoField(default=False, label="Is polite?")

    
class UserRegisterForm(TableForm):
    fields = UserRegisterFields() + [FieldSet(fields=UserInfoFields())]
    validator = Schema(
        chained_validators = [FieldsMatch("password", "password_c")]
    )
    submit_text = "New user"
        
    
