package org.apache.tuscany.tools.java2wsdl.generate;

import org.w3c.dom.Element;

public class TuscanyJava2WSDL implements WSDLGenListener
{

	public void WSDLGenPhaseCompleted(WSDLGenEvent event)
	{
		//System.out.println(" Here we completed - " + WSDLGenListener.phaseAsString[event.getGenerationPhase()]);
		if ( event.getGenerationPhase() == WSDLGenListener.WSDL_MODEL_CREATION )
		{
			modifyModel((Java2WSDLGeneratorIfc)event.getSource());
			
		}
	}

	private void removeSchemaNamespaces(Java2WSDLGeneratorIfc generator )
	{
		WSDLModel model = generator.getWSDLModel();
		
		Element schemaElement = model.getSchemaElement();
		schemaElement.removeAttribute("xmlns:ns1");
        schemaElement.removeAttribute("xmlns:ns2");
        schemaElement.removeAttribute("xmlns:ns0");
        schemaElement.removeAttribute("ns1:elementFormDefault");
        schemaElement.removeAttribute("ns0:attributeFormDefault");
        schemaElement.removeAttribute("ns2:targetNamespace");
        
        schemaElement.setAttribute( "elementFormDefault", "qualified");
        schemaElement.setAttribute( "attributeFormDefault", "qualified");

	}
	
	private void modifyModel( Java2WSDLGeneratorIfc generator )
	{
		removeSchemaNamespaces(generator);
		
	}

	public void WSDLGenPhaseStarted(WSDLGenEvent event)
	{
	
	}

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		// TODO Auto-generated method stub
		
		TuscanyJava2WSDL java2WSDL = new TuscanyJava2WSDL();
		Java2WSDLGeneratorIfc generator = new Java2WSDLGeneratorImpl();
		generator.addWSDLGenListener(java2WSDL);
		generator.generateWSDL(args);
	}

}
