/**
 * 
 */
package org.apache.tuscany.tools.java2wsdl.generate;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;

import org.apache.axis2.wsdl.Java2WSDL;
import org.apache.axis2.wsdl.builder.Java2WOMBuilder;
import org.apache.axis2.wsdl.builder.Java2WSDLBuilder;
import org.apache.axis2.wsdl.builder.SchemaGenerator;
import org.apache.axis2.wsdl.codegen.CodeGenerationException;
import org.apache.axis2.wsdl.i18n.CodegenMessages;
import org.apache.axis2.wsdl.util.CommandLineOption;
import org.apache.axis2.wsdl.util.CommandLineOptionParser;
import org.apache.axis2.wsdl.util.Java2WSDLOptionsValidator;
import org.apache.axis2.wsdl.util.CommandLineOptionConstants.Java2WSDLConstants;
import org.apache.axis2.wsdl.writer.WOMWriter;
import org.apache.axis2.wsdl.writer.WOMWriterFactory;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.wsdl.WSDLDescription;
import org.apache.wsdl.impl.WSDLDescriptionImpl;

/**
 * @author administrator
 * 
 */
public class Java2WSDLGeneratorImpl extends Java2WSDLBuilder implements Java2WSDLGeneratorIfc
{
	public static final String HTTP = "http://";
	public static final String WSDL_FILENAME_SUFFIX = ".wsdl";
	public static final String DEFAULT_PREFIX = "wsdl";
	
	private List<WSDLGenListener> genPhaseListeners = new Vector<WSDLGenListener>();
	private Map<String, CommandLineOption> commandLineOptions = null;
	
	private String sourceClassName = null;
	private OutputStream outputStream = null;
	private ClassLoader classLoader;
	private WSDLDescription wsdlDescription = null;
	private WSDLModel wsdlModel = null;

	public Java2WSDLGeneratorImpl()
	{
		super(null,null,null);
	}

	private void multicastGenPhaseCompletionEvent(int genPhase)
	{
		WSDLGenEvent event = new WSDLGenEvent(this, genPhase);
		Iterator iterator = genPhaseListeners.iterator();
		while ( iterator.hasNext() )
		{
			((WSDLGenListener)iterator.next()).WSDLGenPhaseCompleted(event);
		}
	}
	
	protected CommandLineOption loadOption(String shortOption,
			String longOption, Map options)
	{
		// short option gets precedence
		CommandLineOption option = null;
		if ( longOption != null )
		{
			option = (CommandLineOption) options.get(longOption);
			if ( option != null )
			{
				return option;
			}
		}
		if ( shortOption != null )
		{
			option = (CommandLineOption) options.get(shortOption);
		}

		return option;
	}
	
	private String getSimpleClassName(String qualifiedName)
	{
		int index = qualifiedName.lastIndexOf(".");
		if ( index > 0 )
		{
			return qualifiedName.substring(index + 1, qualifiedName.length());
		}
		return qualifiedName;
	}
	
	private void initialize() throws Exception
	{
		CommandLineOption option = null;

		// get the input classname
		option = loadOption(Java2WSDLConstants.CLASSNAME_OPTION,
				Java2WSDLConstants.CLASSNAME_OPTION_LONG, commandLineOptions);
		sourceClassName = option == null ? null : option.getOptionValue();
		if ( sourceClassName == null || sourceClassName.equals("") )
		{
			throw new CodeGenerationException(CodegenMessages
					.getMessage("java2wsdl.classIsMust"));
		}

		// create the output stream from the input name of the folder and file
		// for the WSDL output
		option = loadOption(Java2WSDLConstants.OUTPUT_LOCATION_OPTION,
				Java2WSDLConstants.OUTPUT_LOCATION_OPTION_LONG,
				commandLineOptions);
		String outputFolderName = option == null ? System
				.getProperty("user.dir") : option.getOptionValue();

		option = loadOption(Java2WSDLConstants.OUTPUT_FILENAME_OPTION,
				Java2WSDLConstants.OUTPUT_FILENAME_OPTION_LONG,
				commandLineOptions);
		String outputFileName = option == null ? null : option.getOptionValue();

		resolveOutputStream(outputFolderName, outputFileName);

		// create and initialize an instance of the Java2WSDL Builder
		resolveClassLoader4InputClasspath();

		option = loadOption(Java2WSDLConstants.SCHEMA_TARGET_NAMESPACE_OPTION,
				Java2WSDLConstants.SCHEMA_TARGET_NAMESPACE_OPTION_LONG,
				commandLineOptions);
		setSchemaTargetNamespace(option == null
				? null
				: option.getOptionValue());

		option = loadOption(
				Java2WSDLConstants.SCHEMA_TARGET_NAMESPACE_PREFIX_OPTION,
				Java2WSDLConstants.SCHEMA_TARGET_NAMESPACE_PREFIX_OPTION_LONG,
				commandLineOptions);
		setSchemaTargetNamespacePrefix(option == null
				? null
				: option.getOptionValue());

		option = loadOption(Java2WSDLConstants.TARGET_NAMESPACE_OPTION,
				Java2WSDLConstants.TARGET_NAMESPACE_OPTION_LONG,
				commandLineOptions);
		setTargetNamespace(option == null ? null : option
				.getOptionValue());

		option = loadOption(Java2WSDLConstants.TARGET_NAMESPACE_PREFIX_OPTION,
				Java2WSDLConstants.TARGET_NAMESPACE_PREFIX_OPTION_LONG,
				commandLineOptions);
		setTargetNamespacePrefix(option == null
				? null
				: option.getOptionValue());

		option = loadOption(Java2WSDLConstants.SERVICE_NAME_OPTION,
							Java2WSDLConstants.SERVICE_NAME_OPTION_LONG, 
							commandLineOptions);
		setServiceName(option == null? getSimpleClassName(sourceClassName): option.getOptionValue());
	}

	protected void resolveOutputStream(String outputFolderName,
			String outputFileName) throws Exception
	{
		File outputFolder = new File(outputFolderName);
		if ( !outputFolder.exists() )
		{
			outputFolder.mkdir();
		}
		else if ( !outputFolder.isDirectory() )
		{
			throw new CodeGenerationException(CodegenMessages.getMessage(
					"java2wsdl.notAFolder", outputFolderName));
		}

		// derive a file name from the class name if the filename is not
		// specified
		if ( outputFileName == null )
		{
			outputFileName = getSimpleClassName(sourceClassName)
					+ WSDL_FILENAME_SUFFIX;
		}

		// first create a file in the given location
		File outputFile = new File(outputFolder, outputFileName);
		FileOutputStream out;
		try
		{
			if ( !outputFile.exists() )
			{
				outputFile.createNewFile();
			}
			outputStream = new FileOutputStream(outputFile);
		}
		catch ( IOException e )
		{
			throw new CodeGenerationException(e);
		}
		
	}
	
	private void  resolveClassLoader4InputClasspath() throws Exception
	{
		//if the class path is present, create a URL class loader with those
        //class path entries present. if not just take the  TCCL
        CommandLineOption option = loadOption(Java2WSDLConstants.CLASSPATH_OPTION,
                Java2WSDLConstants.CLASSPATH_OPTION_LONG,commandLineOptions);
        
		if ( option != null )
		{
			ArrayList optionValues = option.getOptionValues();
			URL[] urls = new URL[optionValues.size()];
			String[] classPathEntries = (String[]) optionValues.toArray(new String[optionValues.size()]);

			try
			{
				for ( int i = 0; i < classPathEntries.length; i++ )
				{
					String classPathEntry = classPathEntries[i];
					// this should be a file(or a URL)
					if ( classPathEntry.startsWith(HTTP) )
					{
						urls[i] = new URL(classPathEntry);
					}
					else
					{
						urls[i] = new File(classPathEntry).toURL();
					}
				}
			}
			catch ( MalformedURLException e )
			{
				throw new CodeGenerationException(e);
			}

			classLoader = new URLClassLoader(urls, Thread.currentThread()
					.getContextClassLoader());

		}
		else
		{
			classLoader = Thread.currentThread().getContextClassLoader();
		}
		
	}
	
	protected boolean validateInputArgs(String[] args)
	{
		boolean isValid = true;
		CommandLineOptionParser parser = new CommandLineOptionParser(args);
		if ( parser.getAllOptions().size() == 0 )
		{
			Java2WSDL.printUsage();
			isValid = false;
		}
		else if ( parser.getInvalidOptions(new Java2WSDLOptionsValidator())
				.size() > 0 )
		{
			Java2WSDL.printUsage();
			isValid = false;
		}

		if ( isValid )
		{
			commandLineOptions = parser.getAllOptions();
		}

		return isValid;
	}
	
	public boolean generateWSDLModel() throws Exception
	{
		boolean isComplete = true;
		initialize();
		
		SchemaGenerator schemaGenerator = new SchemaGenerator(getClassLoader(), 
													getSourceClassName(),
													getSchemaTargetNamespace(), 
													getSchemaTargetNamespacePrefix());
		
        XmlSchema schema = schemaGenerator.generateSchema();
                                
        wsdlDescription = new Java2WOMBuilder(
        		schemaGenerator.getTypeTable(),
        		schemaGenerator.getMethods(), 
                schema,
                getServiceName(),
                getTargetNamespace(),
                getTargetNamespacePrefix()).generateWOM();
        
        return isComplete;
	}
	
	public boolean serializeWSDLModel() throws Exception
	{
		boolean isComplete = true;
		
		WOMWriter womWriter = WOMWriterFactory.createWriter(org.apache.wsdl.WSDLConstants.WSDL_1_1);
        womWriter.setdefaultWSDLPrefix(DEFAULT_PREFIX);
        
        womWriter.writeWOM(wsdlDescription, getOutputStream());
        
        return isComplete;
	}
	
	
	/*
	 * (non-Javadoc)
	 * 
	 * @see tuscany.tools.Java2WSDLGeneratorIfc#generateWSDL(java.lang.String[])
	 */
	public void generateWSDL(String[] args)
	{
		try
		{
			if ( validateInputArgs(args) )
			{
				// multicast event for input args validation complete
				multicastGenPhaseCompletionEvent(WSDLGenListener.INPUT_ARGS_VALIDATION);
				if ( generateWSDLModel() )
				{
					wsdlModel = new WSDLModel((WSDLDescriptionImpl)wsdlDescription);
					//multicast event for generation of wsdl model
					multicastGenPhaseCompletionEvent(WSDLGenListener.WSDL_MODEL_CREATION);
					if ( serializeWSDLModel() )
					{
						//multicast event for writing of the WSDL Model to supplied output stream
						multicastGenPhaseCompletionEvent(WSDLGenListener.WSDL_MODEL_WRITING);
					}
				}
				
			}
		}
		catch ( Exception e )
		{
			e.printStackTrace();
		}

		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see tuscany.tools.Java2WSDLGeneratorIfc#addWSDLGenListener(tuscany.tools.WSDLGenListener)
	 */
	public void addWSDLGenListener(WSDLGenListener l)
	{
		genPhaseListeners.add(l);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see tuscany.tools.Java2WSDLGeneratorIfc#removeWSDLGenListener(tuscany.tools.WSDLGenListener)
	 */
	public void removeWSDLGenListener(WSDLGenListener l)
	{
		genPhaseListeners.remove(l);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see tuscany.tools.Java2WSDLGeneratorIfc#getCommandLineOptions()
	 */
	public Map getCommandLineOptions()
	{
		return commandLineOptions;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see tuscany.tools.Java2WSDLGeneratorIfc#setCommandLineOptoins(java.util.Map)
	 */
	public void setCommandLineOptoins(Map cmdLineOpts)
	{
		commandLineOptions = cmdLineOpts;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see tuscany.tools.Java2WSDLGeneratorIfc#getWSDLDescription()
	 */
	public WSDLModel getWSDLModel()
	{
		return wsdlModel;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see tuscany.tools.Java2WSDLGeneratorIfc#getOutputStream()
	 */
	public OutputStream getOutputStream()
	{
		// TODO Auto-generated method stub
		return outputStream;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see tuscany.tools.Java2WSDLGeneratorIfc#setOutputStream(java.io.OutputStream)
	 */
	public void setOutputStream(OutputStream outStream)
	{
		outputStream = outStream;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args)
	{
		// TODO Auto-generated method stub
		Java2WSDLGeneratorImpl generator = new Java2WSDLGeneratorImpl();
		generator.generateWSDL(args);

	}

	public void generateWSDL(Map commandLineOptions)
	{
		// TODO Auto-generated method stub
		
	}

	public String getSourceClassName()
	{
		return sourceClassName;
	}

	public void setSourceClassName(String sourceClassName)
	{
		this.sourceClassName = sourceClassName;
	}

	public ClassLoader getClassLoader()
	{
		return classLoader;
	}

	public void setClassLoader(ClassLoader classLoader)
	{
		this.classLoader = classLoader;
	}

}
