#
# Scripts using this template are sourced when run on a particular platform from
# both SymformNode.sh and SymformUpdater.sh
#
# Items that are required are defined with dummy values. These MUST be changed
# and supported by all platforms.
#
# This script should rely on the following layout, leveraging the assumption
# that the SYM_PATH variable is set and correct.
#
# "${SYMPATH}/SymformNode.sh"
#     contains the main driver script for interacting with any part of the
#     Symform service
#
# "${SYMPATH}/bin"
#     contains the Symform Node .NET executables and associated assemblies
#
# "${SYMPATH}/scripts"
#     contains all supporting scripts for managing interaction with the system
#
# "${SYMPATH}/scripts/system_utils"
#     contains all platform-specific knowlege for managing interaction with the
#     system (all scripts are expected to be sourced and not executed

################################################################################
# Provide a product name, version, and upgrade extension here. This is used by
# all clients to override the less precise system information when logging and
# reporting online.
#
export SYMFORM_OS_VERSION_STRING="product and version"

# Provide a platform label. This is used when determining what platform is to be
# queried for new versions. This MUST exactly match one of the platforms listed
# in build/PublishDownloads.py.
#
export SYMFORM_PLATFORM=unknown

# Provide an upgrde package extension. This is used when asking for new Symform
# software and what extension is used when new software is downloaded and passed
# on to the install_update function.
#
export SYMFORM_UPGRADE_EXT=foo

################################################################################
# This script has the OPTIONAL opportunity to set other important locations (or
# utilize these as values to reference):
#
# WORKDIR
#     a path where all configuration and status files should be stored
#
# LOGSPATH
#     a path where all logs are located (this value is "hard-coded" in our .NET
#     assemblies, so setting this variable currently has no effect on those
#     applications)
#
# LOCKPATH
#     a path where run-time lock files should be placed
#
# SYSTEM_LD_PRELOAD
#     if set, this will be passed on as LD_PRELOAD when running mono (useful to
#     force loading of our own libsqlite)
#
# WEBTASK
#     a SymformNode.sh action to request cron to run once a day--may be set to
#     nothing for no task to be set up
#
# SYNCTASK
#     a SymformNode.sh action to request cron to run once a day--may be set to
#     nothing for no task to be set up
#
# CONTRIBTASK
#     a SymformNode.sh action to request cron to run once a day--may be set to
#     nothing for no task to be set up

################################################################################
# This script has the OPTIONAL opportunity to provide one or more of the
# following hooks, overriding the original functionality.
#
# start_servce()
#     a function to start a specific service passed as the first argument
#     (replaces normal "start" logic in SymformNode.sh)
#
# stop_service()
#     a function to stop a specific service passed as the first argument
#     (replaces normal "stop" logic in SymformNode.sh)
#
# list_root_directories()
#     a function to provide the list of directories initially shown to the user
#     during configuration (when choosing sync and contrib folder locations)

################################################################################
# This script MUST provide the logic necessary to attempt upgrading of an
# existing installation. The first argument passed is the full path name of the
# update package.
#
# The function is expected to return zero for success. Any other value will
# indicate a failure.
#
install_update()
{
    echo "Provide logic to install the downloaded update package: $1." 1>&2
    return 1
}
