adjust_firewall()
{
    local name action proto port cfg cfg_fn old_cfg opts new_opts

    name="$1"
    action="$2"
    proto="$3"
    port="$4"

    cfg="--port=${port}:${proto}"
    cfg_fn="/var/lib/symform/lokkit_${name}_${proto}_${port}.cfg"
    opts="$(grep '^-' /etc/sysconfig/system-config-firewall)"
    new_opts="$opts"

    # always try to remove the old port and then conditionally re-add one
    if [ -f "$cfg_fn" ]; then
        old_cfg="$(cat "$cfg_fn")"
        if [ -n "$old_cfg" ]; then
            new_opts="$(echo "$opts" | grep -vFe "${old_cfg}")"
        fi
    fi

    if [ "$action" = 'remove' -o -z "$port" -o -z "$opts" ]; then
        cfg=''
    else
        new_opts="${new_opts} ${cfg}"
    fi

    if [ -n "$new_opts" -a "$opts" != "$new_opts" ]; then
        # only bother updating if there is no cfg or if the port has changed
        lokkit -f $new_opts
    fi

    if [ -z "$cfg" ]; then
        rm -f "$cfg_fn"
    else
        echo "$cfg" >"$cfg_fn"
    fi
}
