if [ -d /etc/init -a -f /sbin/initctl ]; then
    . "/opt/symform/scripts/platform/upstart.sh"
elif [ -d /etc/systemd -a -f /bin/systemctl ]; then
    . "/opt/symform/scripts/platform/systemd.sh"
else
    . "/opt/symform/scripts/platform/systemv.sh"
fi

if [ -f /usr/sbin/ufw ]; then
    . "/opt/symform/scripts/platform/ufw.sh"
elif [ -f /usr/sbin/lokkit ]; then
    # Also known/used as system-config-firewall.
    . "/opt/symform/scripts/platform/lokkit.sh"
else
    # Support other firewall wrappers here...or maybe even iptables directly.
    :
fi

#
# Package Life cycle (all optional)
#

# Called on install and update
# Must be idempotent
post_install()
{
    local libcryptopath

    grep -q symform /etc/group || groupadd --system symform

    if ! grep -q symform /etc/passwd; then
        # our scripts auto-create this directory...but this will complain
        # about its ownership
        rm -rf "/var/lib/symform"
        useradd --system --home "/var/lib/symform" --shell /bin/sh --gid symform --no-user-group symform
        mkdir -p "/var/lib/symform/tmp"
    fi

    install -m 644 "/opt/symform/scripts/platform/symform.desktop" /usr/share/applications
    install_init_scripts

    if [ -d /etc/ufw/applications.d ]; then
        # Drop an application entry for the web service.
        # This can be allowed by the admin, if desired.
        cat <<EOF >"/etc/ufw/applications.d/SymformWeb"
[SymformWeb]
title=Web configuration service for the Symform
description=Symform is a revolutionary cloud storage, backup, and sync service providing free or affordable online storage.
ports=$(get_webui_port)/tcp
EOF
    fi

    # Clean up old /opt/Symform (for 3.9)
    rm -rf /opt/Symform

    if ! ldconfig -p | grep -q "libcrypto.so$" > /dev/null; then
        if ldconfig -p | grep -q "libcrypto.so.10$" > /dev/null; then
            # create a symbolic link to libcrypto.so.10 since our binaries expect libcrypto.so
            libcryptopath=`ldconfig -p | grep "libcrypto.so.10$" | awk '{print $4}'`
            (cd "${SYMPATH}/lib"; rm -fr libcrypto.so*; ln -s $libcryptopath libcrypto.so)
        elif ldconfig -p | grep -q "libcrypto.so.1.0" > /dev/null; then
            # create a symbolic link to libcrypto.so.1.0 since our binaries expect libcrypto.so
            libcryptopath=`ldconfig -p | grep "libcrypto.so.1.0" | awk '{print $4}'`
            (cd "${SYMPATH}/lib"; rm -fr libcrypto.so*; ln -s $libcryptopath libcrypto.so)
        else
            echo "WARN: libcrypto.so not found. Performance will be degarded." 1>&2
        fi
    fi

    if [ "netgear" = "$(symform_platform_string)" ]; then
        systemctl stop fvapp-symform.service
        systemctl start fvapp-symform.service
    fi
}

# Called on uninstall and purge
# It is expected that the Symform install directory is removed by partner packaging system
post_uninstall()
{
    :
}

# Called on a purge uninstall only
post_purge()
{
    :
}

#
# Values & Actions
#
symform_os_version_string()
{
	local model version dist rel kern

	if [ "$(symform_platform_string)" = "seagate" ]; then
		#BUGBUG: need to get the seagate firmware version
		echo "Seagate"
	elif [ "$(symform_platform_string)" = "netgear" ]; then
		model=$(readyinfo SystemInfo | sed -ne '/<\/Model>/ { s/<[^>]*>\(.*\)<\/Model>/\1/; p }' | sed -e 's/^ *//' -e 's/ *$//')
		version=$(readyinfo SystemInfo | sed -ne '/<\/Firmware_Version>/ { s/<[^>]*>\(.*\)<\/Firmware_Version>/\1/; p }' | sed -e 's/^ *//' -e 's/ *$//')
		echo "Netgear $model $version"
    elif which lsb_release >/dev/null 2>&1; then
        dist="$(lsb_release -i | awk '{print $3}')"
        rel="$(lsb_release -r | awk '{print $2}')"
        kern="$(uname -s -r)"
        echo "${dist} ${rel} ${kern}"
    elif [ -e /etc/system-release ]; then
        dist="$(sed 's/^\([^ ]*\) release \([^ ]*\).*$/\1 \2/' /etc/system-release)"
        kern="$(uname -s -r)"
        echo "${dist} ${kern}"
    elif [ -e /etc/release ]; then
        echo "$(tr -d '\r\n' < /etc/release)"
    else
        echo "$(uname -a)"
    fi
}

symform_platform_string()
{
    if grep -q "com.symform.symform" /app.json >/dev/null 2>&1; then
        echo "seagate"
    elif which readyinfo >/dev/null 2>&1; then
    	echo "netgear"
    else
        echo "linux"
    fi
}

if [ "$(symform_platform_string)" = "seagate" ]; then
    export SYMFORM_WEB_UI_PORT="$RAINBOW_PORT_WEB_UI"
    export FORCE_CONTRIB_PORT="$RAINBOW_PORT_CONTRIBUTION"
    export FORCE_CONTRIB_PATH=/data/symformcontribution

    if [ -f "${WORKDIR}/node.config" ]; then
        sed -i 's/port="[^"]*"/port="'${FORCE_CONTRIB_PORT}'"/' "${WORKDIR}/node.config"
        sed -i 's/fragmentStorePath="[^"]*"/fragmentStorePath="'$(echo $FORCE_CONTRIB_PATH | sed -e 's/[\/&]/\\&/g')'"/' "${WORKDIR}/node.config"
    fi
fi

symform_arch()
{
    if uname -m | grep -qE '86_64$'; then
        echo x64
    elif uname -m | grep -qE '86$'; then
        echo x86
    elif uname -m | grep -qE '^arm'; then
        echo arm
    else
        echo "$(uname -m)"
    fi
}

list_root_directories()
{
    if [ "$(symform_platform_string)" = "seagate" ]; then
        for f in /shares/*; do
            [ -d "$f" ] && echo "$f"
        done
    elif [ "$(symform_platform_string)" = "netgear" ]; then
        for f in /data/*; do
            [ -d "$f" ] && echo "$f"
        done
    else
        for f in /*; do
            [ -d "$f" ] && [ "$f" != "/dev" ] && [ "$f" != "/lost+found" ] && [ "$f" != "/proc" ] && [ "$f" != "/sys" ] && echo "$f"
        done
    fi
}

## running unprivileged
# echo the name of the user that can be used to run unprivileged Symform services
unprivileged_user()
{
    echo "symform"
}

#
### Legacy
#
# install_update 
# signature_prefix
# symform_upgrade_extension
if [ -f /etc/debian_version ]; then
    export SYMFORM_UPGRADE_EXT=deb
    export SIGNATURE_PREFIX=deb_
elif [ -f /etc/redhat-release ]; then
    export SYMFORM_UPGRADE_EXT=rpm
    export SIGNATURE_PREFIX=rpm_
fi

install_update()
{
    case "$1" in
        *.deb)
            dpkg -i "$1"
            ;;
        *.rpm)
            if which yum >/dev/null 2>&1; then
                yum -y localinstall "$1"
            else
                rpm -i "$1"
            fi
            ;;
        *)
            echo "unknown extension for $1" 1>&2
            return 1
    esac
}
