#
# This script is sourced from Linux.sh.
#

# Systemd takes care of ensuring the services are running, but we still want
# contribution to get restarted.
WEBTASK=''
SYNCTASK=''

start_service()
{
    systemctl start symform${1}.service
}

stop_service()
{
    local n="symform${1}.service"
    [ -f "/usr/lib/systemd/system/$n" ] && systemctl stop "$n"
}

install_init_scripts()
{
    # make sure the services start on boot using the systemd init system
    local name src
    for src in "/opt/symform/scripts/platform/"*.systemd; do
        if [ -f "$src" ]; then
            name="$(basename "$src" .systemd).service"
            mkdir -p /usr/lib/systemd/system
            install -m 644 "$src" "/usr/lib/systemd/system/${name}"
            systemctl enable "$name"
        fi
    done
    systemctl --system daemon-reload
}
