adjust_firewall()
{
    local name action proto port update ports cfg_fn cfg_exists app_name

    name="$1"
    action="$2"
    proto="$3"
    port="$4"

    update=false
    ports=''

    cfg_fn="/etc/ufw/applications.d/Symform${name}"
    if [ -f "$cfg_fn" ]; then
        cfg_exists=true
        ports=`awk -F= -v action=$action -v port="${port}/${proto}" '
$1 == "ports" {
    found = 0
    rc = 1
    n = split($2, ports, "|")
    for (i in ports) {
        if (ports[i] == port) {
            if (action == "remove") {
                delete ports[i]
                n--
                rc = 0
            }
            found = 1
            break
        }
    }
    if (found == 0 && action == "add") {
        n++
        ports[n] = port
        rc = 0
    }
    result = ""
    if (n > 0) {
        sep = ""
        for (i in ports) {
            result = result sep ports[i]
            sep = "|"
        }
    }
    print result
    exit rc
}' "$cfg_fn"`
        [ $? -eq 0 ] && update=true
    else
        cfg_exists=false
        if [ "$action" = 'add' ]; then
            ports="${port}/${proto}"
            update=true
        fi
    fi

    if $update; then
        appname="Symform${name}"
        if [ -n "$ports" ]; then
            cat <<EOF >"$cfg_fn"
[${appname}]
title=${name} service for the Symform Cloud Storage Network
description=A distributed and crowdsourced online data backup solution
ports=${ports}
EOF
            if $cfg_exists; then
                ufw app update "$appname"
            else
                ufw allow "$appname"
            fi
        elif $cfg_exists; then
            ufw delete allow "$appname"
            rm "$cfg_fn"
        fi
    fi
}
